/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.model.expression;

import org.teavm.backend.wasm.model.expression.WasmArrayCopy;
import org.teavm.backend.wasm.model.expression.WasmArrayGet;
import org.teavm.backend.wasm.model.expression.WasmArrayLength;
import org.teavm.backend.wasm.model.expression.WasmArrayNewDefault;
import org.teavm.backend.wasm.model.expression.WasmArrayNewFixed;
import org.teavm.backend.wasm.model.expression.WasmArraySet;
import org.teavm.backend.wasm.model.expression.WasmBlock;
import org.teavm.backend.wasm.model.expression.WasmBranch;
import org.teavm.backend.wasm.model.expression.WasmBreak;
import org.teavm.backend.wasm.model.expression.WasmCall;
import org.teavm.backend.wasm.model.expression.WasmCallReference;
import org.teavm.backend.wasm.model.expression.WasmCast;
import org.teavm.backend.wasm.model.expression.WasmCastBranch;
import org.teavm.backend.wasm.model.expression.WasmCatch;
import org.teavm.backend.wasm.model.expression.WasmConditional;
import org.teavm.backend.wasm.model.expression.WasmConversion;
import org.teavm.backend.wasm.model.expression.WasmCopy;
import org.teavm.backend.wasm.model.expression.WasmDrop;
import org.teavm.backend.wasm.model.expression.WasmExpression;
import org.teavm.backend.wasm.model.expression.WasmExpressionVisitor;
import org.teavm.backend.wasm.model.expression.WasmExternConversion;
import org.teavm.backend.wasm.model.expression.WasmFill;
import org.teavm.backend.wasm.model.expression.WasmFloat32Constant;
import org.teavm.backend.wasm.model.expression.WasmFloat64Constant;
import org.teavm.backend.wasm.model.expression.WasmFloatBinary;
import org.teavm.backend.wasm.model.expression.WasmFloatUnary;
import org.teavm.backend.wasm.model.expression.WasmFunctionReference;
import org.teavm.backend.wasm.model.expression.WasmGetGlobal;
import org.teavm.backend.wasm.model.expression.WasmGetLocal;
import org.teavm.backend.wasm.model.expression.WasmIndirectCall;
import org.teavm.backend.wasm.model.expression.WasmInt31Get;
import org.teavm.backend.wasm.model.expression.WasmInt31Reference;
import org.teavm.backend.wasm.model.expression.WasmInt32Constant;
import org.teavm.backend.wasm.model.expression.WasmInt64Constant;
import org.teavm.backend.wasm.model.expression.WasmIntBinary;
import org.teavm.backend.wasm.model.expression.WasmIntUnary;
import org.teavm.backend.wasm.model.expression.WasmIsNull;
import org.teavm.backend.wasm.model.expression.WasmLoadFloat32;
import org.teavm.backend.wasm.model.expression.WasmLoadFloat64;
import org.teavm.backend.wasm.model.expression.WasmLoadInt32;
import org.teavm.backend.wasm.model.expression.WasmLoadInt64;
import org.teavm.backend.wasm.model.expression.WasmMemoryGrow;
import org.teavm.backend.wasm.model.expression.WasmNullBranch;
import org.teavm.backend.wasm.model.expression.WasmNullConstant;
import org.teavm.backend.wasm.model.expression.WasmReferencesEqual;
import org.teavm.backend.wasm.model.expression.WasmReturn;
import org.teavm.backend.wasm.model.expression.WasmSetGlobal;
import org.teavm.backend.wasm.model.expression.WasmSetLocal;
import org.teavm.backend.wasm.model.expression.WasmStoreFloat32;
import org.teavm.backend.wasm.model.expression.WasmStoreFloat64;
import org.teavm.backend.wasm.model.expression.WasmStoreInt32;
import org.teavm.backend.wasm.model.expression.WasmStoreInt64;
import org.teavm.backend.wasm.model.expression.WasmStructGet;
import org.teavm.backend.wasm.model.expression.WasmStructNew;
import org.teavm.backend.wasm.model.expression.WasmStructNewDefault;
import org.teavm.backend.wasm.model.expression.WasmStructSet;
import org.teavm.backend.wasm.model.expression.WasmSwitch;
import org.teavm.backend.wasm.model.expression.WasmTest;
import org.teavm.backend.wasm.model.expression.WasmThrow;
import org.teavm.backend.wasm.model.expression.WasmTry;
import org.teavm.backend.wasm.model.expression.WasmUnreachable;

public class WasmDefaultExpressionVisitor
implements WasmExpressionVisitor {
    @Override
    public void visit(WasmBlock expression) {
        for (WasmExpression part : expression.getBody()) {
            part.acceptVisitor(this);
        }
    }

    @Override
    public void visit(WasmBranch expression) {
        expression.getCondition().acceptVisitor(this);
        if (expression.getResult() != null) {
            expression.getResult().acceptVisitor(this);
        }
    }

    @Override
    public void visit(WasmNullBranch expression) {
        expression.getValue().acceptVisitor(this);
        if (expression.getResult() != null) {
            expression.getResult().acceptVisitor(this);
        }
    }

    @Override
    public void visit(WasmCastBranch expression) {
        expression.getValue().acceptVisitor(this);
        if (expression.getResult() != null) {
            expression.getResult().acceptVisitor(this);
        }
    }

    @Override
    public void visit(WasmBreak expression) {
        if (expression.getResult() != null) {
            expression.getResult().acceptVisitor(this);
        }
    }

    @Override
    public void visit(WasmSwitch expression) {
        expression.getSelector().acceptVisitor(this);
    }

    @Override
    public void visit(WasmConditional expression) {
        expression.getCondition().acceptVisitor(this);
        for (WasmExpression part : expression.getThenBlock().getBody()) {
            part.acceptVisitor(this);
        }
        for (WasmExpression part : expression.getElseBlock().getBody()) {
            part.acceptVisitor(this);
        }
    }

    @Override
    public void visit(WasmReturn expression) {
        if (expression.getValue() != null) {
            expression.getValue().acceptVisitor(this);
        }
    }

    @Override
    public void visit(WasmUnreachable expression) {
    }

    @Override
    public void visit(WasmInt32Constant expression) {
    }

    @Override
    public void visit(WasmInt64Constant expression) {
    }

    @Override
    public void visit(WasmFloat32Constant expression) {
    }

    @Override
    public void visit(WasmFloat64Constant expression) {
    }

    @Override
    public void visit(WasmNullConstant expression) {
    }

    @Override
    public void visit(WasmIsNull expression) {
        expression.getValue().acceptVisitor(this);
    }

    @Override
    public void visit(WasmGetLocal expression) {
    }

    @Override
    public void visit(WasmSetLocal expression) {
        expression.getValue().acceptVisitor(this);
    }

    @Override
    public void visit(WasmGetGlobal expression) {
    }

    @Override
    public void visit(WasmSetGlobal expression) {
        expression.getValue().acceptVisitor(this);
    }

    @Override
    public void visit(WasmIntBinary expression) {
        expression.getFirst().acceptVisitor(this);
        expression.getSecond().acceptVisitor(this);
    }

    @Override
    public void visit(WasmFloatBinary expression) {
        expression.getFirst().acceptVisitor(this);
        expression.getSecond().acceptVisitor(this);
    }

    @Override
    public void visit(WasmIntUnary expression) {
        expression.getOperand().acceptVisitor(this);
    }

    @Override
    public void visit(WasmFloatUnary expression) {
        expression.getOperand().acceptVisitor(this);
    }

    @Override
    public void visit(WasmConversion expression) {
        expression.getOperand().acceptVisitor(this);
    }

    @Override
    public void visit(WasmCall expression) {
        for (WasmExpression argument : expression.getArguments()) {
            argument.acceptVisitor(this);
        }
    }

    @Override
    public void visit(WasmIndirectCall expression) {
        expression.getSelector().acceptVisitor(this);
        for (WasmExpression argument : expression.getArguments()) {
            argument.acceptVisitor(this);
        }
    }

    @Override
    public void visit(WasmCallReference expression) {
        expression.getFunctionReference().acceptVisitor(this);
        for (WasmExpression argument : expression.getArguments()) {
            argument.acceptVisitor(this);
        }
    }

    @Override
    public void visit(WasmDrop expression) {
        expression.getOperand().acceptVisitor(this);
    }

    @Override
    public void visit(WasmLoadInt32 expression) {
        expression.getIndex().acceptVisitor(this);
    }

    @Override
    public void visit(WasmLoadInt64 expression) {
        expression.getIndex().acceptVisitor(this);
    }

    @Override
    public void visit(WasmLoadFloat32 expression) {
        expression.getIndex().acceptVisitor(this);
    }

    @Override
    public void visit(WasmLoadFloat64 expression) {
        expression.getIndex().acceptVisitor(this);
    }

    @Override
    public void visit(WasmStoreInt32 expression) {
        expression.getIndex().acceptVisitor(this);
        expression.getValue().acceptVisitor(this);
    }

    @Override
    public void visit(WasmStoreInt64 expression) {
        expression.getIndex().acceptVisitor(this);
        expression.getValue().acceptVisitor(this);
    }

    @Override
    public void visit(WasmStoreFloat32 expression) {
        expression.getIndex().acceptVisitor(this);
        expression.getValue().acceptVisitor(this);
    }

    @Override
    public void visit(WasmStoreFloat64 expression) {
        expression.getIndex().acceptVisitor(this);
        expression.getValue().acceptVisitor(this);
    }

    @Override
    public void visit(WasmMemoryGrow expression) {
        expression.getAmount().acceptVisitor(this);
    }

    @Override
    public void visit(WasmFill expression) {
        expression.getIndex().acceptVisitor(this);
        expression.getValue().acceptVisitor(this);
        expression.getCount().acceptVisitor(this);
    }

    @Override
    public void visit(WasmCopy expression) {
        expression.getDestinationIndex().acceptVisitor(this);
        expression.getSourceIndex().acceptVisitor(this);
        expression.getCount().acceptVisitor(this);
    }

    @Override
    public void visit(WasmTry expression) {
        for (WasmExpression part : expression.getBody()) {
            part.acceptVisitor(this);
        }
        for (WasmCatch catchClause : expression.getCatches()) {
            for (WasmExpression part : catchClause.getBody()) {
                part.acceptVisitor(this);
            }
        }
    }

    @Override
    public void visit(WasmThrow expression) {
        for (WasmExpression arg : expression.getArguments()) {
            arg.acceptVisitor(this);
        }
    }

    @Override
    public void visit(WasmReferencesEqual expression) {
        expression.getFirst().acceptVisitor(this);
        expression.getSecond().acceptVisitor(this);
    }

    @Override
    public void visit(WasmCast expression) {
        expression.getValue().acceptVisitor(this);
    }

    @Override
    public void visit(WasmTest expression) {
        expression.getValue().acceptVisitor(this);
    }

    @Override
    public void visit(WasmExternConversion expression) {
        expression.getValue().acceptVisitor(this);
    }

    @Override
    public void visit(WasmStructNew expression) {
        for (WasmExpression initializer : expression.getInitializers()) {
            initializer.acceptVisitor(this);
        }
    }

    @Override
    public void visit(WasmStructNewDefault expression) {
    }

    @Override
    public void visit(WasmStructGet expression) {
        expression.getInstance().acceptVisitor(this);
    }

    @Override
    public void visit(WasmStructSet expression) {
        expression.getInstance().acceptVisitor(this);
        expression.getValue().acceptVisitor(this);
    }

    @Override
    public void visit(WasmArrayNewDefault expression) {
        expression.getLength().acceptVisitor(this);
    }

    @Override
    public void visit(WasmArrayNewFixed expression) {
        for (WasmExpression element : expression.getElements()) {
            element.acceptVisitor(this);
        }
    }

    @Override
    public void visit(WasmArrayGet expression) {
        expression.getInstance().acceptVisitor(this);
        expression.getIndex().acceptVisitor(this);
    }

    @Override
    public void visit(WasmArraySet expression) {
        expression.getInstance().acceptVisitor(this);
        expression.getIndex().acceptVisitor(this);
        expression.getValue().acceptVisitor(this);
    }

    @Override
    public void visit(WasmArrayLength expression) {
        expression.getInstance().acceptVisitor(this);
    }

    @Override
    public void visit(WasmArrayCopy expression) {
        expression.getTargetArray().acceptVisitor(this);
        expression.getTargetIndex().acceptVisitor(this);
        expression.getSourceArray().acceptVisitor(this);
        expression.getSourceIndex().acceptVisitor(this);
        expression.getSize().acceptVisitor(this);
    }

    @Override
    public void visit(WasmFunctionReference expression) {
    }

    @Override
    public void visit(WasmInt31Reference expression) {
        expression.getValue().acceptVisitor(this);
    }

    @Override
    public void visit(WasmInt31Get expression) {
        expression.getValue().acceptVisitor(this);
    }
}

