/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.generate.gc.methods;

import java.util.List;
import org.teavm.backend.wasm.gc.vtable.WasmGCVirtualTable;
import org.teavm.backend.wasm.gc.vtable.WasmGCVirtualTableEntry;
import org.teavm.backend.wasm.gc.vtable.WasmGCVirtualTableProvider;
import org.teavm.backend.wasm.generate.gc.classes.WasmGCClassInfo;
import org.teavm.backend.wasm.generate.gc.classes.WasmGCClassInfoProvider;
import org.teavm.backend.wasm.model.WasmFunctionType;
import org.teavm.backend.wasm.model.WasmLocal;
import org.teavm.backend.wasm.model.WasmStructure;
import org.teavm.backend.wasm.model.WasmType;
import org.teavm.backend.wasm.model.expression.WasmCallReference;
import org.teavm.backend.wasm.model.expression.WasmCast;
import org.teavm.backend.wasm.model.expression.WasmExpression;
import org.teavm.backend.wasm.model.expression.WasmGetLocal;
import org.teavm.backend.wasm.model.expression.WasmStructGet;
import org.teavm.backend.wasm.model.expression.WasmUnreachable;
import org.teavm.model.MethodReference;

public class WasmGCVirtualCallGenerator {
    private WasmGCVirtualTableProvider virtualTables;
    private WasmGCClassInfoProvider classInfoProvider;

    public WasmGCVirtualCallGenerator(WasmGCVirtualTableProvider virtualTables, WasmGCClassInfoProvider classInfoProvider) {
        this.virtualTables = virtualTables;
        this.classInfoProvider = classInfoProvider;
    }

    public WasmExpression generate(MethodReference method, WasmLocal instance, List<WasmExpression> arguments) {
        WasmGCVirtualTable vtable = this.virtualTables.lookup(method.getClassName());
        if (vtable == null) {
            return new WasmUnreachable();
        }
        WasmGCVirtualTableEntry entry = vtable.entry(method.getDescriptor());
        WasmGCVirtualTable nonInterfaceAncestor = vtable.closestNonInterfaceAncestor();
        if (entry == null || nonInterfaceAncestor == null) {
            return new WasmUnreachable();
        }
        WasmGCClassInfo objectClass = this.classInfoProvider.getClassInfo("java.lang.Object");
        WasmExpression classRef = new WasmStructGet(objectClass.getStructure(), new WasmGetLocal(instance), 0);
        int index = 1 + entry.getIndex();
        WasmGCClassInfo expectedInstanceClassInfo = this.classInfoProvider.getClassInfo(vtable.getClassName());
        WasmStructure expectedInstanceClassStruct = this.classInfoProvider.getClassInfo(nonInterfaceAncestor.getClassName()).getStructure();
        WasmStructure vtableStruct = expectedInstanceClassInfo.getVirtualTableStructure();
        classRef = new WasmCast(classRef, vtableStruct.getNonNullReference());
        WasmStructGet functionRef = new WasmStructGet(vtableStruct, classRef, index);
        WasmType.CompositeReference functionTypeRef = (WasmType.CompositeReference)vtableStruct.getFields().get(index).getUnpackedType();
        WasmCallReference invoke = new WasmCallReference(functionRef, (WasmFunctionType)functionTypeRef.composite);
        WasmExpression instanceRef = new WasmGetLocal(instance);
        WasmType.CompositeReference instanceType = (WasmType.CompositeReference)instance.getType();
        WasmStructure instanceStruct = (WasmStructure)instanceType.composite;
        if (!expectedInstanceClassStruct.isSupertypeOf(instanceStruct)) {
            instanceRef = new WasmCast(instanceRef, expectedInstanceClassStruct.getNonNullReference());
        }
        invoke.getArguments().add(instanceRef);
        invoke.getArguments().addAll(arguments);
        return invoke;
    }
}

