/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.generate.gc.classes;

import org.teavm.backend.wasm.WasmFunctionTypes;
import org.teavm.backend.wasm.gc.vtable.WasmGCVirtualTable;
import org.teavm.backend.wasm.gc.vtable.WasmGCVirtualTableEntry;
import org.teavm.backend.wasm.gc.vtable.WasmGCVirtualTableProvider;
import org.teavm.backend.wasm.generate.gc.WasmGCNameProvider;
import org.teavm.backend.wasm.generate.gc.classes.WasmGCClassGenerator;
import org.teavm.backend.wasm.generate.gc.classes.WasmGCClassInfo;
import org.teavm.backend.wasm.generate.gc.classes.WasmGCStandardClasses;
import org.teavm.backend.wasm.model.WasmFunction;
import org.teavm.backend.wasm.model.WasmLocal;
import org.teavm.backend.wasm.model.WasmModule;
import org.teavm.backend.wasm.model.WasmStructure;
import org.teavm.backend.wasm.model.expression.WasmGetLocal;
import org.teavm.backend.wasm.model.expression.WasmStructSet;

class WasmGCSystemFunctionGenerator {
    private WasmGCClassGenerator classGenerator;
    private WasmModule module;
    private WasmFunctionTypes functionTypes;
    private WasmGCNameProvider names;
    private WasmGCVirtualTableProvider virtualTables;
    private WasmGCStandardClasses standardClasses;
    private WasmFunction objectVirtualTableFunction;

    WasmGCSystemFunctionGenerator(WasmGCClassGenerator classGenerator, WasmModule module, WasmFunctionTypes functionTypes, WasmGCNameProvider names, WasmGCVirtualTableProvider virtualTables, WasmGCStandardClasses standardClasses) {
        this.classGenerator = classGenerator;
        this.module = module;
        this.functionTypes = functionTypes;
        this.names = names;
        this.virtualTables = virtualTables;
        this.standardClasses = standardClasses;
    }

    WasmFunction getFillObjectVirtualTableFunction() {
        if (this.objectVirtualTableFunction == null) {
            this.objectVirtualTableFunction = this.createFillObjectVirtualTableFunction();
        }
        return this.objectVirtualTableFunction;
    }

    private WasmFunction createFillObjectVirtualTableFunction() {
        WasmGCClassInfo objectCls = this.standardClasses.objectClass();
        WasmStructure struct = objectCls.getVirtualTableStructure();
        WasmFunction function = new WasmFunction(this.functionTypes.of(null, struct.getNonNullReference(), this.standardClasses.classClass().getStructure().getNonNullReference()));
        function.setName(this.names.topLevel("teavm@objectVirtualTable"));
        WasmLocal vtParam = new WasmLocal(struct.getNonNullReference(), "vt");
        WasmLocal clsParam = new WasmLocal(this.standardClasses.classClass().getStructure().getNonNullReference());
        function.add(vtParam);
        function.add(clsParam);
        WasmGCVirtualTable virtualTable = this.virtualTables.lookup("java.lang.Object");
        for (int i = 0; i < virtualTable.getEntries().size(); ++i) {
            WasmGCVirtualTableEntry entry = virtualTable.getEntries().get(i);
            this.classGenerator.fillVirtualTableEntry(function.getBody(), () -> new WasmGetLocal(vtParam), struct, virtualTable, entry);
        }
        this.standardClasses.classClass().getStructure().init();
        function.getBody().add(new WasmStructSet(struct, new WasmGetLocal(vtParam), 0, new WasmGetLocal(clsParam)));
        function.getBody().add(new WasmStructSet(this.standardClasses.classClass().getStructure(), new WasmGetLocal(clsParam), this.classGenerator.getClassVtFieldOffset(), new WasmGetLocal(vtParam)));
        this.module.functions.add(function);
        return function;
    }
}

