/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.teavm.backend.wasm.BaseWasmFunctionRepository;
import org.teavm.backend.wasm.WasmDebugInfoLevel;
import org.teavm.backend.wasm.WasmDebugInfoLocation;
import org.teavm.backend.wasm.WasmFunctionTypes;
import org.teavm.backend.wasm.WasmGCModuleGenerator;
import org.teavm.backend.wasm.debug.CompositeDebugLines;
import org.teavm.backend.wasm.debug.DebugLines;
import org.teavm.backend.wasm.debug.ExternalDebugFile;
import org.teavm.backend.wasm.debug.GCDebugInfoBuilder;
import org.teavm.backend.wasm.debug.sourcemap.SourceMapBuilder;
import org.teavm.backend.wasm.gc.TeaVMWasmGCHost;
import org.teavm.backend.wasm.gc.WasmGCClassConsumer;
import org.teavm.backend.wasm.gc.WasmGCClassConsumerContext;
import org.teavm.backend.wasm.gc.WasmGCDependencies;
import org.teavm.backend.wasm.generate.gc.WasmGCDeclarationsGenerator;
import org.teavm.backend.wasm.generate.gc.WasmGCNameProvider;
import org.teavm.backend.wasm.generate.gc.classes.WasmGCCustomTypeMapperFactory;
import org.teavm.backend.wasm.generate.gc.classes.WasmGCTypeMapper;
import org.teavm.backend.wasm.generate.gc.strings.WasmGCStringProvider;
import org.teavm.backend.wasm.generators.gc.WasmGCCustomGenerator;
import org.teavm.backend.wasm.generators.gc.WasmGCCustomGeneratorFactory;
import org.teavm.backend.wasm.generators.gc.WasmGCCustomGenerators;
import org.teavm.backend.wasm.intrinsics.gc.WasmGCIntrinsic;
import org.teavm.backend.wasm.intrinsics.gc.WasmGCIntrinsicFactory;
import org.teavm.backend.wasm.intrinsics.gc.WasmGCIntrinsics;
import org.teavm.backend.wasm.model.WasmCompositeType;
import org.teavm.backend.wasm.model.WasmCustomSection;
import org.teavm.backend.wasm.model.WasmFunction;
import org.teavm.backend.wasm.model.WasmGlobal;
import org.teavm.backend.wasm.model.WasmLocal;
import org.teavm.backend.wasm.model.WasmMemorySegment;
import org.teavm.backend.wasm.model.WasmModule;
import org.teavm.backend.wasm.model.WasmStructure;
import org.teavm.backend.wasm.model.WasmTag;
import org.teavm.backend.wasm.model.WasmType;
import org.teavm.backend.wasm.model.expression.WasmGetLocal;
import org.teavm.backend.wasm.model.expression.WasmStructGet;
import org.teavm.backend.wasm.model.expression.WasmStructSet;
import org.teavm.backend.wasm.optimization.WasmUsageCounter;
import org.teavm.backend.wasm.render.WasmBinaryRenderer;
import org.teavm.backend.wasm.render.WasmBinaryStatsCollector;
import org.teavm.backend.wasm.render.WasmBinaryVersion;
import org.teavm.backend.wasm.render.WasmBinaryWriter;
import org.teavm.backend.wasm.runtime.StringInternPool;
import org.teavm.backend.wasm.transformation.gc.BaseClassesTransformation;
import org.teavm.backend.wasm.transformation.gc.ClassLoaderResourceTransformation;
import org.teavm.backend.wasm.transformation.gc.EntryPointTransformation;
import org.teavm.backend.wasm.transformation.gc.ReferenceQueueTransformation;
import org.teavm.dependency.DependencyAnalyzer;
import org.teavm.dependency.DependencyInfo;
import org.teavm.dependency.DependencyListener;
import org.teavm.dependency.MethodDependencyInfo;
import org.teavm.interop.Address;
import org.teavm.model.ClassHolderTransformer;
import org.teavm.model.ClassReaderSource;
import org.teavm.model.ListableClassHolderSource;
import org.teavm.model.MethodReader;
import org.teavm.model.MethodReference;
import org.teavm.model.Program;
import org.teavm.model.lowlevel.Characteristics;
import org.teavm.model.lowlevel.LowLevelNullCheckFilter;
import org.teavm.model.transformation.BoundCheckInsertion;
import org.teavm.model.transformation.NullCheckInsertion;
import org.teavm.model.util.VariableCategoryProvider;
import org.teavm.runtime.heap.Heap;
import org.teavm.vm.BuildTarget;
import org.teavm.vm.TeaVMTarget;
import org.teavm.vm.TeaVMTargetController;
import org.teavm.vm.spi.TeaVMHostExtension;

public class WasmGCTarget
implements TeaVMTarget,
TeaVMWasmGCHost {
    private TeaVMTargetController controller;
    private NullCheckInsertion nullCheckInsertion;
    private BoundCheckInsertion boundCheckInsertion = new BoundCheckInsertion();
    private boolean strict;
    private boolean obfuscated;
    private boolean debugInfo;
    private boolean compactMode;
    private SourceMapBuilder sourceMapBuilder;
    private String sourceMapLocation;
    private WasmDebugInfoLocation debugLocation = WasmDebugInfoLocation.EXTERNAL;
    private WasmDebugInfoLevel debugLevel = WasmDebugInfoLevel.FULL;
    private int bufferHeapMinSize = 0x200000;
    private int bufferHeapMaxSize = 0x2000000;
    private List<WasmGCIntrinsicFactory> intrinsicFactories = new ArrayList<WasmGCIntrinsicFactory>();
    private Map<MethodReference, WasmGCIntrinsic> customIntrinsics = new HashMap<MethodReference, WasmGCIntrinsic>();
    private List<WasmGCCustomTypeMapperFactory> customTypeMapperFactories = new ArrayList<WasmGCCustomTypeMapperFactory>();
    private Map<MethodReference, WasmGCCustomGenerator> customCustomGenerators = new HashMap<MethodReference, WasmGCCustomGenerator>();
    private List<WasmGCCustomGeneratorFactory> customGeneratorFactories = new ArrayList<WasmGCCustomGeneratorFactory>();
    private EntryPointTransformation entryPointTransformation = new EntryPointTransformation();
    private List<WasmGCClassConsumer> classConsumers = new ArrayList<WasmGCClassConsumer>();
    private List<Supplier<Collection<MethodReference>>> additionalMethodsOnCallSites = new ArrayList<Supplier<Collection<MethodReference>>>();

    public void setObfuscated(boolean obfuscated) {
        this.obfuscated = obfuscated;
    }

    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    public void setDebugInfo(boolean debug) {
        this.debugInfo = debug;
    }

    public void setDebugInfoLevel(WasmDebugInfoLevel debugLevel) {
        this.debugLevel = debugLevel;
    }

    public void setDebugInfoLocation(WasmDebugInfoLocation debugLocation) {
        this.debugLocation = debugLocation;
    }

    public void setSourceMapBuilder(SourceMapBuilder sourceMapBuilder) {
        this.sourceMapBuilder = sourceMapBuilder;
    }

    public void setSourceMapLocation(String sourceMapLocation) {
        this.sourceMapLocation = sourceMapLocation;
    }

    public void setBufferHeapMinSize(int bufferHeapMinSize) {
        this.bufferHeapMinSize = bufferHeapMinSize;
    }

    public void setBufferHeapMaxSize(int bufferHeapMaxSize) {
        this.bufferHeapMaxSize = bufferHeapMaxSize;
    }

    public void setCompactMode(boolean compactMode) {
        this.compactMode = compactMode;
    }

    @Override
    public void addIntrinsicFactory(WasmGCIntrinsicFactory intrinsicFactory) {
        this.intrinsicFactories.add(intrinsicFactory);
    }

    @Override
    public void addIntrinsic(MethodReference method, WasmGCIntrinsic intrinsic) {
        this.customIntrinsics.put(method, intrinsic);
    }

    @Override
    public void addGeneratorFactory(WasmGCCustomGeneratorFactory factory) {
        this.customGeneratorFactories.add(factory);
    }

    @Override
    public void addGenerator(MethodReference method, WasmGCCustomGenerator generator) {
        this.customCustomGenerators.put(method, generator);
    }

    @Override
    public void addCustomTypeMapperFactory(WasmGCCustomTypeMapperFactory customTypeMapperFactory) {
        this.customTypeMapperFactories.add(customTypeMapperFactory);
    }

    @Override
    public void addClassConsumer(WasmGCClassConsumer consumer) {
        this.classConsumers.add(consumer);
    }

    @Override
    public void addMethodsOnCallSites(Supplier<Collection<MethodReference>> methodsOnCallSites) {
        this.additionalMethodsOnCallSites.add(methodsOnCallSites);
    }

    @Override
    public void setController(TeaVMTargetController controller) {
        Characteristics characteristics = new Characteristics(controller.getUnprocessedClassSource());
        this.nullCheckInsertion = new NullCheckInsertion(new LowLevelNullCheckFilter(characteristics));
        this.controller = controller;
    }

    @Override
    public void setEntryPoint(String entryPoint, String name) {
        this.entryPointTransformation.setEntryPoint(entryPoint);
        this.entryPointTransformation.setEntryPointName(name);
    }

    @Override
    public VariableCategoryProvider variableCategoryProvider() {
        return null;
    }

    @Override
    public List<DependencyListener> getDependencyListeners() {
        return List.of();
    }

    @Override
    public List<ClassHolderTransformer> getTransformers() {
        return List.of(new BaseClassesTransformation(), new ClassLoaderResourceTransformation(), new ReferenceQueueTransformation(), this.entryPointTransformation);
    }

    @Override
    public void contributeDependencies(DependencyAnalyzer dependencyAnalyzer) {
        WasmGCDependencies deps = new WasmGCDependencies(dependencyAnalyzer);
        deps.contribute();
        deps.contributeStandardExports();
    }

    @Override
    public List<TeaVMHostExtension> getHostExtensions() {
        return List.of(this);
    }

    @Override
    public void beforeInlining(Program program, MethodReader method) {
        if (this.strict) {
            this.nullCheckInsertion.transformProgram(program, method.getReference());
        }
    }

    @Override
    public void beforeOptimizations(Program program, MethodReader method) {
        if (this.strict) {
            this.boundCheckInsertion.transformProgram(program, method.getReference());
        }
    }

    @Override
    public void afterOptimizations(Program program, MethodReader method) {
    }

    @Override
    public String[] getPlatformTags() {
        return new String[]{"webassembly-gc"};
    }

    @Override
    public boolean isAsyncSupported() {
        return false;
    }

    @Override
    public void emit(ListableClassHolderSource classes, BuildTarget buildTarget, String outputName) throws IOException {
        boolean buffersHeap;
        WasmModule module = new WasmModule();
        module.memoryExportName = "teavm.memory";
        WasmGCCustomGenerators customGenerators = new WasmGCCustomGenerators(classes, this.controller.getServices(), this.customGeneratorFactories, this.customCustomGenerators, this.controller.getProperties());
        WasmGCIntrinsics intrinsics = new WasmGCIntrinsics(classes, this.controller.getServices(), this.intrinsicFactories, this.customIntrinsics);
        GCDebugInfoBuilder debugInfoBuilder = new GCDebugInfoBuilder();
        LinkedHashSet<MethodReference> methodsOnCallSites = new LinkedHashSet<MethodReference>();
        for (Supplier<Collection<MethodReference>> provider : this.additionalMethodsOnCallSites) {
            methodsOnCallSites.addAll(provider.get());
        }
        WasmGCDeclarationsGenerator declarationsGenerator = new WasmGCDeclarationsGenerator(module, classes, this.controller.getUnprocessedClassSource(), this.controller.getClassLoader(), this.controller.getClassInitializerInfo(), this.controller.getDependencyInfo(), this.controller.getDiagnostics(), customGenerators, intrinsics, this.customTypeMapperFactories, this.controller::isVirtual, this.strict, this.controller.getEntryPoint(), methodsOnCallSites);
        declarationsGenerator.setFriendlyToDebugger(this.controller.isFriendlyToDebugger());
        declarationsGenerator.setCompactMode(this.compactMode);
        WasmGCModuleGenerator moduleGenerator = new WasmGCModuleGenerator(declarationsGenerator);
        WasmGCClassConsumerContext classConsumerContext = this.createClassConsumerContext(classes, declarationsGenerator);
        for (String cls : classes.getClassNames()) {
            for (WasmGCClassConsumer consumer : this.classConsumers) {
                consumer.accept(classConsumerContext, cls);
            }
        }
        MethodDependencyInfo internMethod = this.controller.getDependencyInfo().getMethod(new MethodReference(String.class, "intern", String.class));
        if (internMethod != null && internMethod.isUsed()) {
            WasmFunction removeStringEntryFunction = moduleGenerator.generateReportGarbageCollectedStringFunction();
            removeStringEntryFunction.setExportName("teavm.reportGarbageCollectedString");
        }
        MethodReference exceptionMessageRef = new MethodReference(Throwable.class, "getMessage", Throwable.class);
        if (this.controller.getDependencyInfo().getMethod(exceptionMessageRef) != null) {
            WasmFunction exceptionMessageFunction = declarationsGenerator.functions().forInstanceMethod(exceptionMessageRef);
            exceptionMessageFunction.setExportName("teavm.exceptionMessage");
        }
        MethodReference refQueueSupplyRef = new MethodReference(ReferenceQueue.class, "supply", Reference.class, Void.TYPE);
        if (this.controller.getDependencyInfo().getMethod(refQueueSupplyRef) != null) {
            WasmFunction refQueueSupplyFunction = declarationsGenerator.functions().forInstanceMethod(refQueueSupplyRef);
            refQueueSupplyFunction.setExportName("teavm.reportGarbageCollectedValue");
        }
        if (buffersHeap = WasmGCTarget.needsBuffersHeap(this.controller.getDependencyInfo())) {
            declarationsGenerator.functions().forStaticMethod(new MethodReference(Heap.class, "init", Address.class, Integer.TYPE, Integer.TYPE, Void.TYPE));
        }
        moduleGenerator.generate();
        customGenerators.contributeToModule(module);
        this.generateExceptionExports(declarationsGenerator);
        this.adjustModuleMemory(module, moduleGenerator, buffersHeap);
        this.emitWasmFile(module, buildTarget, outputName, debugInfoBuilder);
    }

    private void generateExceptionExports(WasmGCDeclarationsGenerator declarationsGenerator) {
        int nativeExceptionField = declarationsGenerator.classInfoProvider().getThrowableNativeOffset();
        if (nativeExceptionField < 0) {
            return;
        }
        WasmStructure throwableType = declarationsGenerator.classInfoProvider().getClassInfo("java.lang.Throwable").getStructure();
        WasmFunction getFunction = new WasmFunction(declarationsGenerator.functionTypes.of(WasmType.Reference.EXTERN, throwableType.getReference()));
        getFunction.setName("teavm.getJsException");
        getFunction.setExportName("teavm.getJsException");
        WasmLocal getParam = new WasmLocal(throwableType.getReference(), "javaException");
        getFunction.add(getParam);
        WasmStructGet getField = new WasmStructGet(throwableType, new WasmGetLocal(getParam), nativeExceptionField);
        getFunction.getBody().add(getField);
        declarationsGenerator.module.functions.add(getFunction);
        WasmFunction setFunction = new WasmFunction(declarationsGenerator.functionTypes.of(null, throwableType.getReference(), WasmType.Reference.EXTERN));
        setFunction.setName("teavm.setJsException");
        setFunction.setExportName("teavm.setJsException");
        WasmLocal setParam = new WasmLocal(throwableType.getReference(), "javaException");
        WasmLocal setValue = new WasmLocal(WasmType.Reference.EXTERN, "jsException");
        setFunction.add(setParam);
        setFunction.add(setValue);
        WasmStructSet setField = new WasmStructSet(throwableType, new WasmGetLocal(setParam), nativeExceptionField, new WasmGetLocal(setValue));
        setFunction.getBody().add(setField);
        declarationsGenerator.module.functions.add(setFunction);
    }

    private WasmGCClassConsumerContext createClassConsumerContext(final ClassReaderSource classes, final WasmGCDeclarationsGenerator generator) {
        return new WasmGCClassConsumerContext(){

            @Override
            public ClassReaderSource classes() {
                return classes;
            }

            @Override
            public WasmModule module() {
                return generator.module;
            }

            @Override
            public WasmFunctionTypes functionTypes() {
                return generator.functionTypes;
            }

            @Override
            public BaseWasmFunctionRepository functions() {
                return generator.functions();
            }

            @Override
            public WasmGCNameProvider names() {
                return generator.names();
            }

            @Override
            public WasmGCStringProvider strings() {
                return generator.strings();
            }

            @Override
            public WasmGCTypeMapper typeMapper() {
                return generator.typeMapper();
            }

            @Override
            public WasmTag exceptionTag() {
                return generator.exceptionTag();
            }

            @Override
            public String entryPoint() {
                return WasmGCTarget.this.controller.getEntryPoint();
            }

            @Override
            public void addToInitializer(Consumer<WasmFunction> initializerContributor) {
                generator.addToInitializer(initializerContributor);
            }
        };
    }

    private void adjustModuleMemory(WasmModule module, WasmGCModuleGenerator moduleGenerator, boolean buffersHeap) {
        int memorySize = 0;
        for (WasmMemorySegment segment : module.getSegments()) {
            memorySize = Math.max(memorySize, segment.getOffset() + segment.getLength());
        }
        int maxMemorySize = memorySize;
        if (buffersHeap) {
            memorySize = ((memorySize - 1) / 256 + 1) * 256;
            moduleGenerator.initBuffersHeap(memorySize, this.bufferHeapMinSize, this.bufferHeapMaxSize);
            maxMemorySize = memorySize + this.bufferHeapMaxSize;
            memorySize += this.bufferHeapMinSize;
        }
        if (maxMemorySize == 0) {
            return;
        }
        int pages = (memorySize - 1) / 65536 + 1;
        module.setMinMemorySize(pages);
        pages = (maxMemorySize - 1) / 65536 + 1;
        module.setMaxMemorySize(pages);
    }

    private static boolean needsBuffersHeap(DependencyInfo dependencyInfo) {
        return dependencyInfo.getReachableMethods().stream().anyMatch(m -> m.getClassName().equals(Heap.class.getName()) && !m.getName().equals("init"));
    }

    private void emitWasmFile(WasmModule module, BuildTarget buildTarget, String outputName, GCDebugInfoBuilder debugInfoBuilder) throws IOException {
        byte[] debugInfoData;
        WasmBinaryWriter binaryWriter = new WasmBinaryWriter();
        DebugLines debugLines = null;
        if (this.debugInfo) {
            debugLines = this.sourceMapBuilder != null ? new CompositeDebugLines(debugInfoBuilder.lines(), this.sourceMapBuilder) : debugInfoBuilder.lines();
        } else if (this.sourceMapBuilder != null) {
            debugLines = this.sourceMapBuilder;
        }
        if (!((String)outputName).endsWith(".wasm")) {
            outputName = (String)outputName + ".wasm";
        }
        if (this.sourceMapBuilder != null && this.sourceMapLocation != null) {
            WasmBinaryWriter sourceMapBinding = new WasmBinaryWriter();
            sourceMapBinding.writeAsciiString(this.sourceMapLocation);
            WasmCustomSection sourceMapSection = new WasmCustomSection("sourceMappingURL", sourceMapBinding.getData());
            module.add(sourceMapSection);
        }
        WasmBinaryRenderer binaryRenderer = new WasmBinaryRenderer(binaryWriter, WasmBinaryVersion.V_0x1, this.obfuscated, null, null, debugLines, null, WasmBinaryStatsCollector.EMPTY);
        this.optimizeIndexes(module);
        module.prepareForRendering();
        if (this.debugLocation == WasmDebugInfoLocation.EMBEDDED && this.debugInfo) {
            binaryRenderer.render(module, debugInfoBuilder::build);
        } else {
            binaryRenderer.render(module);
        }
        byte[] data = binaryWriter.getData();
        try (OutputStream output = buildTarget.createResource((String)outputName);){
            output.write(data);
        }
        if (this.debugLocation == WasmDebugInfoLocation.EXTERNAL && this.debugInfo && (debugInfoData = ExternalDebugFile.write(debugInfoBuilder.build())) != null) {
            try (OutputStream output = buildTarget.createResource((String)outputName + ".teadbg");){
                output.write(debugInfoData);
            }
        }
    }

    private void optimizeIndexes(WasmModule module) {
        WasmUsageCounter usageCounter = new WasmUsageCounter();
        usageCounter.applyToModule(module);
        module.functions.sort(Comparator.comparingInt(f -> -usageCounter.usages((WasmFunction)f)));
        module.globals.sort(Comparator.comparingInt(g -> -usageCounter.usages((WasmGlobal)g)));
        module.types.sort(Comparator.comparingInt(t -> -usageCounter.usages((WasmCompositeType)t)));
    }

    @Override
    public boolean needsSystemArrayCopyOptimization() {
        return false;
    }

    @Override
    public boolean filterClassInitializer(String initializer) {
        return !initializer.equals(StringInternPool.class.getName());
    }
}

