/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.c.generate;

import org.teavm.backend.c.generate.FileNameProvider;
import org.teavm.model.ValueType;

public class SimpleFileNameProvider
implements FileNameProvider {
    @Override
    public String fileName(String className) {
        StringBuilder sb = new StringBuilder("classes/");
        SimpleFileNameProvider.escape(className, sb);
        return sb.toString();
    }

    @Override
    public String fileName(ValueType type) {
        StringBuilder sb = new StringBuilder();
        SimpleFileNameProvider.fileNameRec(type, sb);
        return sb.toString();
    }

    private static void fileNameRec(ValueType type, StringBuilder sb) {
        if (type instanceof ValueType.Object) {
            sb.append("classes/");
            SimpleFileNameProvider.escape(((ValueType.Object)type).getClassName(), sb);
        } else if (type instanceof ValueType.Array) {
            sb.append("arrays/");
            SimpleFileNameProvider.fileNameRec(((ValueType.Array)type).getItemType(), sb);
        } else if (type instanceof ValueType.Primitive) {
            sb.append("primitives/");
            switch (((ValueType.Primitive)type).getKind()) {
                case BOOLEAN: {
                    sb.append("boolean");
                    break;
                }
                case BYTE: {
                    sb.append("byte");
                    break;
                }
                case SHORT: {
                    sb.append("short");
                    break;
                }
                case CHARACTER: {
                    sb.append("char");
                    break;
                }
                case INTEGER: {
                    sb.append("int");
                    break;
                }
                case LONG: {
                    sb.append("long");
                    break;
                }
                case FLOAT: {
                    sb.append("float");
                    break;
                }
                case DOUBLE: {
                    sb.append("double");
                }
            }
        } else if (type == ValueType.VOID) {
            sb.append("primitives/void");
        }
    }

    @Override
    public String escapeName(String name) {
        StringBuilder sb = new StringBuilder();
        SimpleFileNameProvider.escape(name, sb);
        return sb.toString();
    }

    private static void escape(String className, StringBuilder sb) {
        block14: for (int i = 0; i < className.length(); ++i) {
            char c = className.charAt(i);
            switch (c) {
                case '.': {
                    sb.append('/');
                    continue block14;
                }
                case '@': {
                    sb.append("@@");
                    continue block14;
                }
                case '/': {
                    sb.append("@s");
                    continue block14;
                }
                case '\\': {
                    sb.append("@b");
                    continue block14;
                }
                case ':': {
                    sb.append("@c");
                    continue block14;
                }
                case ';': {
                    sb.append("@e");
                    continue block14;
                }
                case '*': {
                    sb.append("@m");
                    continue block14;
                }
                case '\"': {
                    sb.append("@q");
                    continue block14;
                }
                case '<': {
                    sb.append("@l");
                    continue block14;
                }
                case '>': {
                    sb.append("@g");
                    continue block14;
                }
                case '|': {
                    sb.append("@p");
                    continue block14;
                }
                case '$': {
                    sb.append("@d");
                    continue block14;
                }
                default: {
                    sb.append(c);
                }
            }
        }
    }
}

