/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.runtime.heap;

import org.teavm.interop.StaticInit;
import org.teavm.interop.Unmanaged;
import org.teavm.runtime.heap.HeapRecord;

@Unmanaged
@StaticInit
class HeapNode
extends HeapRecord {
    static final int FLAG_LIST = 1;
    HeapNode left;
    HeapNode right;
    HeapNode list;
    short height;
    short flags;

    HeapNode() {
    }

    static HeapNode balance(HeapNode node) {
        int factor = HeapNode.factor(node);
        if (factor == 2) {
            if (HeapNode.factor(node.right) < 0) {
                node.right = HeapNode.rotateRight(node.right);
            }
            return HeapNode.rotateLeft(node);
        }
        if (factor == -2) {
            if (HeapNode.factor(node.left) > 0) {
                node.left = HeapNode.rotateLeft(node.left);
            }
            return HeapNode.rotateRight(node);
        }
        return node;
    }

    private static int factor(HeapNode node) {
        return (node.right != null ? node.right.height : (short)0) - (node.left != null ? node.left.height : (short)0);
    }

    private static HeapNode rotateRight(HeapNode node) {
        HeapNode left = node.left;
        node.left = left.right;
        left.right = node;
        HeapNode.fix(node);
        HeapNode.fix(left);
        return left;
    }

    private static HeapNode rotateLeft(HeapNode node) {
        HeapNode right = node.right;
        node.right = right.left;
        right.left = node;
        HeapNode.fix(node);
        HeapNode.fix(right);
        return right;
    }

    static void fix(HeapNode node) {
        short leftHeight = node.right != null ? node.right.height : (short)0;
        short rightHeight = node.left != null ? node.left.height : (short)0;
        node.height = (short)(Math.max(leftHeight, rightHeight) + 1);
    }
}

