/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.parsing;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import org.teavm.interop.Remove;
import org.teavm.interop.Rename;
import org.teavm.interop.Superclass;
import org.teavm.model.AnnotationContainer;
import org.teavm.model.AnnotationHolder;
import org.teavm.model.AnnotationValue;
import org.teavm.model.BasicBlock;
import org.teavm.model.ClassHolder;
import org.teavm.model.FieldHolder;
import org.teavm.model.FieldReference;
import org.teavm.model.GenericTypeParameter;
import org.teavm.model.GenericValueType;
import org.teavm.model.Instruction;
import org.teavm.model.InvokeDynamicInstruction;
import org.teavm.model.MethodDescriptor;
import org.teavm.model.MethodHandle;
import org.teavm.model.MethodHolder;
import org.teavm.model.Program;
import org.teavm.model.ReferenceCache;
import org.teavm.model.RuntimeConstant;
import org.teavm.model.TryCatchBlock;
import org.teavm.model.ValueType;
import org.teavm.model.instructions.AbstractInstructionVisitor;
import org.teavm.model.instructions.CastInstruction;
import org.teavm.model.instructions.ClassConstantInstruction;
import org.teavm.model.instructions.ConstructArrayInstruction;
import org.teavm.model.instructions.ConstructInstruction;
import org.teavm.model.instructions.ConstructMultiArrayInstruction;
import org.teavm.model.instructions.GetFieldInstruction;
import org.teavm.model.instructions.InitClassInstruction;
import org.teavm.model.instructions.InvokeInstruction;
import org.teavm.model.instructions.IsInstanceInstruction;
import org.teavm.model.instructions.PutFieldInstruction;

public class ClassRefsRenamer
extends AbstractInstructionVisitor {
    private ReferenceCache referenceCache;
    private Function<String, String> classNameMapper;

    public ClassRefsRenamer(ReferenceCache referenceCache, Function<String, String> classNameMapper) {
        this.referenceCache = referenceCache;
        this.classNameMapper = classNameMapper;
    }

    public ClassHolder rename(ClassHolder cls) {
        ClassHolder renamedCls = new ClassHolder(this.classNameMapper.apply(cls.getName()));
        renamedCls.getModifiers().addAll(cls.getModifiers());
        renamedCls.setLevel(cls.getLevel());
        String parent = cls.getParent();
        AnnotationHolder superclassAnnot = cls.getAnnotations().get(Superclass.class.getName());
        if (superclassAnnot != null && (parent = superclassAnnot.getValues().get("value").getString()).isEmpty()) {
            parent = null;
        }
        renamedCls.setParent(parent != null ? this.classNameMapper.apply(parent) : null);
        if (renamedCls.getName().equals(renamedCls.getParent())) {
            renamedCls.setParent(null);
        }
        for (MethodHolder method : cls.getMethods()) {
            if (method.getAnnotations().get(Remove.class.getName()) != null) continue;
            renamedCls.addMethod(this.rename(method));
        }
        for (FieldHolder field : cls.getFields().toArray(new FieldHolder[0])) {
            renamedCls.addField(this.rename(field));
        }
        if (cls.getOwnerName() != null) {
            renamedCls.setOwnerName(this.classNameMapper.apply(cls.getOwnerName()));
        }
        if (cls.getDeclaringClassName() != null) {
            renamedCls.setDeclaringClassName(this.classNameMapper.apply(cls.getDeclaringClassName()));
        }
        this.rename(cls.getAnnotations(), renamedCls.getAnnotations());
        for (String iface : cls.getInterfaces()) {
            String mappedIfaceName = this.classNameMapper.apply(iface);
            if (mappedIfaceName.equals(renamedCls.getName())) continue;
            renamedCls.getInterfaces().add(mappedIfaceName);
        }
        GenericValueType.Object genericParent = cls.getGenericParent();
        if (genericParent != null) {
            renamedCls.setGenericParent((GenericValueType.Object)this.rename(genericParent));
        }
        for (GenericValueType.Object genericInterface : cls.getGenericInterfaces()) {
            renamedCls.getGenericInterfaces().add((GenericValueType.Object)this.rename(genericInterface));
        }
        renamedCls.setGenericParameters(cls.getGenericParameters());
        for (String innerClass : cls.getInnerClasses()) {
            renamedCls.getInnerClasses().add(this.classNameMapper.apply(innerClass));
        }
        return renamedCls;
    }

    public MethodHolder rename(MethodHolder method) {
        String methodName = method.getName();
        AnnotationHolder renameAnnot = method.getAnnotations().get(Rename.class.getName());
        if (renameAnnot != null) {
            methodName = renameAnnot.getValues().get("value").getString();
        }
        ValueType[] signature = method.getSignature();
        for (int i = 0; i < signature.length; ++i) {
            signature[i] = this.rename(signature[i]);
        }
        MethodHolder renamedMethod = new MethodHolder(this.referenceCache.getCached(new MethodDescriptor(methodName, signature)));
        renamedMethod.getModifiers().addAll(method.getModifiers());
        renamedMethod.setLevel(method.getLevel());
        renamedMethod.setProgram(method.getProgram());
        this.rename(method.getAnnotations(), renamedMethod.getAnnotations());
        for (int i = 0; i < method.parameterCount(); ++i) {
            this.rename(method.parameterAnnotation(i), renamedMethod.parameterAnnotation(i));
        }
        if (renamedMethod.getProgram() != null) {
            this.rename(renamedMethod.getProgram());
        }
        renamedMethod.setTypeParameters(this.rename(method.getTypeParameters()));
        GenericValueType genericResultType = method.getGenericResultType();
        if (genericResultType != null) {
            genericResultType = this.rename(method.getGenericResultType());
        }
        GenericValueType[] genericParameters = new GenericValueType[method.genericParameterCount()];
        for (int i = 0; i < genericParameters.length; ++i) {
            genericParameters[i] = this.rename(method.genericParameterType(i));
        }
        if (genericResultType != null) {
            renamedMethod.setGenericSignature(genericResultType, genericParameters);
        }
        return renamedMethod;
    }

    private GenericTypeParameter[] rename(GenericTypeParameter[] typeParameters) {
        for (int i = 0; i < typeParameters.length; ++i) {
            typeParameters[i] = this.rename(typeParameters[i]);
        }
        return typeParameters;
    }

    private GenericTypeParameter rename(GenericTypeParameter typeParameter) {
        GenericValueType.Reference classBound = typeParameter.getClassBound();
        if (classBound != null) {
            classBound = (GenericValueType.Reference)this.rename(classBound);
        }
        GenericValueType.Reference[] interfaceBounds = typeParameter.getInterfaceBounds();
        for (int j = 0; j < interfaceBounds.length; ++j) {
            interfaceBounds[j] = (GenericValueType.Reference)this.rename(interfaceBounds[j]);
        }
        return new GenericTypeParameter(typeParameter.getName(), classBound, interfaceBounds);
    }

    public FieldHolder rename(FieldHolder field) {
        FieldHolder renamedField = new FieldHolder(field.getName());
        renamedField.getModifiers().addAll(field.getModifiers());
        renamedField.setLevel(field.getLevel());
        renamedField.setType(this.rename(field.getType()));
        renamedField.setInitialValue(field.getInitialValue());
        this.rename(field.getAnnotations(), renamedField.getAnnotations());
        GenericValueType genericType = field.getGenericType();
        if (genericType != null) {
            renamedField.setGenericType(this.rename(genericType));
        }
        return renamedField;
    }

    private ValueType rename(ValueType type) {
        if (type instanceof ValueType.Array) {
            ValueType itemType = ((ValueType.Array)type).getItemType();
            return this.referenceCache.getCached(ValueType.arrayOf(this.rename(itemType)));
        }
        if (type instanceof ValueType.Object) {
            String className = ((ValueType.Object)type).getClassName();
            return this.referenceCache.getCached(ValueType.object(this.classNameMapper.apply(className)));
        }
        return type;
    }

    private GenericValueType rename(GenericValueType type) {
        if (type instanceof GenericValueType.Array) {
            GenericValueType itemType = ((GenericValueType.Array)type).getItemType();
            return this.referenceCache.getCached(new GenericValueType.Array(this.rename(itemType)));
        }
        if (type instanceof GenericValueType.Object) {
            GenericValueType.Object object = (GenericValueType.Object)type;
            String className = this.classNameMapper.apply(object.getClassName());
            GenericValueType.Object parent = object.getParent();
            if (parent != null) {
                parent = (GenericValueType.Object)this.rename(parent);
            }
            GenericValueType.Argument[] arguments = object.getArguments();
            block5: for (int i = 0; i < arguments.length; ++i) {
                GenericValueType.Argument argument = arguments[i];
                GenericValueType.Reference value = argument.getValue();
                if (value != null) {
                    value = (GenericValueType.Reference)this.rename(value);
                }
                switch (argument.getKind()) {
                    case INVARIANT: {
                        arguments[i] = GenericValueType.Argument.invariant(value);
                        continue block5;
                    }
                    case COVARIANT: {
                        arguments[i] = GenericValueType.Argument.covariant(value);
                        continue block5;
                    }
                    case CONTRAVARIANT: {
                        arguments[i] = GenericValueType.Argument.contravariant(value);
                        continue block5;
                    }
                }
            }
            return this.referenceCache.getCached(new GenericValueType.Object(parent, className, arguments));
        }
        return type;
    }

    private ValueType[] rename(ValueType[] types) {
        return (ValueType[])Arrays.stream(types).map(this::rename).toArray(ValueType[]::new);
    }

    private RuntimeConstant rename(RuntimeConstant cst) {
        switch (cst.getKind()) {
            case 5: {
                return new RuntimeConstant(this.rename(cst.getValueType()));
            }
            case 6: {
                return new RuntimeConstant(this.rename(cst.getMethodType()));
            }
            case 7: {
                return new RuntimeConstant(this.rename(cst.getMethodHandle()));
            }
        }
        return cst;
    }

    private MethodHandle rename(MethodHandle handle) {
        switch (handle.getKind()) {
            case GET_FIELD: {
                return MethodHandle.fieldGetter(this.classNameMapper.apply(handle.getClassName()), handle.getName(), this.rename(handle.getValueType()));
            }
            case GET_STATIC_FIELD: {
                return MethodHandle.staticFieldGetter(this.classNameMapper.apply(handle.getClassName()), handle.getName(), this.rename(handle.getValueType()));
            }
            case PUT_FIELD: {
                return MethodHandle.fieldSetter(this.classNameMapper.apply(handle.getClassName()), handle.getName(), this.rename(handle.getValueType()));
            }
            case PUT_STATIC_FIELD: {
                return MethodHandle.staticFieldSetter(this.classNameMapper.apply(handle.getClassName()), handle.getName(), this.rename(handle.getValueType()));
            }
            case INVOKE_VIRTUAL: {
                return MethodHandle.virtualCaller(this.classNameMapper.apply(handle.getClassName()), handle.getName(), this.rename(handle.signature()));
            }
            case INVOKE_STATIC: {
                return MethodHandle.staticCaller(this.classNameMapper.apply(handle.getClassName()), handle.getName(), this.rename(handle.signature()));
            }
            case INVOKE_SPECIAL: {
                return MethodHandle.specialCaller(this.classNameMapper.apply(handle.getClassName()), handle.getName(), this.rename(handle.signature()));
            }
            case INVOKE_CONSTRUCTOR: {
                return MethodHandle.constructorCaller(this.classNameMapper.apply(handle.getClassName()), handle.getName(), this.rename(handle.signature()));
            }
            case INVOKE_INTERFACE: {
                return MethodHandle.interfaceCaller(this.classNameMapper.apply(handle.getClassName()), handle.getName(), this.rename(handle.signature()));
            }
        }
        throw new IllegalArgumentException("Unknown method handle type: " + String.valueOf((Object)handle.getKind()));
    }

    private void rename(AnnotationContainer source, AnnotationContainer target) {
        for (AnnotationHolder annot : source.all()) {
            if (annot.getType().equals(Rename.class.getName()) || annot.getType().equals(Superclass.class.getName())) continue;
            target.add(this.rename(annot));
        }
    }

    private AnnotationHolder rename(AnnotationHolder annot) {
        AnnotationHolder renamedAnnot = new AnnotationHolder(this.classNameMapper.apply(annot.getType()));
        for (Map.Entry<String, AnnotationValue> entry : annot.getValues().entrySet()) {
            renamedAnnot.getValues().put(entry.getKey(), entry.getValue());
        }
        return renamedAnnot;
    }

    public void rename(Program program) {
        for (int i = 0; i < program.basicBlockCount(); ++i) {
            BasicBlock basicBlock = program.basicBlockAt(i);
            for (Instruction insn : basicBlock) {
                insn.acceptVisitor(this);
            }
            for (TryCatchBlock tryCatch : basicBlock.getTryCatchBlocks()) {
                if (tryCatch.getExceptionType() == null) continue;
                tryCatch.setExceptionType(this.classNameMapper.apply(tryCatch.getExceptionType()));
            }
        }
    }

    @Override
    public void visit(ClassConstantInstruction insn) {
        insn.setConstant(this.rename(insn.getConstant()));
    }

    @Override
    public void visit(CastInstruction insn) {
        insn.setTargetType(this.rename(insn.getTargetType()));
    }

    @Override
    public void visit(ConstructArrayInstruction insn) {
        insn.setItemType(this.rename(insn.getItemType()));
    }

    @Override
    public void visit(ConstructInstruction insn) {
        insn.setType(this.classNameMapper.apply(insn.getType()));
    }

    @Override
    public void visit(ConstructMultiArrayInstruction insn) {
        insn.setItemType(this.rename(insn.getItemType()));
    }

    @Override
    public void visit(GetFieldInstruction insn) {
        String className = this.classNameMapper.apply(insn.getField().getClassName());
        insn.setField(this.referenceCache.getCached(new FieldReference(className, insn.getField().getFieldName())));
        insn.setFieldType(this.rename(insn.getFieldType()));
    }

    @Override
    public void visit(PutFieldInstruction insn) {
        String className = this.classNameMapper.apply(insn.getField().getClassName());
        if (className != insn.getField().getClassName()) {
            insn.setField(this.referenceCache.getCached(new FieldReference(className, insn.getField().getFieldName())));
        }
        insn.setFieldType(this.rename(insn.getFieldType()));
    }

    @Override
    public void visit(InvokeInstruction insn) {
        String className = this.classNameMapper.apply(insn.getMethod().getClassName());
        ValueType[] signature = insn.getMethod().getSignature();
        boolean changed = true;
        for (int i = 0; i < signature.length; ++i) {
            ValueType type = signature[i];
            ValueType newType = this.rename(type);
            if (newType != null) {
                changed = true;
            }
            signature[i] = newType;
        }
        if (changed) {
            insn.setMethod(this.referenceCache.getCached(className, new MethodDescriptor(insn.getMethod().getName(), signature)));
        }
    }

    @Override
    public void visit(InvokeDynamicInstruction insn) {
        int i;
        ValueType[] signature = insn.getMethod().getSignature();
        for (i = 0; i < signature.length; ++i) {
            signature[i] = this.rename(signature[i]);
        }
        insn.setMethod(new MethodDescriptor(insn.getMethod().getName(), signature));
        for (i = 0; i < insn.getBootstrapArguments().size(); ++i) {
            insn.getBootstrapArguments().set(i, this.rename(insn.getBootstrapArguments().get(i)));
        }
    }

    @Override
    public void visit(IsInstanceInstruction insn) {
        insn.setType(this.rename(insn.getType()));
    }

    @Override
    public void visit(InitClassInstruction insn) {
        insn.setClassName(this.classNameMapper.apply(insn.getClassName()));
    }
}

