/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.model.optimization;

import org.teavm.model.BasicBlock;
import org.teavm.model.Incoming;
import org.teavm.model.Program;
import org.teavm.model.Variable;
import org.teavm.model.optimization.MethodOptimization;
import org.teavm.model.optimization.MethodOptimizationContext;
import org.teavm.model.util.InstructionVariableMapper;

public class RedundantPhiElimination
implements MethodOptimization {
    @Override
    public boolean optimize(MethodOptimizationContext context, Program program) {
        boolean changed = false;
        int[] map = new int[program.variableCount()];
        for (int i = 0; i < map.length; ++i) {
            map[i] = i;
        }
        for (BasicBlock block : program.getBasicBlocks()) {
            changed |= block.getPhis().removeIf(phi -> {
                if (phi.getIncomings().isEmpty()) {
                    return true;
                }
                Variable singleInput = null;
                for (Incoming incoming : phi.getIncomings()) {
                    if (incoming.getValue() == phi.getReceiver()) continue;
                    if (singleInput == null) {
                        singleInput = incoming.getValue();
                        continue;
                    }
                    if (singleInput == incoming.getValue()) continue;
                    return false;
                }
                if (singleInput != null) {
                    map[phi.getReceiver().getIndex()] = map[singleInput.getIndex()];
                }
                return true;
            });
        }
        if (changed) {
            InstructionVariableMapper mapper = new InstructionVariableMapper(v -> program.variableAt(RedundantPhiElimination.map(map, v.getIndex())));
            for (BasicBlock block : program.getBasicBlocks()) {
                mapper.apply(block);
            }
        }
        return changed;
    }

    private static int map(int[] array, int index) {
        int result = array[index];
        if (result != index) {
            int newResult = RedundantPhiElimination.map(array, result);
            if (newResult != result) {
                array[index] = newResult;
            }
            result = newResult;
        }
        return result;
    }
}

