/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.model.classes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.teavm.common.Graph;
import org.teavm.common.GraphBuilder;
import org.teavm.common.LCATree;
import org.teavm.hppc.IntArrayList;
import org.teavm.hppc.ObjectIntHashMap;
import org.teavm.hppc.ObjectIntMap;
import org.teavm.hppc.cursors.IntCursor;
import org.teavm.model.AccessLevel;
import org.teavm.model.BasicBlock;
import org.teavm.model.ClassHolder;
import org.teavm.model.ClassReader;
import org.teavm.model.ElementModifier;
import org.teavm.model.Instruction;
import org.teavm.model.ListableClassHolderSource;
import org.teavm.model.ListableClassReaderSource;
import org.teavm.model.MethodDescriptor;
import org.teavm.model.MethodHolder;
import org.teavm.model.MethodReader;
import org.teavm.model.MethodReference;
import org.teavm.model.Program;
import org.teavm.model.classes.VirtualTable;
import org.teavm.model.classes.VirtualTableEntry;
import org.teavm.model.classes.VirtualTableProvider;
import org.teavm.model.instructions.CloneArrayInstruction;
import org.teavm.model.instructions.InvocationType;
import org.teavm.model.instructions.InvokeInstruction;
import org.teavm.model.util.GraphColorer;

public class VirtualTableBuilder {
    private ListableClassReaderSource classes;
    private Map<String, List<MethodDescriptor>> methodsUsedAtCallSites = new HashMap<String, List<MethodDescriptor>>();
    private Predicate<MethodReference> methodCalledVirtually = m -> true;
    private Map<String, TableBuilder> tables;
    private Map<String, List<String>> classChildren;
    private LCATree classTree;
    private ObjectIntMap<String> classTreeIndexes;
    private List<String> classList;
    private VirtualTableProvider result;
    private List<MethodDescriptor> methodDescriptors;
    private ObjectIntMap<MethodDescriptor> methodDescriptorIndexes;
    private int[] methodColors;
    private int methodColorCount;

    public VirtualTableBuilder(ListableClassReaderSource classes) {
        this.classes = classes;
    }

    public void setMethodsUsedAtCallSites(Collection<? extends MethodReference> methodsUsedAtCallSites) {
        for (MethodReference methodReference : methodsUsedAtCallSites) {
            this.methodsUsedAtCallSites.computeIfAbsent(methodReference.getClassName(), k -> new ArrayList()).add(methodReference.getDescriptor());
        }
    }

    public void setMethodCalledVirtually(Predicate<MethodReference> methodCalledVirtually) {
        this.methodCalledVirtually = methodCalledVirtually;
    }

    public VirtualTableProvider build() {
        this.tables = new HashMap<String, TableBuilder>();
        this.buildVirtualTables();
        this.cleanupVirtualTables();
        this.classChildren = new HashMap<String, List<String>>();
        this.buildClassChildren();
        this.pack();
        this.liftEntries();
        this.buildResult();
        this.tables = null;
        return this.result;
    }

    private void buildVirtualTables() {
        for (String className : this.classes.getClassNames()) {
            this.fillClass(className);
        }
    }

    private void fillClass(String className) {
        ClassReader cls = this.classes.get(className);
        if (cls == null) {
            return;
        }
        if (this.tables.containsKey(className)) {
            return;
        }
        TableBuilder table = new TableBuilder();
        this.tables.put(className, table);
        String parent = cls.getParent();
        if (parent != null) {
            this.fillClass(parent);
            TableBuilder parentTable = this.tables.get(parent);
            if (parentTable != null) {
                this.copyEntries(parentTable, table);
            }
        }
        for (String itf : cls.getInterfaces()) {
            this.fillClass(itf);
            TableBuilder tableBuilder = this.tables.get(itf);
            if (tableBuilder == null) continue;
            this.copyEntries(tableBuilder, table);
        }
        List<MethodDescriptor> methodsAtCallSites = this.methodsUsedAtCallSites.get(className);
        if (methodsAtCallSites != null) {
            for (MethodDescriptor methodDescriptor : methodsAtCallSites) {
                MethodReader method = cls.getMethod(methodDescriptor);
                if (method != null && method.getLevel() == AccessLevel.PRIVATE) continue;
                table.entries.computeIfAbsent(methodDescriptor, k -> new EntryBuilder());
            }
        }
        for (MethodReader methodReader : cls.getMethods()) {
            if (methodReader.hasModifier(ElementModifier.ABSTRACT) || methodReader.hasModifier(ElementModifier.STATIC) || methodReader.getName().equals("<init>") || methodReader.getLevel() == AccessLevel.PRIVATE) continue;
            EntryBuilder entry = table.entries.get(methodReader.getDescriptor());
            if (entry == null) {
                if (cls.hasModifier(ElementModifier.FINAL)) continue;
                entry = new EntryBuilder();
                table.entries.put(methodReader.getDescriptor(), entry);
            }
            entry.implementor = methodReader.getReference();
        }
    }

    private void copyEntries(TableBuilder source, TableBuilder target) {
        for (Map.Entry<MethodDescriptor, EntryBuilder> entry : source.entries.entrySet()) {
            EntryBuilder targetEntry = target.entries.computeIfAbsent(entry.getKey(), k -> new EntryBuilder());
            targetEntry.addParent(entry.getValue());
            if (entry.getValue().implementor == null || targetEntry.implementor != null) continue;
            targetEntry.implementor = entry.getValue().implementor;
        }
    }

    private void cleanupVirtualTables() {
        for (String className : this.classes.getClassNames()) {
            TableBuilder table = this.tables.get(className);
            for (MethodDescriptor method : table.entries.keySet().toArray(new MethodDescriptor[0])) {
                EntryBuilder entry = table.entries.get(method);
                if (entry.implementor == null || this.methodCalledVirtually.test(entry.implementor)) continue;
                entry.implementor = null;
            }
        }
    }

    private void buildClassChildren() {
        for (String className : this.classes.getClassNames()) {
            ClassReader cls = this.classes.get(className);
            if (cls.hasModifier(ElementModifier.INTERFACE) || cls.getParent() == null) continue;
            this.classChildren.computeIfAbsent(cls.getParent(), c -> new ArrayList()).add(className);
        }
    }

    private void liftEntries() {
        this.buildClassTree();
        for (Map.Entry<MethodDescriptor, List<String>> group : this.groupMethods().entrySet()) {
            String commonSuperclass = this.commonSuperclass(group.getValue());
            HashSet<String> visited = new HashSet<String>();
            for (String cls : group.getValue()) {
                this.liftEntriesAtTable(cls, commonSuperclass, group.getKey(), visited);
            }
        }
        this.classTree = null;
        this.classTreeIndexes = null;
        this.classList = null;
    }

    private void buildClassTree() {
        this.classTree = new LCATree(this.classes.getClassNames().size());
        this.classTreeIndexes = new ObjectIntHashMap();
        this.classList = new ArrayList<String>();
        this.classList.add(null);
        for (String className : this.classes.getClassNames()) {
            ClassReader cls = this.classes.get(className);
            if (cls.hasModifier(ElementModifier.INTERFACE)) continue;
            this.insertClassToTree(className);
        }
    }

    private int insertClassToTree(String className) {
        int index = this.classTreeIndexes.getOrDefault((Object)className, 0);
        if (index == 0) {
            ClassReader cls = this.classes.get(className);
            int parent = cls != null && cls.getParent() != null ? this.insertClassToTree(cls.getParent()) : 0;
            index = this.classTree.addNode(parent);
            this.classList.add(className);
            this.classTreeIndexes.put((Object)className, index);
        }
        return index;
    }

    private String commonSuperclass(List<String> classNames) {
        int result = this.classTreeIndexes.get((Object)classNames.get(0));
        for (int i = 1; i < classNames.size(); ++i) {
            int next = this.classTreeIndexes.get((Object)classNames.get(i));
            result = this.classTree.lcaOf(result, next);
        }
        return this.classList.get(result);
    }

    private Map<MethodDescriptor, List<String>> groupMethods() {
        LinkedHashMap<MethodDescriptor, List<String>> groups = new LinkedHashMap<MethodDescriptor, List<String>>();
        for (String className : this.classes.getClassNames()) {
            ClassReader cls = this.classes.get(className);
            if (cls.hasModifier(ElementModifier.INTERFACE)) continue;
            TableBuilder table = this.tables.get(className);
            TableBuilder parentTable = cls.getParent() != null ? this.tables.get(cls.getParent()) : null;
            for (MethodDescriptor method : table.entries.keySet()) {
                EntryBuilder parentEntry;
                EntryBuilder entry2 = table.entries.get(method);
                if (entry2.implementor == null || parentTable != null && (parentEntry = parentTable.entries.get(method)) != null && entry2.implementor.equals(parentEntry.implementor)) continue;
                groups.computeIfAbsent(method, k -> new ArrayList()).add(className);
            }
        }
        groups.entrySet().removeIf(entry -> ((List)entry.getValue()).size() == 1);
        return groups;
    }

    private void liftEntriesAtTable(String className, String toClass, MethodDescriptor method, Set<String> visited) {
        TableBuilder table;
        while (visited.add(className) && (table = this.tables.get(className)) != null) {
            ClassReader cls;
            EntryBuilder entry = table.entries.get(method);
            if (entry == null) {
                entry = new EntryBuilder();
                entry.fake = true;
                table.entries.put(method, entry);
            }
            if (className.equals(toClass) || (cls = this.classes.get(className)) == null) break;
            className = cls.getParent();
        }
    }

    private void pack() {
        this.methodDescriptorIndexes = new ObjectIntHashMap();
        this.methodDescriptors = new ArrayList<MethodDescriptor>();
        GraphBuilder graphBuilder = new GraphBuilder();
        for (String className : this.classes.getClassNames()) {
            TableBuilder table = this.tables.get(className);
            MethodDescriptor[] methods = table.entries.keySet().toArray(new MethodDescriptor[0]);
            for (int i = 0; i < methods.length; ++i) {
                for (int j = i + 1; j < methods.length; ++j) {
                    int a = this.getMethodIndex(methods[i]);
                    int b = this.getMethodIndex(methods[j]);
                    graphBuilder.addEdge(a, b);
                    graphBuilder.addEdge(b, a);
                }
            }
        }
        Graph interferenceGraph = graphBuilder.build();
        this.methodColors = new int[this.methodDescriptors.size()];
        Arrays.fill(this.methodColors, -1);
        new GraphColorer().colorize(interferenceGraph, this.methodColors);
        int colorCount = 0;
        int i = 0;
        while (i < this.methodColors.length) {
            int n = i++;
            int n2 = this.methodColors[n];
            this.methodColors[n] = n2 - 1;
            colorCount = Math.max(colorCount, n2);
        }
        this.methodColorCount = colorCount;
    }

    private int getMethodIndex(MethodDescriptor method) {
        int index = this.methodDescriptorIndexes.getOrDefault((Object)method, -1);
        if (index < 0) {
            index = this.methodDescriptors.size();
            this.methodDescriptors.add(method);
            this.methodDescriptorIndexes.put((Object)method, index);
        }
        return index;
    }

    private void buildResult() {
        this.result = new VirtualTableProvider();
        this.buildResultForClasses();
        this.buildResultForInterfaces();
    }

    private void buildResultForClasses() {
        for (String className : this.classes.getClassNames()) {
            ClassReader cls = this.classes.get(className);
            if (cls.hasModifier(ElementModifier.INTERFACE) || cls.getParent() != null) continue;
            Context context = new Context();
            context.indexes = new int[this.methodColorCount];
            Arrays.fill(context.indexes, -1);
            this.buildResultForClass(className, context, null);
        }
    }

    private void buildResultForClass(String className, Context context, VirtualTable parent) {
        int initialMethodsStart;
        TableBuilder table = this.tables.get(className);
        ClassReader cls = this.classes.get(className);
        int colorsStart = context.colors.size();
        int methodsStart = initialMethodsStart = parent != null ? parent.size() : 0;
        IntArrayList resolvedIndexes = new IntArrayList();
        HashMap<MethodDescriptor, VirtualTableEntry> resultEntries = new HashMap<MethodDescriptor, VirtualTableEntry>();
        block0: for (MethodDescriptor method : table.entries.keySet()) {
            int color = this.methodColors[this.methodDescriptorIndexes.get((Object)method)];
            EntryBuilder entry = table.entries.get(method);
            int index = context.indexes[color];
            if (index < 0) {
                context.indexes[color] = index = context.colors.size();
                context.colors.add(color);
                context.methods.add(null);
            }
            if (entry.implementor != null) {
                VirtualTableEntry resultEntry = new VirtualTableEntry(method, entry.implementor, index);
                resultEntries.put(method, resultEntry);
                this.propagateInterfaceIndexes(cls, method, index);
            }
            if (context.methods.get(index) != null || entry.fake) continue;
            context.methods.set(index, method);
            resolvedIndexes.add(index);
            while (index < methodsStart) {
                methodsStart -= parent.getMethods().size();
                if ((parent = parent.getParent()) != null) continue;
                continue block0;
            }
        }
        List<MethodDescriptor> newMethods = context.methods.subList(methodsStart, context.methods.size());
        HashSet<MethodDescriptor> methodSet = new HashSet<MethodDescriptor>();
        for (MethodDescriptor method : newMethods) {
            if (method == null) continue;
            methodSet.add(method);
        }
        List<MethodDescriptor> readonlyNewMethods = Collections.unmodifiableList(Arrays.asList(newMethods.toArray(new MethodDescriptor[0])));
        VirtualTable resultTable = new VirtualTable(className, parent, readonlyNewMethods, methodSet, resultEntries);
        this.result.virtualTables.put(className, resultTable);
        List<String> children = this.classChildren.get(className);
        if (children != null) {
            for (String child : children) {
                this.buildResultForClass(child, context, resultTable);
            }
        }
        for (int i = colorsStart; i < context.colors.size(); ++i) {
            context.indexes[context.colors.get((int)i)] = -1;
        }
        context.colors.removeRange(colorsStart, context.colors.size());
        for (IntCursor resolvedIndex : resolvedIndexes) {
            context.methods.set(resolvedIndex.value, null);
        }
        context.methods.subList(initialMethodsStart, context.methods.size()).clear();
    }

    private void propagateInterfaceIndexes(ClassReader cls, MethodDescriptor method, int index) {
        TableBuilder table;
        EntryBuilder entry;
        do {
            for (String itf : cls.getInterfaces()) {
                EntryBuilder itfEntry;
                TableBuilder itfTable = this.tables.get(itf);
                if (itfTable == null || (itfEntry = itfTable.entries.get(method)) == null) continue;
                this.propagateInterfaceIndex(itfEntry, index);
            }
            if (cls.getParent() == null || (cls = this.classes.get(cls.getParent())) == null) break;
            table = this.tables.get(cls.getName());
        } while ((entry = table.entries.get(method)) != null && entry.implementor == null);
    }

    private void propagateInterfaceIndex(EntryBuilder entry, int index) {
        if (entry.index >= 0) {
            return;
        }
        entry.index = index;
        if (entry.parents != null) {
            for (EntryBuilder parent : entry.parents) {
                this.propagateInterfaceIndex(parent, index);
            }
        }
    }

    private void buildResultForInterfaces() {
        for (String className : this.classes.getClassNames()) {
            ClassReader cls = this.classes.get(className);
            if (!cls.hasModifier(ElementModifier.INTERFACE)) continue;
            ArrayList<MethodDescriptor> methods = new ArrayList<MethodDescriptor>();
            HashSet<MethodDescriptor> methodSet = new HashSet<MethodDescriptor>();
            TableBuilder table = this.tables.get(className);
            for (MethodDescriptor method : table.entries.keySet()) {
                EntryBuilder entry = table.entries.get(method);
                if (entry.index < 0) continue;
                if (entry.index >= methods.size()) {
                    methods.addAll(Collections.nCopies(entry.index - methods.size() + 1, null));
                }
                methods.set(entry.index, method);
                methodSet.add(method);
            }
            List<MethodDescriptor> readonlyMethods = Collections.unmodifiableList(Arrays.asList(methods.toArray(new MethodDescriptor[0])));
            VirtualTable resultTable = new VirtualTable(className, null, readonlyMethods, methodSet, Map.of());
            this.result.virtualTables.put(className, resultTable);
        }
    }

    public static Set<MethodReference> getMethodsUsedOnCallSites(ListableClassHolderSource classes, boolean withCloneArray) {
        HashSet<MethodReference> virtualMethods = new HashSet<MethodReference>();
        for (String className : classes.getClassNames()) {
            ClassHolder cls = classes.get(className);
            for (MethodHolder method : cls.getMethods()) {
                Program program = method.getProgram();
                if (program == null) continue;
                for (int i = 0; i < program.basicBlockCount(); ++i) {
                    BasicBlock block = program.basicBlockAt(i);
                    for (Instruction insn : block) {
                        if (insn instanceof InvokeInstruction) {
                            InvokeInstruction invoke = (InvokeInstruction)insn;
                            if (invoke.getType() != InvocationType.VIRTUAL) continue;
                            virtualMethods.add(invoke.getMethod());
                            continue;
                        }
                        if (!(insn instanceof CloneArrayInstruction) || !withCloneArray) continue;
                        virtualMethods.add(new MethodReference(Object.class, "clone", Object.class));
                    }
                }
            }
        }
        return virtualMethods;
    }

    static class TableBuilder {
        Map<MethodDescriptor, EntryBuilder> entries = new LinkedHashMap<MethodDescriptor, EntryBuilder>();

        TableBuilder() {
        }
    }

    static class EntryBuilder {
        MethodReference implementor;
        EntryBuilder[] parents;
        int index = -1;
        boolean fake;

        EntryBuilder() {
        }

        void addParent(EntryBuilder parent) {
            if (this.parents == null) {
                this.parents = new EntryBuilder[]{parent};
            } else {
                this.parents = Arrays.copyOf(this.parents, this.parents.length + 1);
                this.parents[this.parents.length - 1] = parent;
            }
        }
    }

    static class Context {
        int[] indexes;
        IntArrayList colors = new IntArrayList();
        List<MethodDescriptor> methods = new ArrayList<MethodDescriptor>();

        Context() {
        }
    }
}

