/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.diagnostics;

import java.io.Serializable;
import java.util.Arrays;
import org.teavm.diagnostics.ProblemSeverity;
import org.teavm.diagnostics.ProblemTextConsumer;
import org.teavm.model.CallLocation;
import org.teavm.model.FieldReference;
import org.teavm.model.MethodReference;
import org.teavm.model.TextLocation;
import org.teavm.model.ValueType;

public class Problem
implements Serializable {
    private ProblemSeverity severity;
    private CallLocation location;
    private String text;
    private Object[] params;

    public Problem(ProblemSeverity severity, CallLocation location, String text, Object[] params) {
        this.severity = severity;
        this.location = location;
        this.text = text;
        this.params = Arrays.copyOf(params, params.length);
    }

    public ProblemSeverity getSeverity() {
        return this.severity;
    }

    public CallLocation getLocation() {
        return this.location;
    }

    public String getText() {
        return this.text;
    }

    public Object[] getParams() {
        return this.params;
    }

    public void render(ProblemTextConsumer consumer) {
        int next;
        int index = 0;
        while (index < this.text.length() && (next = this.text.indexOf("{{", index)) >= 0) {
            consumer.append(this.text.substring(index, next));
            index = this.parseParameter(consumer, next);
            if (index != next) continue;
            consumer.append("{{");
            index += 2;
        }
        consumer.append(this.text.substring(index));
    }

    private int parseParameter(ProblemTextConsumer consumer, int index) {
        ParamType type;
        int next = index + 2;
        if (next >= this.text.length()) {
            return index;
        }
        switch (Character.toLowerCase(this.text.charAt(next++))) {
            case 'c': {
                type = ParamType.CLASS;
                break;
            }
            case 't': {
                type = ParamType.TYPE;
                break;
            }
            case 'm': {
                type = ParamType.METHOD;
                break;
            }
            case 'f': {
                type = ParamType.FIELD;
                break;
            }
            case 'l': {
                type = ParamType.LOCATION;
                break;
            }
            default: {
                return index;
            }
        }
        int digitsEnd = this.skipDigits(next);
        if (digitsEnd == next) {
            return index;
        }
        int paramIndex = Integer.parseInt(this.text.substring(next, digitsEnd));
        if (paramIndex >= this.params.length) {
            return index;
        }
        next = digitsEnd;
        if (next + 1 >= this.text.length() || !this.text.substring(next, next + 2).equals("}}")) {
            return index;
        }
        Object param = this.params[paramIndex];
        switch (type.ordinal()) {
            case 0: {
                if (!(param instanceof String)) {
                    return index;
                }
                consumer.appendClass((String)param);
                break;
            }
            case 1: {
                if (!(param instanceof ValueType)) {
                    return index;
                }
                consumer.appendType((ValueType)param);
                break;
            }
            case 2: {
                if (!(param instanceof MethodReference)) {
                    return index;
                }
                consumer.appendMethod((MethodReference)param);
                break;
            }
            case 3: {
                if (!(param instanceof FieldReference)) {
                    return index;
                }
                consumer.appendField((FieldReference)param);
                break;
            }
            case 4: {
                if (!(param instanceof TextLocation)) {
                    return index;
                }
                consumer.appendLocation((TextLocation)param);
            }
        }
        return next += 2;
    }

    private int skipDigits(int index) {
        while (index < this.text.length() && Character.isDigit(this.text.charAt(index))) {
            ++index;
        }
        return index;
    }

    static enum ParamType {
        CLASS,
        TYPE,
        METHOD,
        FIELD,
        LOCATION;

    }
}

