/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.transformation.gc;

import org.teavm.model.AnnotationHolder;
import org.teavm.model.AnnotationValue;
import org.teavm.model.ClassHolder;
import org.teavm.model.ClassHolderTransformer;
import org.teavm.model.ClassHolderTransformerContext;
import org.teavm.model.MethodDescriptor;
import org.teavm.model.MethodHolder;

public class EntryPointTransformation
implements ClassHolderTransformer {
    private static final MethodDescriptor MAIN_METHOD = new MethodDescriptor("main", String[].class, Void.TYPE);
    private String entryPoint;
    private String entryPointName;

    public void setEntryPoint(String entryPoint) {
        this.entryPoint = entryPoint;
    }

    public void setEntryPointName(String entryPointName) {
        this.entryPointName = entryPointName;
    }

    @Override
    public void transformClass(ClassHolder cls, ClassHolderTransformerContext context) {
        MethodHolder mainMethod;
        if (cls.getName().equals(this.entryPoint) && (mainMethod = cls.getMethod(MAIN_METHOD)) != null) {
            mainMethod.getAnnotations().add(new AnnotationHolder("org.teavm.jso.JSExport"));
            AnnotationHolder methodAnnot = new AnnotationHolder("org.teavm.jso.JSMethod");
            methodAnnot.getValues().put("value", new AnnotationValue(this.entryPointName));
        }
    }
}

