/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.model.expression;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.teavm.backend.wasm.model.WasmFunctionType;
import org.teavm.backend.wasm.model.expression.WasmExpression;
import org.teavm.backend.wasm.model.expression.WasmExpressionVisitor;

public class WasmCallReference
extends WasmExpression {
    private WasmFunctionType type;
    private WasmExpression functionReference;
    private List<WasmExpression> arguments = new ArrayList<WasmExpression>();

    public WasmCallReference(WasmExpression functionReference, WasmFunctionType type) {
        this.functionReference = Objects.requireNonNull(functionReference);
        this.type = Objects.requireNonNull(type);
    }

    public WasmCallReference(WasmExpression functionReference, WasmFunctionType type, WasmExpression ... arguments) {
        this(functionReference, type);
        this.getArguments().addAll(List.of(arguments));
    }

    public WasmExpression getFunctionReference() {
        return this.functionReference;
    }

    public void setFunctionReference(WasmExpression functionReference) {
        this.functionReference = Objects.requireNonNull(functionReference);
    }

    public List<WasmExpression> getArguments() {
        return this.arguments;
    }

    public WasmFunctionType getType() {
        return this.type;
    }

    public void setType(WasmFunctionType type) {
        this.type = Objects.requireNonNull(type);
    }

    @Override
    public void acceptVisitor(WasmExpressionVisitor visitor) {
        visitor.visit(this);
    }
}

