/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.intrinsics.gc;

import org.teavm.ast.InvocationExpr;
import org.teavm.backend.wasm.WasmRuntime;
import org.teavm.backend.wasm.intrinsics.gc.WasmGCIntrinsic;
import org.teavm.backend.wasm.intrinsics.gc.WasmGCIntrinsicContext;
import org.teavm.backend.wasm.model.WasmNumType;
import org.teavm.backend.wasm.model.expression.WasmCall;
import org.teavm.backend.wasm.model.expression.WasmConversion;
import org.teavm.backend.wasm.model.expression.WasmExpression;
import org.teavm.backend.wasm.model.expression.WasmIntBinary;
import org.teavm.backend.wasm.model.expression.WasmIntBinaryOperation;
import org.teavm.backend.wasm.model.expression.WasmIntType;
import org.teavm.backend.wasm.model.expression.WasmIntUnary;
import org.teavm.backend.wasm.model.expression.WasmIntUnaryOperation;
import org.teavm.model.MethodReference;

public class IntNumIntrinsic
implements WasmGCIntrinsic {
    private final MethodReference compareUnsigned;
    private final WasmIntType wasmType;

    public IntNumIntrinsic(Class<?> javaType, WasmIntType wasmType) {
        this.compareUnsigned = new MethodReference(WasmRuntime.class, "compareUnsigned", javaType, javaType, Integer.TYPE);
        this.wasmType = wasmType;
    }

    @Override
    public WasmExpression apply(InvocationExpr invocation, WasmGCIntrinsicContext context) {
        switch (invocation.getMethod().getName()) {
            case "divideUnsigned": {
                return new WasmIntBinary(this.wasmType, WasmIntBinaryOperation.DIV_UNSIGNED, context.generate(invocation.getArguments().get(0)), context.generate(invocation.getArguments().get(1)));
            }
            case "remainderUnsigned": {
                return new WasmIntBinary(this.wasmType, WasmIntBinaryOperation.REM_UNSIGNED, context.generate(invocation.getArguments().get(0)), context.generate(invocation.getArguments().get(1)));
            }
            case "compareUnsigned": {
                return new WasmCall(context.functions().forStaticMethod(this.compareUnsigned), context.generate(invocation.getArguments().get(0)), context.generate(invocation.getArguments().get(1)));
            }
            case "numberOfLeadingZeros": {
                return this.castToInt(new WasmIntUnary(this.wasmType, WasmIntUnaryOperation.CLZ, context.generate(invocation.getArguments().get(0))));
            }
            case "numberOfTrailingZeros": {
                return this.castToInt(new WasmIntUnary(this.wasmType, WasmIntUnaryOperation.CTZ, context.generate(invocation.getArguments().get(0))));
            }
            case "bitCount": {
                return this.castToInt(new WasmIntUnary(this.wasmType, WasmIntUnaryOperation.POPCNT, context.generate(invocation.getArguments().get(0))));
            }
        }
        throw new AssertionError();
    }

    private WasmExpression castToInt(WasmExpression expr) {
        if (this.wasmType == WasmIntType.INT64) {
            return new WasmConversion(WasmNumType.INT64, WasmNumType.INT32, false, expr);
        }
        return expr;
    }
}

