/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.intrinsics.gc;

import org.teavm.ast.InvocationExpr;
import org.teavm.backend.wasm.generate.CachedExpression;
import org.teavm.backend.wasm.intrinsics.gc.WasmGCIntrinsic;
import org.teavm.backend.wasm.intrinsics.gc.WasmGCIntrinsicContext;
import org.teavm.backend.wasm.model.WasmNumType;
import org.teavm.backend.wasm.model.WasmType;
import org.teavm.backend.wasm.model.expression.WasmBlock;
import org.teavm.backend.wasm.model.expression.WasmConversion;
import org.teavm.backend.wasm.model.expression.WasmExpression;
import org.teavm.backend.wasm.model.expression.WasmFloat32Constant;
import org.teavm.backend.wasm.model.expression.WasmFloatBinary;
import org.teavm.backend.wasm.model.expression.WasmFloatBinaryOperation;
import org.teavm.backend.wasm.model.expression.WasmFloatType;
import org.teavm.backend.wasm.model.expression.WasmInt32Constant;
import org.teavm.backend.wasm.model.expression.WasmIntBinary;
import org.teavm.backend.wasm.model.expression.WasmIntBinaryOperation;
import org.teavm.backend.wasm.model.expression.WasmIntType;

public class FloatIntrinsic
implements WasmGCIntrinsic {
    private static final int EXPONENT_BITS = 2139095040;
    private static final int FRACTION_BITS = 0x7FFFFF;

    @Override
    public WasmExpression apply(InvocationExpr invocation, WasmGCIntrinsicContext manager) {
        switch (invocation.getMethod().getName()) {
            case "getNaN": {
                return new WasmFloat32Constant(Float.NaN);
            }
            case "isNaN": {
                return this.testNaN(manager.generate(invocation.getArguments().get(0)), manager);
            }
            case "isInfinite": {
                return this.testIsInfinite(manager.generate(invocation.getArguments().get(0)));
            }
            case "isFinite": {
                return this.testIsFinite(manager.generate(invocation.getArguments().get(0)));
            }
            case "floatToRawIntBits": {
                WasmConversion conversion = new WasmConversion(WasmNumType.FLOAT32, WasmNumType.INT32, false, manager.generate(invocation.getArguments().get(0)));
                conversion.setReinterpret(true);
                return conversion;
            }
            case "intBitsToFloat": {
                WasmConversion conversion = new WasmConversion(WasmNumType.INT32, WasmNumType.FLOAT32, false, manager.generate(invocation.getArguments().get(0)));
                conversion.setReinterpret(true);
                return conversion;
            }
        }
        throw new AssertionError();
    }

    private WasmExpression testNaN(WasmExpression expression, WasmGCIntrinsicContext context) {
        WasmBlock block = new WasmBlock(false);
        block.setType(WasmType.INT32);
        CachedExpression cache = context.exprCache().create(expression, WasmType.FLOAT32, expression.getLocation(), block.getBody());
        block.getBody().add(new WasmFloatBinary(WasmFloatType.FLOAT32, WasmFloatBinaryOperation.NE, cache.expr(), cache.expr()));
        cache.release();
        return block;
    }

    private WasmExpression testIsInfinite(WasmExpression expression) {
        WasmConversion conversion = new WasmConversion(WasmNumType.FLOAT32, WasmNumType.INT32, false, expression);
        conversion.setReinterpret(true);
        WasmIntBinary result = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.AND, conversion, new WasmInt32Constant(2139095040));
        return new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.EQ, result, new WasmInt32Constant(2139095040));
    }

    private WasmExpression testIsFinite(WasmExpression expression) {
        WasmConversion conversion = new WasmConversion(WasmNumType.FLOAT32, WasmNumType.INT32, false, expression);
        conversion.setReinterpret(true);
        WasmIntBinary result = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.AND, conversion, new WasmInt32Constant(2139095040));
        return new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.NE, result, new WasmInt32Constant(2139095040));
    }
}

