/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.intrinsics.gc;

import org.teavm.ast.InvocationExpr;
import org.teavm.backend.wasm.generate.CachedExpression;
import org.teavm.backend.wasm.intrinsics.gc.WasmGCIntrinsic;
import org.teavm.backend.wasm.intrinsics.gc.WasmGCIntrinsicContext;
import org.teavm.backend.wasm.model.WasmNumType;
import org.teavm.backend.wasm.model.WasmType;
import org.teavm.backend.wasm.model.expression.WasmBlock;
import org.teavm.backend.wasm.model.expression.WasmConversion;
import org.teavm.backend.wasm.model.expression.WasmExpression;
import org.teavm.backend.wasm.model.expression.WasmFloat64Constant;
import org.teavm.backend.wasm.model.expression.WasmFloatBinary;
import org.teavm.backend.wasm.model.expression.WasmFloatBinaryOperation;
import org.teavm.backend.wasm.model.expression.WasmFloatType;
import org.teavm.backend.wasm.model.expression.WasmInt64Constant;
import org.teavm.backend.wasm.model.expression.WasmIntBinary;
import org.teavm.backend.wasm.model.expression.WasmIntBinaryOperation;
import org.teavm.backend.wasm.model.expression.WasmIntType;

public class DoubleIntrinsic
implements WasmGCIntrinsic {
    private static final long EXPONENT_BITS = 0x7FF0000000000000L;
    private static final long FRACTION_BITS = 0xFFFFFFFFFFFFFL;

    @Override
    public WasmExpression apply(InvocationExpr invocation, WasmGCIntrinsicContext context) {
        switch (invocation.getMethod().getName()) {
            case "getNaN": {
                return new WasmFloat64Constant(Double.NaN);
            }
            case "isNaN": {
                return this.testNaN(context.generate(invocation.getArguments().get(0)), context);
            }
            case "isInfinite": {
                return this.testIsInfinite(context.generate(invocation.getArguments().get(0)));
            }
            case "isFinite": {
                return this.testIsFinite(context.generate(invocation.getArguments().get(0)));
            }
            case "doubleToRawLongBits": {
                WasmConversion conversion = new WasmConversion(WasmNumType.FLOAT64, WasmNumType.INT64, false, context.generate(invocation.getArguments().get(0)));
                conversion.setReinterpret(true);
                return conversion;
            }
            case "longBitsToDouble": {
                WasmConversion conversion = new WasmConversion(WasmNumType.INT64, WasmNumType.FLOAT64, false, context.generate(invocation.getArguments().get(0)));
                conversion.setReinterpret(true);
                return conversion;
            }
        }
        throw new AssertionError();
    }

    private WasmExpression testNaN(WasmExpression expression, WasmGCIntrinsicContext context) {
        WasmBlock block = new WasmBlock(false);
        block.setType(WasmType.INT32);
        CachedExpression cache = context.exprCache().create(expression, WasmType.FLOAT64, expression.getLocation(), block.getBody());
        block.getBody().add(new WasmFloatBinary(WasmFloatType.FLOAT64, WasmFloatBinaryOperation.NE, cache.expr(), cache.expr()));
        cache.release();
        return block;
    }

    private WasmExpression testIsInfinite(WasmExpression expression) {
        WasmConversion conversion = new WasmConversion(WasmNumType.FLOAT64, WasmNumType.INT64, false, expression);
        conversion.setReinterpret(true);
        WasmIntBinary result = new WasmIntBinary(WasmIntType.INT64, WasmIntBinaryOperation.AND, conversion, new WasmInt64Constant(0x7FF0000000000000L));
        return new WasmIntBinary(WasmIntType.INT64, WasmIntBinaryOperation.EQ, result, new WasmInt64Constant(0x7FF0000000000000L));
    }

    private WasmExpression testIsFinite(WasmExpression expression) {
        WasmConversion conversion = new WasmConversion(WasmNumType.FLOAT64, WasmNumType.INT64, false, expression);
        conversion.setReinterpret(true);
        WasmIntBinary result = new WasmIntBinary(WasmIntType.INT64, WasmIntBinaryOperation.AND, conversion, new WasmInt64Constant(0x7FF0000000000000L));
        return new WasmIntBinary(WasmIntType.INT64, WasmIntBinaryOperation.NE, result, new WasmInt64Constant(0x7FF0000000000000L));
    }
}

