/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.generators.gc;

import org.teavm.backend.wasm.generate.gc.classes.WasmGCClassInfo;
import org.teavm.backend.wasm.generators.gc.WasmGCCustomGenerator;
import org.teavm.backend.wasm.generators.gc.WasmGCCustomGeneratorContext;
import org.teavm.backend.wasm.model.WasmFunction;
import org.teavm.backend.wasm.model.WasmLocal;
import org.teavm.backend.wasm.model.WasmType;
import org.teavm.backend.wasm.model.expression.WasmCall;
import org.teavm.backend.wasm.model.expression.WasmCallReference;
import org.teavm.backend.wasm.model.expression.WasmCast;
import org.teavm.backend.wasm.model.expression.WasmConditional;
import org.teavm.backend.wasm.model.expression.WasmExpression;
import org.teavm.backend.wasm.model.expression.WasmGetLocal;
import org.teavm.backend.wasm.model.expression.WasmIsNull;
import org.teavm.backend.wasm.model.expression.WasmStructGet;
import org.teavm.backend.wasm.model.expression.WasmThrow;
import org.teavm.backend.wasm.runtime.gc.WasmGCSupport;
import org.teavm.model.MethodReference;

public class ClassGenerators
implements WasmGCCustomGenerator {
    @Override
    public void apply(MethodReference method, WasmFunction function, WasmGCCustomGeneratorContext context) {
        switch (method.getName()) {
            case "isAssignableFrom": {
                this.generateIsAssignable(function, context);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported method: " + String.valueOf(method));
            }
        }
    }

    private void generateIsAssignable(WasmFunction function, WasmGCCustomGeneratorContext context) {
        WasmGCClassInfo classCls = context.classInfoProvider().getClassInfo("java.lang.Class");
        WasmLocal thisVar = new WasmLocal(context.isCompactMode() ? WasmType.Reference.ANY : classCls.getType());
        WasmLocal otherClassVar = new WasmLocal(classCls.getType());
        function.add(thisVar);
        function.add(otherClassVar);
        WasmConditional conditional = new WasmConditional(new WasmIsNull(new WasmGetLocal(otherClassVar)));
        function.getBody().add(conditional);
        WasmCall npe = new WasmCall(context.functions().forStaticMethod(new MethodReference(WasmGCSupport.class, "npe", NullPointerException.class)));
        WasmThrow throwExpr = new WasmThrow(context.exceptionTag());
        throwExpr.getArguments().add(npe);
        conditional.getThenBlock().getBody().add(throwExpr);
        WasmExpression thisExpr = new WasmGetLocal(thisVar);
        if (context.isCompactMode()) {
            thisExpr = new WasmCast(thisExpr, classCls.getType());
        }
        WasmStructGet functionRef = new WasmStructGet(classCls.getStructure(), thisExpr, context.classInfoProvider().getClassSupertypeFunctionOffset());
        WasmCallReference call = new WasmCallReference(functionRef, context.functionTypes().of(WasmType.INT32, classCls.getType(), classCls.getType()));
        thisExpr = new WasmGetLocal(thisVar);
        if (context.isCompactMode()) {
            thisExpr = new WasmCast(thisExpr, classCls.getType());
        }
        call.getArguments().add(thisExpr);
        call.getArguments().add(new WasmGetLocal(otherClassVar));
        function.getBody().add(call);
    }
}

