/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.gc.vtable;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.teavm.backend.wasm.gc.vtable.WasmGCVirtualTable;
import org.teavm.backend.wasm.gc.vtable.WasmGCVirtualTableEntry;
import org.teavm.common.LCATree;
import org.teavm.hppc.ObjectIntHashMap;
import org.teavm.hppc.cursors.ObjectIntCursor;
import org.teavm.model.ClassReader;
import org.teavm.model.ElementModifier;
import org.teavm.model.ListableClassReaderSource;
import org.teavm.model.MethodDescriptor;
import org.teavm.model.MethodReader;
import org.teavm.model.MethodReference;

class WasmGCVirtualTableBuilder {
    private static final MethodReference CLONE_METHOD = new MethodReference(Object.class, "clone", Object.class);
    ListableClassReaderSource classes;
    Collection<MethodReference> methodsAtCallSites;
    Predicate<MethodReference> isVirtual;
    private Map<String, Set<MethodDescriptor>> groupedMethodsAtCallSites = new HashMap<String, Set<MethodDescriptor>>();
    private List<Table> tables = new ArrayList<Table>();
    private Map<String, Table> tableMap = new HashMap<String, Table>();
    private LCATree lcaTree;
    Map<String, WasmGCVirtualTable> result = new HashMap<String, WasmGCVirtualTable>();

    WasmGCVirtualTableBuilder() {
    }

    void build() {
        this.initTables();
        this.buildLCA();
        this.initInterfaceTables();
        this.fillInterfaceImplementors();
        this.mergeTrivialInterfaces();
        this.liftInterfaces();
        this.buildInterfacesHierarchy();
        this.groupMethodsFromCallSites();
        this.moveClassesToMergedTables();
        this.fillTables();
        this.buildResult();
    }

    private void initTables() {
        for (String className : this.classes.getClassNames()) {
            this.initTable(className);
        }
    }

    private void initTable(String className) {
        ClassReader cls = this.classes.get(className);
        if (!cls.hasModifier(ElementModifier.INTERFACE) && !this.tableMap.containsKey(className)) {
            if (cls.getParent() != null) {
                this.initTable(cls.getParent());
            }
            Table table = new Table(cls, this.tables.size());
            if (cls.getParent() != null) {
                table.parent = this.tableMap.get(cls.getParent());
            }
            this.tables.add(table);
            this.tableMap.put(className, table);
        }
    }

    private void buildLCA() {
        this.lcaTree = new LCATree(this.tables.size() + 1);
        for (int i = 0; i < this.tables.size(); ++i) {
            Table table = this.tables.get(i);
            Table parentTable = table.cls.getParent() != null ? this.tableMap.get(table.cls.getParent()) : null;
            this.lcaTree.addNode(parentTable != null ? parentTable.index + 1 : 0);
        }
    }

    private void initInterfaceTables() {
        for (String className : this.classes.getClassNames()) {
            ClassReader cls = this.classes.get(className);
            if (!cls.hasModifier(ElementModifier.INTERFACE)) continue;
            Table table = new Table(cls, this.tables.size());
            this.tables.add(table);
            this.tableMap.put(className, table);
        }
    }

    private void fillInterfaceImplementors() {
        for (Table table : this.tables) {
            if (table.cls.hasModifier(ElementModifier.INTERFACE)) continue;
            HashSet<String> visited = new HashSet<String>();
            do {
                for (String itfName : table.cls.getInterfaces()) {
                    this.addImplementorToInterface(itfName, table, visited);
                }
            } while ((table = table.cls.getParent() != null ? this.tableMap.get(table.cls.getParent()) : null) != null);
        }
    }

    private void addImplementorToInterface(String interfaceName, Table newImplementor, Set<String> visited) {
        if (!visited.add(interfaceName)) {
            return;
        }
        Table itf = this.tableMap.get(interfaceName);
        if (!itf.commonImplementorFilled) {
            itf.commonImplementorFilled = true;
            itf.commonImplementor = newImplementor.parent;
        } else if (itf.commonImplementor != null) {
            int lcaIndex = this.lcaTree.lcaOf(newImplementor.index + 1, itf.commonImplementor.index + 1);
            if (lcaIndex > 0) {
                itf.commonImplementor = this.tables.get(lcaIndex - 1);
                if (itf.commonImplementor == newImplementor) {
                    itf.commonImplementor = newImplementor.parent;
                }
            } else {
                itf.commonImplementor = null;
            }
        }
        ClassReader cls = this.classes.get(interfaceName);
        if (cls != null) {
            for (String superInterface : cls.getInterfaces()) {
                this.addImplementorToInterface(superInterface, newImplementor, visited);
            }
        }
    }

    private void mergeTrivialInterfaces() {
        for (Table table : this.tables) {
            if (!table.cls.hasModifier(ElementModifier.INTERFACE) || !table.cls.getInterfaces().isEmpty() || !table.cls.getMethods().isEmpty() || table.commonImplementor == null) continue;
            table.interfaceMergedIntoClass = true;
            table.commonImplementor.merge(table);
        }
    }

    private void liftInterfaces() {
        block0: for (Table table : this.tables) {
            if (table.cls.hasModifier(ElementModifier.INTERFACE) || table.cls.getInterfaces().isEmpty()) continue;
            LinkedHashSet<Table> accumulatedInterfaces = new LinkedHashSet<Table>();
            for (String itfName : table.cls.getInterfaces()) {
                Table itf2 = this.tableMap.get(itfName);
                if (itf2 == null || itf2.interfaceMergedIntoClass) continue;
                accumulatedInterfaces.add(itf2);
            }
            while (table != null) {
                if (table.liftedInterfaces == null) {
                    table.liftedInterfaces = new LinkedHashSet<Table>();
                } else {
                    accumulatedInterfaces.removeAll(table.liftedInterfaces);
                }
                if (accumulatedInterfaces.isEmpty()) continue block0;
                table.liftedInterfaces.addAll(accumulatedInterfaces);
                Table parent = table.parent;
                LinkedHashSet<Table> accumulatedInterfacesToAdd = new LinkedHashSet<Table>();
                Iterator iter = accumulatedInterfaces.iterator();
                while (iter.hasNext()) {
                    Table itf3 = (Table)iter.next();
                    if (itf3.commonImplementor != parent) continue;
                    iter.remove();
                    this.addNextInterfaces(itf3, parent, new HashSet<Table>(), accumulatedInterfacesToAdd);
                }
                accumulatedInterfaces.addAll(accumulatedInterfacesToAdd);
                if (accumulatedInterfaces.isEmpty()) continue block0;
                table = parent;
            }
        }
        for (Table table : this.tables) {
            if (table.liftedInterfaces == null) continue;
            table.liftedInterfaces.removeIf(itf -> itf.commonImplementor != table.parent);
            if (!table.liftedInterfaces.isEmpty()) continue;
            table.liftedInterfaces = null;
        }
    }

    private void addNextInterfaces(Table itf, Table parent, Set<Table> visited, Set<Table> result) {
        if (!visited.add(itf)) {
            return;
        }
        if (itf.commonImplementor != parent) {
            result.add(itf);
        } else {
            for (String superItfName : itf.cls.getInterfaces()) {
                Table superItf = this.tableMap.get(superItfName);
                if (superItf == null) continue;
                this.addNextInterfaces(superItf, parent, visited, result);
            }
        }
    }

    private void buildInterfacesHierarchy() {
        for (Table table : this.tables) {
            if (table.cls.hasModifier(ElementModifier.INTERFACE)) {
                this.setUpInterfaceInHierarchy(table, table.commonImplementor);
                continue;
            }
            if (table.liftedInterfaces == null) continue;
            this.setUpInterfaceInHierarchy(table, table.parent);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void setUpInterfaceInHierarchy(Table table, Table parent) {
        if (table.visited) {
            return;
        }
        table.visited = true;
        LinkedHashSet<Table> interfaces = new LinkedHashSet<Table>();
        if (table.liftedInterfaces != null) {
            for (Table table2 : table.liftedInterfaces) {
                Table table3 = table2.resolve();
                if (table3.commonImplementor != parent || table3.interfaceMergedIntoClass) continue;
                this.setUpInterfaceInHierarchy(table3, parent);
                interfaces.add(table3.resolve());
            }
        } else {
            for (String string : table.cls.getInterfaces()) {
                Table itf3 = this.tableMap.get(string);
                if (itf3 == null) continue;
                itf3 = itf3.resolve();
                if (itf3.commonImplementor != parent || itf3.interfaceMergedIntoClass) continue;
                this.setUpInterfaceInHierarchy(itf3, parent);
                interfaces.add(itf3.resolve());
            }
        }
        if (interfaces.isEmpty()) {
            table.parent = parent;
            table.depth = 0;
        } else {
            void var5_12;
            int maxDepth = 0;
            for (Table itf2 : interfaces) {
                maxDepth = Math.max(itf2.depth, maxDepth);
            }
            Object var5_11 = null;
            for (int i = 0; i <= maxDepth; ++i) {
                int level = i;
                List interfacesAtLevel = interfaces.stream().map(itf -> itf.atDepth(level)).filter(Objects::nonNull).map(Table::resolve).distinct().collect(Collectors.toList());
                Table table4 = (Table)interfacesAtLevel.get(0);
                for (int j = 1; j < interfacesAtLevel.size(); ++j) {
                    table4.merge((Table)interfacesAtLevel.get(j));
                }
            }
            table.parent = var5_12;
            table.depth = var5_12.depth + 1;
        }
    }

    private void groupMethodsFromCallSites() {
        for (MethodReference methodRef : this.methodsAtCallSites) {
            String className = this.mapClassName(methodRef.getClassName());
            Set group = this.groupedMethodsAtCallSites.computeIfAbsent(className, k -> new LinkedHashSet());
            group.add(methodRef.getDescriptor());
        }
    }

    private String mapClassName(String name) {
        Table table = this.tableMap.get(name);
        if (table == null) {
            return name;
        }
        return table.resolve().cls.getName();
    }

    private void moveClassesToMergedTables() {
        for (Table table : this.tables) {
            Table resolvedTable;
            if (table.parent != null) {
                table.parent = table.parent.resolve();
            }
            if ((resolvedTable = table.resolve()) == table) continue;
            if (resolvedTable.mergedClasses == null) {
                resolvedTable.mergedClasses = new ArrayList<ClassReader>();
            }
            resolvedTable.mergedClasses.add(table.cls);
        }
    }

    private void fillTables() {
        for (String className : this.classes.getClassNames()) {
            Table table = this.tableMap.get(className);
            if (table == null) continue;
            this.fillTable(table);
        }
    }

    private void fillTable(Table table) {
        Set<MethodDescriptor> set;
        if (table.filled) {
            return;
        }
        table.filled = true;
        Table parent = table.parent;
        ObjectIntHashMap indexes = new ObjectIntHashMap();
        if (parent != null) {
            this.fillTable(parent);
            table.entries.addAll(parent.entries);
            table.implementors.addAll(parent.implementors);
            for (Entry entry : table.entries) {
                indexes.put((Object)entry.method, entry.index);
            }
            table.currentImplementors.putAll(parent.currentImplementors);
            table.interfaces.addAll(parent.interfaces);
        } else {
            table.used = true;
        }
        ArrayList<ClassReader> classes = new ArrayList<ClassReader>();
        classes.add(table.cls);
        if (table.mergedClasses != null) {
            classes.addAll(table.mergedClasses);
        }
        if (!table.cls.hasModifier(ElementModifier.INTERFACE)) {
            for (ClassReader cls : classes) {
                for (MethodReader methodReader : cls.getMethods()) {
                    if (methodReader.hasModifier(ElementModifier.STATIC) || methodReader.hasModifier(ElementModifier.ABSTRACT) || methodReader.getProgram() == null && !methodReader.hasModifier(ElementModifier.NATIVE) || !this.isVirtual.test(methodReader.getReference()) && !methodReader.getReference().equals(CLONE_METHOD)) continue;
                    table.currentImplementors.put(methodReader.getDescriptor(), methodReader.getReference());
                }
            }
            LinkedHashMap<MethodDescriptor, MethodReference> linkedHashMap = new LinkedHashMap<MethodDescriptor, MethodReference>();
            for (String itfName : table.cls.getInterfaces()) {
                this.fillFromInterfaces(itfName, table, linkedHashMap);
            }
            table.currentImplementors.putAll(linkedHashMap);
        }
        if ((set = this.groupedMethodsAtCallSites.get(table.cls.getName())) != null) {
            table.used = true;
            for (MethodDescriptor method : set) {
                if (indexes.getOrDefault((Object)method, -1) >= 0) continue;
                Entry entry = new Entry(method, table, table.entries.size());
                table.entries.add(entry);
                indexes.put((Object)method, entry.index);
                table.implementors.add(null);
            }
        }
        for (ObjectIntCursor entry : indexes) {
            MethodReference methodReference = table.currentImplementors.get(entry.key);
            table.implementors.set(entry.value, methodReference);
        }
    }

    private void fillFromInterfaces(String itfName, Table table, Map<MethodDescriptor, MethodReference> result) {
        if (!table.interfaces.add(itfName)) {
            return;
        }
        ClassReader cls = this.classes.get(itfName);
        if (cls == null) {
            return;
        }
        for (String string : cls.getInterfaces()) {
            this.fillFromInterfaces(string, table, result);
        }
        for (MethodReader methodReader : cls.getMethods()) {
            if (methodReader.hasModifier(ElementModifier.STATIC) || methodReader.hasModifier(ElementModifier.ABSTRACT) || methodReader.getProgram() == null && !methodReader.hasModifier(ElementModifier.NATIVE) || !this.isVirtual.test(methodReader.getReference()) || table.currentImplementors.get(methodReader.getDescriptor()) != null) continue;
            result.put(methodReader.getDescriptor(), methodReader.getReference());
        }
    }

    private void buildResult() {
        for (Table table : this.tables) {
            this.result.put(table.cls.getName(), table.getBuildResult());
        }
    }

    private static class Table {
        boolean visited;
        int depth = -1;
        Set<Table> liftedInterfaces;
        Table reference;
        Table commonImplementor;
        boolean commonImplementorFilled;
        boolean interfaceMergedIntoClass;
        final ClassReader cls;
        List<ClassReader> mergedClasses;
        int index;
        boolean filled;
        boolean used;
        Table parent;
        List<Entry> entries = new ArrayList<Entry>();
        List<MethodReference> implementors = new ArrayList<MethodReference>();
        Map<MethodDescriptor, MethodReference> currentImplementors = new HashMap<MethodDescriptor, MethodReference>();
        Set<String> interfaces = new HashSet<String>();
        private WasmGCVirtualTable buildResult;
        private boolean building;
        private boolean resolving;

        Table(ClassReader cls, int index) {
            this.cls = cls;
            this.index = index;
        }

        void merge(Table other) {
            other.reference = this;
        }

        Table atDepth(int depth) {
            if (depth > this.depth) {
                return null;
            }
            Table result = this;
            while (depth < result.depth) {
                result = result.parent;
            }
            return result;
        }

        WasmGCVirtualTable getBuildResult() {
            if (this.reference != null) {
                return this.resolve().getBuildResult();
            }
            if (this.buildResult == null) {
                if (this.building) {
                    throw new IllegalStateException();
                }
                this.building = true;
                this.buildResult = new WasmGCVirtualTable(this.parent != null ? this.parent.getBuildResult() : null, this.cls.getName(), this.used, !this.cls.hasModifier(ElementModifier.ABSTRACT));
                this.buildResult.entries = this.entries.stream().map(Entry::getBuildResult).collect(Collectors.toList());
                this.buildResult.implementors = this.implementors.toArray(new MethodReference[0]);
                this.buildResult.fakeInterfaceRepresentative = this.cls.hasModifier(ElementModifier.INTERFACE);
            }
            return this.buildResult;
        }

        Table resolve() {
            if (this.reference != null) {
                if (this.resolving) {
                    throw new IllegalStateException();
                }
                this.resolving = true;
                this.reference = this.reference.resolve();
                this.resolving = false;
                return this.reference;
            }
            return this;
        }
    }

    private static class Entry {
        MethodDescriptor method;
        Table origin;
        int index;
        private WasmGCVirtualTableEntry buildResult;

        Entry(MethodDescriptor method, Table origin, int index) {
            this.method = method;
            this.origin = origin;
            this.index = index;
        }

        WasmGCVirtualTableEntry getBuildResult() {
            if (this.buildResult == null) {
                this.buildResult = new WasmGCVirtualTableEntry(this.origin.getBuildResult(), this.method, this.index);
            }
            return this.buildResult;
        }
    }
}

