/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.optimization;

import java.util.HashSet;
import java.util.Set;
import org.teavm.backend.wasm.model.WasmArray;
import org.teavm.backend.wasm.model.WasmCompositeType;
import org.teavm.backend.wasm.model.WasmCompositeTypeVisitor;
import org.teavm.backend.wasm.model.WasmDefaultCompositeTypeVisitor;
import org.teavm.backend.wasm.model.WasmField;
import org.teavm.backend.wasm.model.WasmFunction;
import org.teavm.backend.wasm.model.WasmFunctionType;
import org.teavm.backend.wasm.model.WasmGlobal;
import org.teavm.backend.wasm.model.WasmLocal;
import org.teavm.backend.wasm.model.WasmModule;
import org.teavm.backend.wasm.model.WasmStorageType;
import org.teavm.backend.wasm.model.WasmStructure;
import org.teavm.backend.wasm.model.WasmTag;
import org.teavm.backend.wasm.model.WasmType;
import org.teavm.backend.wasm.model.expression.WasmArrayCopy;
import org.teavm.backend.wasm.model.expression.WasmArrayGet;
import org.teavm.backend.wasm.model.expression.WasmArraySet;
import org.teavm.backend.wasm.model.expression.WasmCallReference;
import org.teavm.backend.wasm.model.expression.WasmCast;
import org.teavm.backend.wasm.model.expression.WasmDefaultExpressionVisitor;
import org.teavm.backend.wasm.model.expression.WasmExpression;
import org.teavm.backend.wasm.model.expression.WasmExpressionVisitor;
import org.teavm.backend.wasm.model.expression.WasmFunctionReference;
import org.teavm.backend.wasm.model.expression.WasmIndirectCall;
import org.teavm.backend.wasm.model.expression.WasmNullConstant;
import org.teavm.backend.wasm.model.expression.WasmStructGet;
import org.teavm.backend.wasm.model.expression.WasmStructNew;
import org.teavm.backend.wasm.model.expression.WasmStructNewDefault;
import org.teavm.backend.wasm.model.expression.WasmStructSet;
import org.teavm.backend.wasm.model.expression.WasmTest;

public class UnusedTypeElimination {
    private WasmModule module;
    private Set<WasmCompositeType> usedTypes = new HashSet<WasmCompositeType>();
    private WasmExpressionVisitor exprVisitor = new WasmDefaultExpressionVisitor(){

        @Override
        public void visit(WasmIndirectCall expression) {
            super.visit(expression);
            UnusedTypeElimination.this.use(expression.getType());
        }

        @Override
        public void visit(WasmCast expression) {
            super.visit(expression);
            UnusedTypeElimination.this.use(expression.getTargetType());
        }

        @Override
        public void visit(WasmTest expression) {
            super.visit(expression);
            UnusedTypeElimination.this.use(expression.getTestType());
        }

        @Override
        public void visit(WasmArrayGet expression) {
            super.visit(expression);
            UnusedTypeElimination.this.use(expression.getType());
        }

        @Override
        public void visit(WasmArraySet expression) {
            super.visit(expression);
            UnusedTypeElimination.this.use(expression.getType());
        }

        @Override
        public void visit(WasmStructNew expression) {
            super.visit(expression);
            UnusedTypeElimination.this.use(expression.getType());
        }

        @Override
        public void visit(WasmStructNewDefault expression) {
            super.visit(expression);
            UnusedTypeElimination.this.use(expression.getType());
        }

        @Override
        public void visit(WasmStructGet expression) {
            super.visit(expression);
            UnusedTypeElimination.this.use(expression.getType());
        }

        @Override
        public void visit(WasmStructSet expression) {
            super.visit(expression);
            UnusedTypeElimination.this.use(expression.getType());
        }

        @Override
        public void visit(WasmNullConstant expression) {
            super.visit(expression);
            UnusedTypeElimination.this.use(expression.getType());
        }

        @Override
        public void visit(WasmFunctionReference expression) {
            super.visit(expression);
            UnusedTypeElimination.this.useFrom(expression.getFunction());
        }

        @Override
        public void visit(WasmCallReference expression) {
            super.visit(expression);
            UnusedTypeElimination.this.use(expression.getType());
        }

        @Override
        public void visit(WasmArrayCopy expression) {
            super.visit(expression);
            UnusedTypeElimination.this.use(expression.getSourceArrayType());
            UnusedTypeElimination.this.use(expression.getTargetArrayType());
        }
    };
    private WasmCompositeTypeVisitor typeVisitor = new WasmDefaultCompositeTypeVisitor(){

        @Override
        public void visit(WasmStructure type) {
            for (WasmField field : type.getFields()) {
                this.visit(field.getType());
            }
        }

        @Override
        public void visit(WasmArray type) {
            this.visit(type.getElementType());
        }

        @Override
        public void visit(WasmFunctionType type) {
            if (type.getReturnType() != null) {
                this.visit(type.getReturnType());
            }
            for (WasmType wasmType : type.getParameterTypes()) {
                this.visit(wasmType);
            }
        }

        private void visit(WasmStorageType type) {
            if (type instanceof WasmStorageType.Regular) {
                this.visit(((WasmStorageType.Regular)type).type);
            }
        }

        private void visit(WasmType type) {
            if (type instanceof WasmType.CompositeReference) {
                UnusedTypeElimination.this.use(((WasmType.CompositeReference)type).composite);
            }
        }
    };

    public UnusedTypeElimination(WasmModule module) {
        this.module = module;
    }

    public void apply() {
        this.collect();
        this.module.types.removeIf(type -> !this.usedTypes.contains(type));
    }

    private void collect() {
        for (WasmFunction function : this.module.functions) {
            this.useFrom(function);
        }
        for (WasmTag tag : this.module.tags) {
            this.use(tag.getType());
        }
        for (WasmGlobal global : this.module.globals) {
            this.use(global.getType());
        }
    }

    private void useFrom(WasmFunction function) {
        this.use(function.getType());
        for (WasmLocal local : function.getLocalVariables()) {
            this.use(local.getType());
        }
        for (WasmExpression part : function.getBody()) {
            part.acceptVisitor(this.exprVisitor);
        }
    }

    private void use(WasmType type) {
        if (type instanceof WasmType.CompositeReference) {
            this.use(((WasmType.CompositeReference)type).composite);
        }
    }

    private void use(WasmCompositeType type) {
        if (!this.usedTypes.add(type)) {
            return;
        }
        type.acceptVisitor(this.typeVisitor);
    }
}

