/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.generate.gc.methods;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.teavm.ast.ArrayFromDataExpr;
import org.teavm.ast.ArrayType;
import org.teavm.ast.BinaryExpr;
import org.teavm.ast.CastExpr;
import org.teavm.ast.ConditionalExpr;
import org.teavm.ast.ConstantExpr;
import org.teavm.ast.Expr;
import org.teavm.ast.InstanceOfExpr;
import org.teavm.ast.InvocationExpr;
import org.teavm.ast.NewArrayExpr;
import org.teavm.ast.QualificationExpr;
import org.teavm.ast.SubscriptExpr;
import org.teavm.ast.TryCatchStatement;
import org.teavm.ast.VariableExpr;
import org.teavm.backend.wasm.BaseWasmFunctionRepository;
import org.teavm.backend.wasm.WasmFunctionTypes;
import org.teavm.backend.wasm.gc.PreciseTypeInference;
import org.teavm.backend.wasm.gc.PreciseValueType;
import org.teavm.backend.wasm.gc.vtable.WasmGCVirtualTableProvider;
import org.teavm.backend.wasm.generate.CachedExpression;
import org.teavm.backend.wasm.generate.ExpressionCache;
import org.teavm.backend.wasm.generate.TemporaryVariablePool;
import org.teavm.backend.wasm.generate.common.methods.BaseWasmGenerationVisitor;
import org.teavm.backend.wasm.generate.gc.WasmGCNameProvider;
import org.teavm.backend.wasm.generate.gc.classes.WasmGCClassInfo;
import org.teavm.backend.wasm.generate.gc.classes.WasmGCClassInfoProvider;
import org.teavm.backend.wasm.generate.gc.classes.WasmGCTypeMapper;
import org.teavm.backend.wasm.generate.gc.methods.WasmGCGenerationContext;
import org.teavm.backend.wasm.generate.gc.methods.WasmGCGenerationUtil;
import org.teavm.backend.wasm.generate.gc.methods.WasmGCVirtualCallGenerator;
import org.teavm.backend.wasm.generate.gc.strings.WasmGCStringConstant;
import org.teavm.backend.wasm.generate.gc.strings.WasmGCStringProvider;
import org.teavm.backend.wasm.intrinsics.gc.WasmGCIntrinsic;
import org.teavm.backend.wasm.intrinsics.gc.WasmGCIntrinsicContext;
import org.teavm.backend.wasm.model.WasmArray;
import org.teavm.backend.wasm.model.WasmCompositeType;
import org.teavm.backend.wasm.model.WasmFunction;
import org.teavm.backend.wasm.model.WasmGlobal;
import org.teavm.backend.wasm.model.WasmLocal;
import org.teavm.backend.wasm.model.WasmModule;
import org.teavm.backend.wasm.model.WasmStructure;
import org.teavm.backend.wasm.model.WasmTag;
import org.teavm.backend.wasm.model.WasmType;
import org.teavm.backend.wasm.model.expression.WasmArrayGet;
import org.teavm.backend.wasm.model.expression.WasmArrayLength;
import org.teavm.backend.wasm.model.expression.WasmArraySet;
import org.teavm.backend.wasm.model.expression.WasmBlock;
import org.teavm.backend.wasm.model.expression.WasmBranch;
import org.teavm.backend.wasm.model.expression.WasmCall;
import org.teavm.backend.wasm.model.expression.WasmCallReference;
import org.teavm.backend.wasm.model.expression.WasmCast;
import org.teavm.backend.wasm.model.expression.WasmCastBranch;
import org.teavm.backend.wasm.model.expression.WasmCastCondition;
import org.teavm.backend.wasm.model.expression.WasmDrop;
import org.teavm.backend.wasm.model.expression.WasmExpression;
import org.teavm.backend.wasm.model.expression.WasmGetGlobal;
import org.teavm.backend.wasm.model.expression.WasmGetLocal;
import org.teavm.backend.wasm.model.expression.WasmInt32Constant;
import org.teavm.backend.wasm.model.expression.WasmInt32Subtype;
import org.teavm.backend.wasm.model.expression.WasmInt64Subtype;
import org.teavm.backend.wasm.model.expression.WasmIntBinary;
import org.teavm.backend.wasm.model.expression.WasmIntBinaryOperation;
import org.teavm.backend.wasm.model.expression.WasmIntType;
import org.teavm.backend.wasm.model.expression.WasmIntUnary;
import org.teavm.backend.wasm.model.expression.WasmIntUnaryOperation;
import org.teavm.backend.wasm.model.expression.WasmIsNull;
import org.teavm.backend.wasm.model.expression.WasmLoadFloat32;
import org.teavm.backend.wasm.model.expression.WasmLoadFloat64;
import org.teavm.backend.wasm.model.expression.WasmLoadInt32;
import org.teavm.backend.wasm.model.expression.WasmLoadInt64;
import org.teavm.backend.wasm.model.expression.WasmNullBranch;
import org.teavm.backend.wasm.model.expression.WasmNullCondition;
import org.teavm.backend.wasm.model.expression.WasmNullConstant;
import org.teavm.backend.wasm.model.expression.WasmReferencesEqual;
import org.teavm.backend.wasm.model.expression.WasmSetGlobal;
import org.teavm.backend.wasm.model.expression.WasmSetLocal;
import org.teavm.backend.wasm.model.expression.WasmSignedType;
import org.teavm.backend.wasm.model.expression.WasmStoreFloat32;
import org.teavm.backend.wasm.model.expression.WasmStoreFloat64;
import org.teavm.backend.wasm.model.expression.WasmStoreInt32;
import org.teavm.backend.wasm.model.expression.WasmStoreInt64;
import org.teavm.backend.wasm.model.expression.WasmStructGet;
import org.teavm.backend.wasm.model.expression.WasmStructNewDefault;
import org.teavm.backend.wasm.model.expression.WasmStructSet;
import org.teavm.backend.wasm.model.expression.WasmTest;
import org.teavm.backend.wasm.model.expression.WasmThrow;
import org.teavm.backend.wasm.model.expression.WasmUnreachable;
import org.teavm.backend.wasm.runtime.StringInternPool;
import org.teavm.dependency.DependencyInfo;
import org.teavm.diagnostics.Diagnostics;
import org.teavm.model.ClassHierarchy;
import org.teavm.model.ClassReader;
import org.teavm.model.ElementModifier;
import org.teavm.model.FieldReader;
import org.teavm.model.FieldReference;
import org.teavm.model.MethodReference;
import org.teavm.model.TextLocation;
import org.teavm.model.ValueType;
import org.teavm.model.analysis.ClassInitializerInfo;

public class WasmGCGenerationVisitor
extends BaseWasmGenerationVisitor {
    private WasmGCGenerationContext context;
    private WasmGCGenerationUtil generationUtil;
    private WasmType expectedType;
    private PreciseTypeInference types;
    private WasmGCVirtualCallGenerator virtualCallGenerator;
    private boolean compactMode;
    private WasmGCIntrinsicContext intrinsicContext = new WasmGCIntrinsicContext(){

        @Override
        public WasmExpression generate(Expr expr) {
            WasmGCGenerationVisitor.this.accept(expr);
            return WasmGCGenerationVisitor.this.result;
        }

        @Override
        public ClassLoader classLoader() {
            return WasmGCGenerationVisitor.this.context.classLoader();
        }

        @Override
        public WasmModule module() {
            return WasmGCGenerationVisitor.this.context.module();
        }

        @Override
        public WasmFunctionTypes functionTypes() {
            return WasmGCGenerationVisitor.this.context.functionTypes();
        }

        @Override
        public PreciseTypeInference types() {
            return WasmGCGenerationVisitor.this.types;
        }

        @Override
        public BaseWasmFunctionRepository functions() {
            return WasmGCGenerationVisitor.this.context.functions();
        }

        @Override
        public ClassHierarchy hierarchy() {
            return WasmGCGenerationVisitor.this.context.hierarchy();
        }

        @Override
        public WasmGCTypeMapper typeMapper() {
            return WasmGCGenerationVisitor.this.context.typeMapper();
        }

        @Override
        public WasmGCClassInfoProvider classInfoProvider() {
            return WasmGCGenerationVisitor.this.context.classInfoProvider();
        }

        @Override
        public WasmGCVirtualTableProvider virtualTables() {
            return WasmGCGenerationVisitor.this.context.virtualTables();
        }

        @Override
        public TemporaryVariablePool tempVars() {
            return WasmGCGenerationVisitor.this.tempVars;
        }

        @Override
        public ExpressionCache exprCache() {
            return WasmGCGenerationVisitor.this.exprCache;
        }

        @Override
        public WasmGCNameProvider names() {
            return WasmGCGenerationVisitor.this.context.names();
        }

        @Override
        public WasmGCStringProvider strings() {
            return WasmGCGenerationVisitor.this.context.strings();
        }

        @Override
        public WasmTag exceptionTag() {
            return WasmGCGenerationVisitor.this.context.getExceptionTag();
        }

        @Override
        public String entryPoint() {
            return WasmGCGenerationVisitor.this.context.entryPoint();
        }

        @Override
        public Diagnostics diagnostics() {
            return WasmGCGenerationVisitor.this.context.diagnostics();
        }

        @Override
        public MethodReference currentMethod() {
            return WasmGCGenerationVisitor.this.currentMethod;
        }

        @Override
        public ClassInitializerInfo classInitInfo() {
            return WasmGCGenerationVisitor.this.context.classInitInfo();
        }

        @Override
        public DependencyInfo dependency() {
            return WasmGCGenerationVisitor.this.context.dependency();
        }

        @Override
        public void addToInitializer(Consumer<WasmFunction> initializerContributor) {
            WasmGCGenerationVisitor.this.context.addToInitializer(initializerContributor);
        }
    };

    public WasmGCGenerationVisitor(WasmGCGenerationContext context, MethodReference currentMethod, WasmFunction function, int firstVariable, boolean async, PreciseTypeInference types) {
        super(context, currentMethod, function, firstVariable, async);
        this.context = context;
        this.generationUtil = new WasmGCGenerationUtil(context.classInfoProvider());
        this.virtualCallGenerator = new WasmGCVirtualCallGenerator(context.virtualTables(), context.classInfoProvider());
        this.types = types;
    }

    public void setCompactMode(boolean compactMode) {
        this.compactMode = compactMode;
    }

    @Override
    protected void accept(Expr expr) {
        this.accept(expr, null);
    }

    @Override
    protected void accept(Expr expr, WasmType type) {
        WasmType previousExpectedType = this.expectedType;
        this.expectedType = type;
        super.accept(expr);
        this.expectedType = previousExpectedType;
    }

    @Override
    protected void acceptWithType(Expr expr, ValueType type) {
        this.accept(expr, this.mapType(type));
    }

    @Override
    protected boolean isManaged() {
        return true;
    }

    @Override
    protected boolean needsCallSiteId() {
        return false;
    }

    @Override
    protected boolean isManagedCall(MethodReference method) {
        return false;
    }

    @Override
    public void visit(VariableExpr expr) {
        super.visit(expr);
        if (this.compactMode && expr.getVariableIndex() == 0) {
            WasmType receiverType = this.context.typeMapper().mapType(ValueType.object(this.currentMethod.getClassName()));
            WasmCast cast = new WasmCast(this.result, (WasmType.Reference)receiverType);
            cast.setLocation(expr.getLocation());
            this.result = cast;
        }
    }

    @Override
    protected void generateThrowNPE(TextLocation location, List<WasmExpression> target) {
        this.generateThrow(new WasmCall(this.context.npeMethod()), location, target);
    }

    @Override
    protected void generateThrowAIOOBE(TextLocation location, List<WasmExpression> target) {
        this.generateThrow(new WasmCall(this.context.aaiobeMethod()), location, target);
    }

    @Override
    protected void generateThrowCCE(TextLocation location, List<WasmExpression> target) {
        this.generateThrow(new WasmCall(this.context.cceMethod()), location, target);
    }

    @Override
    protected void generateThrow(WasmExpression expression, TextLocation location, List<WasmExpression> target) {
        WasmThrow result = new WasmThrow(this.context.getExceptionTag());
        result.getArguments().add(expression);
        result.setLocation(location);
        target.add(result);
    }

    @Override
    protected WasmExpression unwrapArray(WasmExpression array) {
        array.acceptVisitor(this.typeInference);
        WasmType.CompositeReference arrayType = (WasmType.CompositeReference)this.typeInference.getResult();
        WasmStructure arrayStruct = (WasmStructure)arrayType.composite;
        return new WasmStructGet(arrayStruct, array, 2);
    }

    @Override
    protected WasmExpression generateArrayLength(WasmExpression array) {
        return new WasmArrayLength(array);
    }

    @Override
    protected WasmExpression storeArrayItem(WasmExpression array, WasmExpression index, Expr value, ArrayType type) {
        array.acceptVisitor(this.typeInference);
        WasmType.CompositeReference arrayRefType = (WasmType.CompositeReference)this.typeInference.getResult();
        WasmArray arrayType = (WasmArray)arrayRefType.composite;
        this.accept(value, arrayType.getElementType().asUnpackedType());
        WasmExpression wasmValue = this.result;
        return new WasmArraySet(arrayType, array, index, wasmValue);
    }

    @Override
    protected void storeField(Expr qualified, FieldReference field, Expr value, TextLocation location) {
        WasmExpression expr;
        if (qualified == null) {
            WasmGlobal global = this.context.classInfoProvider().getStaticFieldLocation(field);
            this.accept(value, global.getType());
            WasmExpression wasmValue = this.result;
            expr = new WasmSetGlobal(global, wasmValue);
        } else {
            this.acceptWithType(qualified, ValueType.object(field.getClassName()));
            WasmExpression target = this.result;
            expr = this.context.classInfoProvider().getClassInfo(field.getClassName()).isHeapStructure() ? this.storeHeapField(target, field, value) : this.storeNormalField(target, field, value);
        }
        expr.setLocation(location);
        this.resultConsumer.add(expr);
    }

    private WasmExpression storeNormalField(WasmExpression target, FieldReference field, Expr value) {
        target.acceptVisitor(this.typeInference);
        WasmType.CompositeReference type = (WasmType.CompositeReference)this.typeInference.getResult();
        WasmStructure struct = (WasmStructure)type.composite;
        int fieldIndex = this.context.classInfoProvider().getFieldIndex(field);
        if (fieldIndex >= 0) {
            this.accept(value, struct.getFields().get(fieldIndex).getUnpackedType());
            return new WasmStructSet(struct, target, fieldIndex, this.result);
        }
        this.accept(value);
        return this.result;
    }

    private WasmExpression storeHeapField(WasmExpression target, FieldReference field, Expr value) {
        ClassReader cls = this.context.classes().get(field.getClassName());
        ValueType type = cls.getField(field.getFieldName()).getType();
        int offset = this.context.classInfoProvider().getHeapFieldOffset(field);
        this.accept(value, this.context.typeMapper().mapType(type));
        WasmExpression wasmValue = this.result;
        if (type instanceof ValueType.Primitive) {
            switch (((ValueType.Primitive)type).getKind()) {
                case BOOLEAN: 
                case BYTE: {
                    return new WasmStoreInt32(1, target, wasmValue, WasmInt32Subtype.INT8, offset);
                }
                case CHARACTER: {
                    return new WasmStoreInt32(2, target, wasmValue, WasmInt32Subtype.UINT16, offset);
                }
                case SHORT: {
                    return new WasmStoreInt32(2, target, wasmValue, WasmInt32Subtype.INT16, offset);
                }
                case INTEGER: {
                    return new WasmStoreInt32(4, target, wasmValue, WasmInt32Subtype.INT32, offset);
                }
                case LONG: {
                    return new WasmStoreInt64(8, target, wasmValue, WasmInt64Subtype.INT32, offset);
                }
                case FLOAT: {
                    return new WasmStoreFloat32(4, target, wasmValue, offset);
                }
                case DOUBLE: {
                    return new WasmStoreFloat64(8, target, wasmValue, offset);
                }
            }
        }
        return new WasmStoreInt32(4, target, wasmValue, WasmInt32Subtype.INT32, offset);
    }

    @Override
    protected WasmExpression stringLiteral(String s) {
        WasmGCStringConstant stringConstant = this.context.strings().getStringConstant(s);
        return new WasmGetGlobal(stringConstant.global);
    }

    @Override
    protected WasmExpression classLiteral(ValueType type) {
        ValueType itemType;
        if (type instanceof ValueType.Array && !((itemType = ((ValueType.Array)type).getItemType()) instanceof ValueType.Primitive)) {
            int degree = 0;
            while (type instanceof ValueType.Array) {
                type = ((ValueType.Array)type).getItemType();
                ++degree;
            }
            WasmExpression result = new WasmGetGlobal(this.context.classInfoProvider().getClassInfo(type).getPointer());
            while (degree-- > 0) {
                result = new WasmCall(this.context.classInfoProvider().getGetArrayClassFunction(), result);
            }
            return result;
        }
        WasmGCClassInfo classConstant = this.context.classInfoProvider().getClassInfo(type);
        return new WasmGetGlobal(classConstant.getPointer());
    }

    @Override
    protected WasmExpression nullLiteral(Expr expr) {
        PreciseValueType javaType;
        WasmType type = this.expectedType;
        if (type == WasmType.INT32) {
            return new WasmInt32Constant(0);
        }
        if (expr.getVariableIndex() >= 0 && (javaType = (PreciseValueType)this.types.typeOf(expr.getVariableIndex())) != null) {
            type = this.mapType(javaType.valueType);
        }
        return new WasmNullConstant(type instanceof WasmType.Reference ? (WasmType.Reference)type : this.context.classInfoProvider().getClassInfo("java.lang.Object").getType());
    }

    @Override
    protected WasmExpression nullLiteral(WasmType type) {
        return new WasmNullConstant((WasmType.Reference)type);
    }

    @Override
    protected WasmExpression genIsNull(WasmExpression value) {
        return new WasmIsNull(value);
    }

    @Override
    protected WasmExpression nullCheck(Expr value, TextLocation location) {
        WasmBlock block = new WasmBlock(false);
        block.setLocation(location);
        this.accept(value);
        if (this.result instanceof WasmUnreachable) {
            return this.result;
        }
        this.result.acceptVisitor(this.typeInference);
        block.setType(this.typeInference.getResult());
        WasmNullBranch check = new WasmNullBranch(WasmNullCondition.NOT_NULL, this.result, block);
        block.getBody().add(check);
        BaseWasmGenerationVisitor.CallSiteIdentifier callSiteId = this.generateCallSiteId(location);
        callSiteId.generateRegister(block.getBody(), location);
        this.generateThrowNPE(location, block.getBody());
        callSiteId.generateThrow(block.getBody(), location);
        return block;
    }

    @Override
    protected BaseWasmGenerationVisitor.CallSiteIdentifier generateCallSiteId(TextLocation location) {
        return new SimpleCallSite();
    }

    @Override
    public void visit(BinaryExpr expr) {
        if (expr.getType() == null) {
            switch (expr.getOperation()) {
                case EQUALS: {
                    this.isReferenceEq(expr);
                    this.result.setLocation(expr.getLocation());
                    return;
                }
                case NOT_EQUALS: {
                    this.isReferenceEq(expr);
                    this.result = new WasmIntUnary(WasmIntType.INT32, WasmIntUnaryOperation.EQZ, this.result);
                    this.result.setLocation(expr.getLocation());
                    return;
                }
            }
        }
        super.visit(expr);
    }

    private void isReferenceEq(BinaryExpr expr) {
        if (this.isNull(expr.getFirstOperand())) {
            this.accept(expr.getSecondOperand());
            this.result.acceptVisitor(this.typeInference);
            this.result = this.typeInference.getResult() == WasmType.INT32 ? new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.EQ, this.result, new WasmInt32Constant(0)) : new WasmIsNull(this.result);
        } else if (this.isNull(expr.getSecondOperand())) {
            this.accept(expr.getFirstOperand());
            this.result.acceptVisitor(this.typeInference);
            this.result = this.typeInference.getResult() == WasmType.INT32 ? new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.EQ, this.result, new WasmInt32Constant(0)) : new WasmIsNull(this.result);
        } else {
            this.accept(expr.getFirstOperand());
            WasmExpression first = this.result;
            this.accept(expr.getSecondOperand());
            WasmExpression second = this.result;
            first.acceptVisitor(this.typeInference);
            this.result = this.typeInference.getResult() == WasmType.INT32 ? new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.EQ, first, second) : new WasmReferencesEqual(first, second);
        }
    }

    private boolean isNull(Expr expr) {
        if (!(expr instanceof ConstantExpr)) {
            return false;
        }
        return ((ConstantExpr)expr).getValue() == null;
    }

    @Override
    protected WasmExpression generateVirtualCall(WasmLocal instance, MethodReference method, List<WasmExpression> arguments) {
        return this.virtualCallGenerator.generate(method, instance, arguments.subList(1, arguments.size()));
    }

    @Override
    protected void allocateObject(String className, TextLocation location, WasmLocal local, List<WasmExpression> target) {
        WasmGCClassInfo classInfo = this.context.classInfoProvider().getClassInfo(className);
        WasmBlock block = new WasmBlock(false);
        block.setType(classInfo.getType());
        WasmLocal targetVar = local;
        if (targetVar == null) {
            targetVar = this.tempVars.acquire(classInfo.getType());
        }
        WasmSetLocal structNew = new WasmSetLocal(targetVar, new WasmStructNewDefault(classInfo.getStructure()));
        structNew.setLocation(location);
        target.add(structNew);
        WasmStructSet initClassField = new WasmStructSet(classInfo.getStructure(), new WasmGetLocal(targetVar), 0, new WasmGetGlobal(classInfo.getVirtualTablePointer()));
        initClassField.setLocation(location);
        target.add(initClassField);
        if (local == null) {
            WasmGetLocal getLocal = new WasmGetLocal(targetVar);
            getLocal.setLocation(location);
            target.add(getLocal);
            this.tempVars.release(targetVar);
        }
    }

    @Override
    public void visit(ArrayFromDataExpr expr) {
        WasmType.CompositeReference wasmArrayType = (WasmType.CompositeReference)this.mapType(ValueType.arrayOf(expr.getType()));
        WasmStructure wasmArrayStruct = (WasmStructure)wasmArrayType.composite;
        WasmType.CompositeReference wasmArrayDataType = (WasmType.CompositeReference)wasmArrayStruct.getFields().get(2).getUnpackedType();
        WasmArray wasmArray = (WasmArray)wasmArrayDataType.composite;
        WasmExpression array = this.generationUtil.allocateArrayWithElements(expr.getType(), () -> {
            ArrayList<WasmExpression> items = new ArrayList<WasmExpression>();
            for (int i = 0; i < expr.getData().size(); ++i) {
                this.accept(expr.getData().get(i), wasmArray.getElementType().asUnpackedType());
                items.add(this.result);
            }
            return items;
        });
        array.setLocation(expr.getLocation());
        this.result = array;
    }

    @Override
    public void visit(NewArrayExpr expr) {
        this.accept(expr.getLength(), WasmType.INT32);
        WasmFunction function = this.context.classInfoProvider().getArrayConstructor(expr.getType());
        WasmCall call = new WasmCall(function, this.classLiteral(expr.getType()), this.result);
        call.setLocation(expr.getLocation());
        this.result = call;
    }

    @Override
    protected WasmExpression allocateMultiArray(List<WasmExpression> target, ValueType arrayType, Supplier<List<WasmExpression>> dimensions, TextLocation location) {
        ArrayList<WasmExpression> args = new ArrayList<WasmExpression>();
        List<WasmExpression> dimensionsValue = dimensions.get();
        args.add(this.classLiteral(((ValueType.Array)arrayType).getItemType()));
        args.addAll(dimensionsValue);
        WasmFunction function = this.context.classInfoProvider().getMultiArrayConstructor(dimensionsValue.size());
        WasmCall call = new WasmCall(function, args.toArray(new WasmExpression[0]));
        call.setLocation(location);
        return call;
    }

    @Override
    protected WasmExpression generateInstanceOf(WasmExpression expression, ValueType type) {
        this.context.classInfoProvider().getClassInfo(type);
        WasmBlock block = new WasmBlock(false);
        block.setType(WasmType.INT32);
        WasmCall supertypeCall = new WasmCall(this.context.supertypeFunctions().getIsSupertypeFunction(type));
        WasmStructGet vtRef = new WasmStructGet(this.context.standardClasses().objectClass().getStructure(), expression, 0);
        WasmStructGet classRef = new WasmStructGet(this.context.standardClasses().objectClass().getVirtualTableStructure(), vtRef, 0);
        WasmType.CompositeReference classClass = this.context.standardClasses().classClass().getType();
        CachedExpression classRefCached = this.exprCache.create(classRef, classClass, expression.getLocation(), block.getBody());
        supertypeCall.getArguments().add(classRefCached.expr());
        supertypeCall.getArguments().add(classRefCached.expr());
        classRefCached.release();
        block.getBody().add(supertypeCall);
        return block;
    }

    @Override
    public void visit(InstanceOfExpr expr) {
        ValueType type = expr.getType();
        if (this.canCastNatively(type)) {
            WasmType.CompositeReference wasmType = this.context.classInfoProvider().getClassInfo(type).getStructure().getNonNullReference();
            this.acceptWithType(expr.getExpr(), type);
            WasmExpression wasmValue = this.result;
            this.result.acceptVisitor(this.typeInference);
            this.result = new WasmTest(wasmValue, wasmType);
            this.result.setLocation(expr.getLocation());
        } else {
            super.visit(expr);
        }
    }

    @Override
    public void visit(CastExpr expr) {
        WasmCompositeType targetComposite;
        this.acceptWithType(expr.getValue(), expr.getTarget());
        if (expr.getTarget() instanceof ValueType.Object) {
            String className = ((ValueType.Object)expr.getTarget()).getClassName();
            if (this.context.classInfoProvider().getClassInfo(className).isHeapStructure()) {
                this.accept(expr.getValue(), WasmType.INT32);
                return;
            }
        }
        this.result.acceptVisitor(this.typeInference);
        WasmType.Reference sourceType = (WasmType.Reference)this.typeInference.getResult();
        if (sourceType == null) {
            return;
        }
        WasmType.Reference targetType = (WasmType.Reference)this.context.typeMapper().mapType(expr.getTarget());
        WasmStructure targetStruct = null;
        if (targetType instanceof WasmType.CompositeReference && (targetComposite = ((WasmType.CompositeReference)targetType).composite) instanceof WasmStructure) {
            targetStruct = (WasmStructure)targetComposite;
        }
        boolean canInsertCast = true;
        if (targetStruct != null && sourceType instanceof WasmType.CompositeReference) {
            WasmStructure sourceStruct;
            WasmType.CompositeReference sourceComposite = (WasmType.CompositeReference)sourceType;
            if (!sourceType.isNullable()) {
                sourceType = sourceComposite.composite.getReference();
            }
            if (targetStruct.isSupertypeOf(sourceStruct = (WasmStructure)sourceComposite.composite)) {
                canInsertCast = false;
            } else if (!sourceStruct.isSupertypeOf(targetStruct)) {
                WasmBlock block = new WasmBlock(false);
                block.setType(targetType);
                block.setLocation(expr.getLocation());
                block.getBody().add(new WasmDrop(this.result));
                block.getBody().add(new WasmNullConstant(targetType));
                this.result = block;
                return;
            }
        }
        if (!expr.isWeak() && this.context.isStrict()) {
            this.result.acceptVisitor(this.typeInference);
            WasmBlock block = new WasmBlock(false);
            block.setLocation(expr.getLocation());
            if (this.canCastNatively(expr.getTarget())) {
                block.setType(targetType);
                if (!canInsertCast) {
                    return;
                }
                block.getBody().add(new WasmCastBranch(WasmCastCondition.SUCCESS, this.result, sourceType, targetType, block));
                this.result = block;
            } else {
                block.setType(sourceType);
                WasmNullBranch nonNullValue = new WasmNullBranch(WasmNullCondition.NULL, this.result, block);
                nonNullValue.setResult(new WasmNullConstant(sourceType));
                CachedExpression valueToCast = this.exprCache.create(nonNullValue, sourceType, expr.getLocation(), block.getBody());
                WasmExpression supertypeCall = this.generateInstanceOf(valueToCast.expr(), expr.getTarget());
                WasmBranch breakIfPassed = new WasmBranch(supertypeCall, block);
                breakIfPassed.setResult(valueToCast.expr());
                block.getBody().add(new WasmDrop(breakIfPassed));
                this.result = block;
                if (canInsertCast) {
                    WasmCast cast = new WasmCast(this.result, targetType);
                    cast.setLocation(expr.getLocation());
                    this.result = cast;
                }
            }
            this.generateThrowCCE(expr.getLocation(), block.getBody());
        } else if (canInsertCast) {
            this.result = new WasmCast(this.result, targetType);
            this.result.setLocation(expr.getLocation());
        }
    }

    private boolean canCastNatively(ValueType type) {
        if (type instanceof ValueType.Array) {
            return true;
        }
        String className = ((ValueType.Object)type).getClassName();
        ClassReader cls = this.context.classes().get(className);
        if (cls == null) {
            return false;
        }
        return !cls.hasModifier(ElementModifier.INTERFACE);
    }

    @Override
    protected boolean needsClassInitializer(String className) {
        if (className.equals(StringInternPool.class.getName())) {
            return false;
        }
        return this.context.classInfoProvider().getClassInfo(className).getInitializerPointer() != null;
    }

    @Override
    protected WasmExpression generateClassInitializer(String className, TextLocation location) {
        WasmGlobal pointer = this.context.classInfoProvider().getClassInfo(className).getInitializerPointer();
        WasmCallReference result = new WasmCallReference(new WasmGetGlobal(pointer), this.context.functionTypes().of(null, new WasmType[0]));
        result.setLocation(location);
        return result;
    }

    @Override
    protected void checkExceptionType(TryCatchStatement tryCatch, WasmLocal exceptionVar, List<WasmExpression> target, WasmBlock targetBlock) {
        WasmType.CompositeReference wasmType = this.context.classInfoProvider().getClassInfo(tryCatch.getExceptionType()).getType();
        WasmType.CompositeReference wasmSourceType = this.context.classInfoProvider().getClassInfo("java.lang.Throwable").getType();
        WasmCastBranch br = new WasmCastBranch(WasmCastCondition.SUCCESS, new WasmGetLocal(exceptionVar), wasmSourceType, wasmType, targetBlock);
        target.add(new WasmDrop(br));
    }

    @Override
    protected WasmType mapType(ValueType type) {
        return this.context.typeMapper().mapType(type);
    }

    @Override
    public void visit(SubscriptExpr expr) {
        WasmType.Reference wasmTargetType;
        PreciseValueType targetType;
        this.accept(expr.getArray());
        WasmExpression arrayData = this.result;
        arrayData.acceptVisitor(this.typeInference);
        WasmType.CompositeReference arrayTypeRef = (WasmType.CompositeReference)this.typeInference.getResult();
        WasmArray arrayType = (WasmArray)arrayTypeRef.composite;
        this.accept(expr.getIndex());
        WasmExpression index = this.result;
        WasmArrayGet arrayGet = new WasmArrayGet(arrayType, arrayData, index);
        switch (expr.getType()) {
            case BYTE: {
                arrayGet.setSignedType(WasmSignedType.SIGNED);
                break;
            }
            case SHORT: {
                arrayGet.setSignedType(WasmSignedType.SIGNED);
                break;
            }
            case CHAR: {
                arrayGet.setSignedType(WasmSignedType.UNSIGNED);
                break;
            }
        }
        arrayGet.setLocation(expr.getLocation());
        this.result = arrayGet;
        if (expr.getType() == ArrayType.OBJECT && expr.getVariableIndex() >= 0 && (targetType = (PreciseValueType)this.types.typeOf(expr.getVariableIndex())) != null && !this.isExtern(wasmTargetType = (WasmType.Reference)this.mapType(targetType.valueType))) {
            this.result = new WasmCast(this.result, (WasmType.Reference)this.mapType(targetType.valueType));
        }
    }

    private boolean isExtern(WasmType.Reference type) {
        if (!(type instanceof WasmType.SpecialReference)) {
            return false;
        }
        return ((WasmType.SpecialReference)type).kind == WasmType.SpecialReferenceKind.EXTERN;
    }

    @Override
    public void visit(InvocationExpr expr) {
        this.result = this.invocation(expr, null, false);
    }

    @Override
    protected WasmExpression invocation(InvocationExpr expr, List<WasmExpression> resultConsumer, boolean willDrop) {
        WasmGCIntrinsic intrinsic = this.context.intrinsics().get(expr.getMethod());
        if (intrinsic != null) {
            WasmExpression resultExpr = intrinsic.apply(expr, this.intrinsicContext);
            resultExpr.setLocation(expr.getLocation());
            if (resultConsumer != null) {
                if (willDrop) {
                    WasmDrop drop = new WasmDrop(resultExpr);
                    drop.setLocation(expr.getLocation());
                    resultConsumer.add(drop);
                } else {
                    resultConsumer.add(resultExpr);
                }
                this.result = null;
                return null;
            }
            return resultExpr;
        }
        return super.invocation(expr, resultConsumer, willDrop);
    }

    @Override
    protected WasmExpression mapFirstArgumentForCall(WasmExpression argument, WasmFunction function, MethodReference method) {
        return this.forceType(argument, function.getType().getParameterTypes().get(0));
    }

    @Override
    protected WasmExpression forceType(WasmExpression expression, ValueType type) {
        return this.forceType(expression, this.mapType(this.currentMethod.getReturnType()));
    }

    private WasmExpression forceType(WasmExpression expression, WasmType expectedType) {
        expression.acceptVisitor(this.typeInference);
        WasmType actualType = this.typeInference.getResult();
        if (actualType == expectedType || !(actualType instanceof WasmType.CompositeReference) || !(expectedType instanceof WasmType.CompositeReference)) {
            return expression;
        }
        WasmCompositeType actualComposite = ((WasmType.CompositeReference)actualType).composite;
        WasmCompositeType expectedComposite = ((WasmType.CompositeReference)expectedType).composite;
        if (!(actualComposite instanceof WasmStructure) || !(expectedComposite instanceof WasmStructure)) {
            return expression;
        }
        WasmStructure actualStruct = (WasmStructure)actualComposite;
        WasmStructure expectedStruct = (WasmStructure)expectedComposite;
        if (!actualStruct.isSupertypeOf(expectedStruct)) {
            return expression;
        }
        return new WasmCast(expression, expectedComposite.getReference());
    }

    @Override
    public void visit(QualificationExpr expr) {
        if (expr.getQualified() == null) {
            WasmGlobal global = this.context.classInfoProvider().getStaticFieldLocation(expr.getField());
            this.result = new WasmGetGlobal(global);
            this.result.setLocation(expr.getLocation());
        } else {
            this.acceptWithType(expr.getQualified(), ValueType.object(expr.getField().getClassName()));
            WasmExpression target = this.result;
            WasmGCClassInfo classInfo = this.context.classInfoProvider().getClassInfo(expr.getField().getClassName());
            if (classInfo.isHeapStructure()) {
                int offset = this.context.classInfoProvider().getHeapFieldOffset(expr.getField());
                ClassReader cls = this.context.classes().get(expr.getField().getClassName());
                FieldReader field = cls.getField(expr.getField().getFieldName());
                this.result = this.getHeapField(field.getType(), target, offset);
            } else {
                this.result = this.getNormalField(expr, target);
            }
            this.result.setLocation(expr.getLocation());
        }
    }

    private WasmExpression getNormalField(QualificationExpr expr, WasmExpression target) {
        ValueType fieldType;
        FieldReader field;
        target.acceptVisitor(this.typeInference);
        WasmType.CompositeReference type = (WasmType.CompositeReference)this.typeInference.getResult();
        if (type == null) {
            return new WasmUnreachable();
        }
        WasmStructure struct = (WasmStructure)type.composite;
        int fieldIndex = this.context.classInfoProvider().getFieldIndex(expr.getField());
        if (fieldIndex < 0) {
            return new WasmUnreachable();
        }
        WasmStructGet structGet = new WasmStructGet(struct, target, fieldIndex);
        ClassReader cls = this.context.classes().get(expr.getField().getClassName());
        if (cls != null && (field = cls.getField(expr.getField().getFieldName())) != null && (fieldType = field.getType()) instanceof ValueType.Primitive) {
            switch (((ValueType.Primitive)fieldType).getKind()) {
                case BOOLEAN: {
                    structGet.setSignedType(WasmSignedType.UNSIGNED);
                    break;
                }
                case BYTE: {
                    structGet.setSignedType(WasmSignedType.SIGNED);
                    break;
                }
                case SHORT: {
                    structGet.setSignedType(WasmSignedType.SIGNED);
                    break;
                }
                case CHARACTER: {
                    structGet.setSignedType(WasmSignedType.UNSIGNED);
                    break;
                }
            }
        }
        return structGet;
    }

    private WasmExpression getHeapField(ValueType type, WasmExpression target, int offset) {
        if (type instanceof ValueType.Primitive) {
            switch (((ValueType.Primitive)type).getKind()) {
                case BOOLEAN: 
                case BYTE: {
                    return new WasmLoadInt32(1, target, WasmInt32Subtype.INT8, offset);
                }
                case CHARACTER: {
                    return new WasmLoadInt32(2, target, WasmInt32Subtype.UINT16, offset);
                }
                case SHORT: {
                    return new WasmLoadInt32(2, target, WasmInt32Subtype.INT16, offset);
                }
                case INTEGER: {
                    return new WasmLoadInt32(4, target, WasmInt32Subtype.INT32, offset);
                }
                case LONG: {
                    return new WasmLoadInt64(8, target, WasmInt64Subtype.INT64, offset);
                }
                case FLOAT: {
                    return new WasmLoadFloat32(4, target, offset);
                }
                case DOUBLE: {
                    return new WasmLoadFloat64(8, target, offset);
                }
            }
        }
        return new WasmLoadInt32(4, target, WasmInt32Subtype.INT32, offset);
    }

    @Override
    protected WasmType condBlockType(WasmType thenType, WasmType elseType, ConditionalExpr conditional) {
        PreciseValueType javaType;
        if (conditional.getVariableIndex() >= 0 && (javaType = (PreciseValueType)this.types.typeOf(conditional.getVariableIndex())) != null) {
            return this.mapType(javaType.valueType);
        }
        if (conditional.getConsequent().getVariableIndex() >= 0 && conditional.getConsequent().getVariableIndex() == conditional.getAlternative().getVariableIndex() && (javaType = (PreciseValueType)this.types.typeOf(conditional.getConsequent().getVariableIndex())) != null) {
            return this.mapType(javaType.valueType);
        }
        return super.condBlockType(thenType, elseType, conditional);
    }

    private class SimpleCallSite
    extends BaseWasmGenerationVisitor.CallSiteIdentifier {
        private SimpleCallSite() {
        }

        @Override
        public void generateRegister(List<WasmExpression> consumer, TextLocation location) {
        }

        @Override
        public void checkHandlerId(List<WasmExpression> target, TextLocation location) {
        }

        @Override
        public void generateThrow(List<WasmExpression> target, TextLocation location) {
        }
    }
}

