/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.generate.gc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.teavm.backend.wasm.BaseWasmFunctionRepository;
import org.teavm.backend.wasm.WasmFunctionTypes;
import org.teavm.backend.wasm.gc.vtable.WasmGCVirtualTableProvider;
import org.teavm.backend.wasm.generate.gc.WasmGCInitializerContributor;
import org.teavm.backend.wasm.generate.gc.WasmGCNameProvider;
import org.teavm.backend.wasm.generate.gc.classes.WasmGCClassGenerator;
import org.teavm.backend.wasm.generate.gc.classes.WasmGCClassInfoProvider;
import org.teavm.backend.wasm.generate.gc.classes.WasmGCCustomTypeMapperFactory;
import org.teavm.backend.wasm.generate.gc.classes.WasmGCSupertypeFunctionProvider;
import org.teavm.backend.wasm.generate.gc.classes.WasmGCTypeMapper;
import org.teavm.backend.wasm.generate.gc.methods.WasmGCCustomGeneratorProvider;
import org.teavm.backend.wasm.generate.gc.methods.WasmGCIntrinsicProvider;
import org.teavm.backend.wasm.generate.gc.methods.WasmGCMethodGenerator;
import org.teavm.backend.wasm.generate.gc.strings.WasmGCStringPool;
import org.teavm.backend.wasm.generate.gc.strings.WasmGCStringProvider;
import org.teavm.backend.wasm.model.WasmArray;
import org.teavm.backend.wasm.model.WasmCompositeType;
import org.teavm.backend.wasm.model.WasmFunction;
import org.teavm.backend.wasm.model.WasmModule;
import org.teavm.backend.wasm.model.WasmStructure;
import org.teavm.backend.wasm.model.WasmTag;
import org.teavm.dependency.DependencyInfo;
import org.teavm.diagnostics.Diagnostics;
import org.teavm.model.ClassHierarchy;
import org.teavm.model.ClassReaderSource;
import org.teavm.model.ListableClassHolderSource;
import org.teavm.model.MethodReference;
import org.teavm.model.analysis.ClassInitializerInfo;
import org.teavm.model.analysis.ClassMetadataRequirements;
import org.teavm.model.classes.TagRegistry;
import org.teavm.model.classes.VirtualTableBuilder;

public class WasmGCDeclarationsGenerator {
    public final ClassHierarchy hierarchy;
    public final WasmModule module;
    public final WasmFunctionTypes functionTypes;
    private final WasmGCClassGenerator classGenerator;
    private final WasmGCMethodGenerator methodGenerator;
    private List<WasmGCInitializerContributor> initializerContributors = new ArrayList<WasmGCInitializerContributor>();
    private Collection<MethodReference> additionalMethodsOnCallSites;

    public WasmGCDeclarationsGenerator(WasmModule module, ListableClassHolderSource classes, ClassReaderSource originalClasses, ClassLoader classLoader, ClassInitializerInfo classInitializerInfo, DependencyInfo dependencyInfo, Diagnostics diagnostics, WasmGCCustomGeneratorProvider customGenerators, WasmGCIntrinsicProvider intrinsics, List<WasmGCCustomTypeMapperFactory> customTypeMapperFactories, Predicate<MethodReference> isVirtual, boolean strict, String entryPoint, Collection<MethodReference> additionalMethodsOnCallSites) {
        this.module = module;
        this.hierarchy = new ClassHierarchy(classes);
        this.additionalMethodsOnCallSites = additionalMethodsOnCallSites;
        WasmGCVirtualTableProvider virtualTables = this.createVirtualTableProvider(classes, isVirtual);
        this.functionTypes = new WasmFunctionTypes(module);
        WasmGCNameProvider names = new WasmGCNameProvider();
        this.methodGenerator = new WasmGCMethodGenerator(module, this.hierarchy, classes, classLoader, virtualTables, classInitializerInfo, this.functionTypes, names, diagnostics, customGenerators, intrinsics, dependencyInfo, strict, entryPoint, this.initializerContributors::add);
        TagRegistry tags = new TagRegistry(classes, this.hierarchy);
        ClassMetadataRequirements metadataRequirements = new ClassMetadataRequirements(dependencyInfo);
        this.classGenerator = new WasmGCClassGenerator(module, classes, originalClasses, this.hierarchy, dependencyInfo, this.functionTypes, tags, metadataRequirements, virtualTables, this.methodGenerator, names, classInitializerInfo, customTypeMapperFactories);
        this.methodGenerator.setClassInfoProvider(this.classGenerator);
        this.methodGenerator.setStrings(this.classGenerator.strings);
        this.methodGenerator.setSupertypeFunctions(this.classGenerator.getSupertypeProvider());
        this.methodGenerator.setStandardClasses(this.classGenerator.standardClasses);
        this.methodGenerator.setTypeMapper(this.classGenerator.typeMapper);
    }

    public void setCompactMode(boolean compactMode) {
        this.methodGenerator.setCompactMode(compactMode);
        this.classGenerator.setCompactMode(compactMode);
    }

    public void setFriendlyToDebugger(boolean friendlyToDebugger) {
        this.methodGenerator.setFriendlyToDebugger(friendlyToDebugger);
    }

    public WasmGCClassInfoProvider classInfoProvider() {
        return this.classGenerator;
    }

    public WasmGCTypeMapper typeMapper() {
        return this.classGenerator.typeMapper;
    }

    public BaseWasmFunctionRepository functions() {
        return this.methodGenerator;
    }

    public WasmGCSupertypeFunctionProvider supertypeFunctions() {
        return this.classGenerator.getSupertypeProvider();
    }

    public void generate() {
        int lastTypeIndex = 0;
        do {
            this.generateRound();
            for (int i = lastTypeIndex; i < this.module.types.size(); ++i) {
                WasmCompositeType type = this.module.types.get(i);
                if (type instanceof WasmStructure) {
                    ((WasmStructure)type).init();
                    continue;
                }
                if (!(type instanceof WasmArray)) continue;
                ((WasmArray)type).init();
            }
            lastTypeIndex = this.module.types.size();
        } while (this.methodGenerator.hasSomethingToGenerate() || this.classGenerator.hasSomethingToGenerate());
    }

    private void generateRound() {
        do {
            boolean somethingGenerated = false;
            somethingGenerated |= this.methodGenerator.process();
        } while (somethingGenerated |= this.classGenerator.process());
    }

    public void contributeToInitializer(WasmFunction function) {
        ArrayList<WasmGCStringPool> contributors = new ArrayList<WasmGCStringPool>(List.of(this.classGenerator, this.classGenerator.strings));
        contributors.addAll(this.initializerContributors);
        for (WasmGCInitializerContributor wasmGCInitializerContributor : contributors) {
            wasmGCInitializerContributor.contributeToInitializerDefinitions(function);
        }
        for (WasmGCInitializerContributor wasmGCInitializerContributor : contributors) {
            wasmGCInitializerContributor.contributeToInitializer(function);
        }
    }

    private WasmGCVirtualTableProvider createVirtualTableProvider(ListableClassHolderSource classes, Predicate<MethodReference> isVirtual) {
        LinkedHashSet<MethodReference> methodsOnCallSites = new LinkedHashSet<MethodReference>(VirtualTableBuilder.getMethodsUsedOnCallSites(classes, true));
        methodsOnCallSites.addAll(this.additionalMethodsOnCallSites);
        return new WasmGCVirtualTableProvider(classes, methodsOnCallSites, isVirtual);
    }

    public WasmFunction dummyInitializer() {
        return this.methodGenerator.getDummyInitializer();
    }

    public WasmGCNameProvider names() {
        return this.methodGenerator.names;
    }

    public WasmGCStringProvider strings() {
        return this.classGenerator.strings;
    }

    public WasmTag exceptionTag() {
        return this.methodGenerator.getGenerationContext().getExceptionTag();
    }

    public void addToInitializer(Consumer<WasmFunction> contributor) {
        this.methodGenerator.getGenerationContext().addToInitializer(contributor);
    }
}

