/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.c.intrinsic;

import org.teavm.ast.InvocationExpr;
import org.teavm.backend.c.intrinsic.Intrinsic;
import org.teavm.backend.c.intrinsic.IntrinsicContext;
import org.teavm.model.MethodReference;

public class PlatformIntrinsic
implements Intrinsic {
    private static final String PLATFORM = "org.teavm.platform.Platform";

    @Override
    public boolean canHandle(MethodReference method) {
        if (!method.getClassName().equals(PLATFORM)) {
            return false;
        }
        switch (method.getName()) {
            case "getPlatformObject": 
            case "asJavaClass": {
                return true;
            }
        }
        return false;
    }

    @Override
    public void apply(IntrinsicContext context, InvocationExpr invocation) {
        switch (invocation.getMethod().getName()) {
            case "getPlatformObject": 
            case "asJavaClass": {
                context.emit(invocation.getArguments().get(0));
            }
        }
    }
}

