/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.runtime.heap;

import org.teavm.interop.Address;
import org.teavm.interop.StaticInit;
import org.teavm.interop.Structure;
import org.teavm.interop.Unmanaged;
import org.teavm.runtime.heap.HeapNode;
import org.teavm.runtime.heap.HeapRecord;

@Unmanaged
@StaticInit
public final class Heap {
    private static Address start;
    private static Address end;
    private static int currentSize;
    private static int maxSize;
    private static HeapNode root;

    private Heap() {
    }

    static void init(Address start, int minSize, int maxSize) {
        Heap.start = start;
        end = start.add(minSize);
        currentSize = minSize;
        Heap.maxSize = maxSize;
        root = (HeapNode)start.toStructure();
        Heap.root.size = minSize - Structure.sizeOf(HeapRecord.class);
        Heap.root.left = null;
        Heap.root.right = null;
        Heap.root.list = null;
        Heap.root.height = 1;
        Heap.root.flags = 0;
    }

    static Address getStart() {
        return start;
    }

    static Address getEnd() {
        return end;
    }

    static HeapNode getRoot() {
        return root;
    }

    static int getCurrentSize() {
        return currentSize;
    }

    static int getMaxSize() {
        return maxSize;
    }

    static void resetRoot() {
        root = null;
    }

    public static Address alloc(int bytes) {
        HeapNode last;
        int amountToGrow;
        bytes = (Integer.divideUnsigned(bytes - 1, Address.sizeOf()) + 1) * Address.sizeOf();
        Address result = Heap.tryAlloc(bytes = Math.max(bytes, Structure.sizeOf(HeapNode.class) - Structure.sizeOf(HeapRecord.class)));
        if (result == null && (amountToGrow = bytes - ((last = Heap.lastFreeRecord()) != null ? HeapRecord.size(last) : 0)) > 0 && Heap.tryExtend(amountToGrow, last)) {
            result = Heap.tryAlloc(bytes);
        }
        return result;
    }

    private static boolean tryExtend(int bytes, HeapNode last) {
        if (currentSize + bytes > maxSize) {
            return false;
        }
        int grownBytes = Heap.grow(bytes);
        if (grownBytes == 0) {
            return false;
        }
        currentSize += grownBytes;
        if (last != null) {
            Heap.delete(last);
            last.size += grownBytes;
            Heap.insert(last);
        } else {
            HeapNode newEmpty = (HeapNode)end.toStructure();
            newEmpty.size = grownBytes - Structure.sizeOf(HeapRecord.class);
            Heap.insert(newEmpty);
        }
        end = start.add(currentSize);
        maxSize = Math.max(currentSize, maxSize);
        return grownBytes >= bytes;
    }

    private static HeapNode lastFreeRecord() {
        HeapRecord record = (HeapRecord)start.toStructure();
        HeapRecord result = null;
        while (record.toAddress() != end) {
            int size = HeapRecord.size(record);
            result = HeapRecord.isAllocated(record) ? (HeapRecord)Address.fromInt((int)0).toStructure() : record;
            record = (HeapRecord)record.toAddress().add(Structure.sizeOf(HeapRecord.class) + size).toStructure();
        }
        return (HeapNode)result;
    }

    private static Address tryAlloc(int bytes) {
        if (root == null) {
            return null;
        }
        HeapNode free = Heap.findFree(root, bytes);
        if (free == null) {
            return null;
        }
        Heap.delete(free);
        int currentSize = HeapNode.size(free);
        if (currentSize - bytes >= Structure.sizeOf(HeapNode.class) + Structure.sizeOf(HeapRecord.class)) {
            HeapNode nextFree = (HeapNode)free.toAddress().add(Structure.sizeOf(HeapRecord.class) + bytes).toStructure();
            nextFree.size = currentSize - bytes - Structure.sizeOf(HeapRecord.class);
            nextFree.previousSize = bytes;
            Heap.insert(nextFree);
            free.size = bytes | 1;
            HeapNode nextNext = (HeapNode)nextFree.toAddress().add(Structure.sizeOf(HeapRecord.class) + nextFree.size).toStructure();
            if (nextNext.toAddress().isLessThan(end)) {
                nextNext.previousSize -= bytes + Structure.sizeOf(HeapRecord.class);
            }
        } else {
            free.size |= 1;
        }
        return free.toAddress().add(Structure.sizeOf(HeapRecord.class));
    }

    public static void release(Address address) {
        HeapRecord nextRecord;
        HeapRecord previousRecord;
        HeapRecord record = (HeapRecord)address.add(-Structure.sizeOf(HeapRecord.class)).toStructure();
        int size = HeapRecord.size(record);
        if (start.isLessThan(record.toAddress()) && !HeapRecord.isAllocated(previousRecord = (HeapRecord)record.toAddress().add(-record.previousSize - Structure.sizeOf(HeapRecord.class)).toStructure())) {
            size += previousRecord.size + Structure.sizeOf(HeapRecord.class);
            Heap.delete((HeapNode)previousRecord);
            record = previousRecord;
        }
        if ((nextRecord = (HeapRecord)record.toAddress().add(Structure.sizeOf(HeapRecord.class) + size).toStructure()).toAddress().isLessThan(end) && !HeapRecord.isAllocated(nextRecord)) {
            int bytes = nextRecord.size + Structure.sizeOf(HeapRecord.class);
            size += bytes;
            Heap.delete((HeapNode)nextRecord);
        }
        record.size = size;
        Heap.insert((HeapNode)record);
        HeapRecord next = (HeapRecord)record.toAddress().add(size + Structure.sizeOf(HeapRecord.class)).toStructure();
        if (next.toAddress().isLessThan(end)) {
            next.previousSize = size;
        }
    }

    static void insert(HeapNode node) {
        node.height = 1;
        node.list = null;
        node.left = null;
        node.right = null;
        node.flags = 0;
        root = Heap.insert(root, node);
    }

    private static HeapNode insert(HeapNode into, HeapNode node) {
        if (into == null) {
            node.left = null;
            node.right = null;
            node.flags = (short)(node.flags & 0xFFFFFFFE);
            return node;
        }
        if (node.size < into.size) {
            into.left = Heap.insert(into.left, node);
        } else if (node.size > into.size) {
            into.right = Heap.insert(into.right, node);
        } else {
            node.left = into;
            node.flags = (short)(node.flags | 1);
            node.right = into.list;
            if (into.list != null) {
                into.list.left = node;
            }
            into.list = node;
            return into;
        }
        HeapNode.fix(into);
        return HeapNode.balance(into);
    }

    static void delete(HeapNode node) {
        if ((node.flags & 1) == 0) {
            if (node.list != null) {
                HeapNode newHead = node.list;
                Heap.updateListHolder(node);
                newHead.list = newHead.right;
                newHead.left = node.left;
                newHead.right = node.right;
                newHead.height = node.height;
                newHead.flags = (short)(newHead.flags & 0xFFFFFFFE);
            } else {
                root = Heap.delete(root, node);
            }
        } else {
            if ((node.left.flags & 1) == 0) {
                node.left.list = node.right;
            } else {
                node.left.right = node.right;
            }
            if (node.right != null) {
                node.right.left = node.left;
            }
        }
    }

    private static void updateListHolder(HeapNode node) {
        if (root == node) {
            root = node.list;
            return;
        }
        HeapNode at = root;
        while (true) {
            if (at.left == node) {
                at.left = node.list;
                break;
            }
            if (at.right == node) {
                at.right = node.list;
                break;
            }
            if (node.size < at.size) {
                at = at.left;
                continue;
            }
            at = at.right;
        }
    }

    private static HeapNode delete(HeapNode root, HeapNode node) {
        if (root == null) {
            return null;
        }
        if (node.size < root.size) {
            root.left = Heap.delete(root.left, node);
        } else if (node.size > root.size) {
            root.right = Heap.delete(root.right, node);
        } else {
            if (root.left == null) {
                return root.right;
            }
            if (root.right == null) {
                return root.left;
            }
            HeapNode left = root.left;
            HeapNode min = Heap.findMinimum(root.right);
            min.right = Heap.removeMinimum(root.right);
            min.left = left;
            root = min;
        }
        HeapNode.fix(root);
        return HeapNode.balance(root);
    }

    private static HeapNode removeMinimum(HeapNode node) {
        if (node.left == null) {
            return node.right;
        }
        node.left = Heap.removeMinimum(node.left);
        HeapNode.fix(node);
        return HeapNode.balance(node);
    }

    private static HeapNode findMinimum(HeapNode node) {
        while (node.left != null) {
            node = node.left;
        }
        return node;
    }

    private static HeapNode findFree(HeapNode node, int bytes) {
        while (node != null) {
            if (node.size < bytes) {
                node = node.right;
                continue;
            }
            if (node.size <= bytes || node.left == null || node.left.size < bytes) break;
            node = node.left;
        }
        return node;
    }

    static native int grow(int var0);
}

