/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.model.optimization;

import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Set;
import org.teavm.common.DominatorTree;
import org.teavm.common.Graph;
import org.teavm.common.GraphUtils;
import org.teavm.model.BasicBlock;
import org.teavm.model.Instruction;
import org.teavm.model.Program;
import org.teavm.model.instructions.InitClassInstruction;
import org.teavm.model.instructions.InvokeInstruction;
import org.teavm.model.optimization.MethodOptimization;
import org.teavm.model.optimization.MethodOptimizationContext;
import org.teavm.model.util.ProgramUtils;

public class ClassInitElimination
implements MethodOptimization {
    @Override
    public boolean optimize(MethodOptimizationContext context, Program program) {
        Graph cfg = ProgramUtils.buildControlFlowGraph(program);
        DominatorTree dom = GraphUtils.buildDominatorTree(cfg);
        Graph domGraph = GraphUtils.buildDominatorGraph(dom, program.basicBlockCount());
        Step start = new Step(0);
        ArrayDeque<Step> stack = new ArrayDeque<Step>();
        stack.push(start);
        while (!stack.isEmpty()) {
            Step step = (Step)stack.pop();
            int node = step.node;
            BasicBlock block = program.basicBlockAt(node);
            Instruction insn = block.getFirstInstruction();
            while (insn != null) {
                Instruction nextInsn = insn.getNext();
                if (insn instanceof InitClassInstruction) {
                    InitClassInstruction initClass = (InitClassInstruction)insn;
                    if (!step.initializedClasses.add(initClass.getClassName())) {
                        insn.delete();
                    }
                } else if (insn instanceof InvokeInstruction) {
                    InvokeInstruction invoke = (InvokeInstruction)insn;
                    step.initializedClasses.add(invoke.getMethod().getClassName());
                }
                insn = nextInsn;
            }
            for (int successor : domGraph.outgoingEdges(node)) {
                Step next = new Step(successor);
                next.initializedClasses.addAll(step.initializedClasses);
                stack.push(next);
            }
        }
        return false;
    }

    static class Step {
        int node;
        Set<String> initializedClasses = new HashSet<String>();

        Step(int node) {
            this.node = node;
        }
    }
}

