/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.dependency;

import org.teavm.common.ServiceRepository;
import org.teavm.dependency.DependencyAnalyzer;
import org.teavm.dependency.DependencyGraphBuilder;
import org.teavm.dependency.DependencyNode;
import org.teavm.dependency.MethodDependency;
import org.teavm.diagnostics.Diagnostics;
import org.teavm.model.ClassReaderSource;
import org.teavm.model.FieldReference;
import org.teavm.model.MethodReference;
import org.teavm.model.ReferenceCache;
import org.teavm.model.ValueType;

public class PreciseDependencyAnalyzer
extends DependencyAnalyzer {
    private DependencyNode allArrayItemsNode;
    private static final int DEGREE_THRESHOLD = 2;

    public PreciseDependencyAnalyzer(ClassReaderSource classSource, ClassLoader classLoader, ServiceRepository services, Diagnostics diagnostics, ReferenceCache referenceCache, String[] platformTags) {
        super(classSource, classLoader, services, diagnostics, referenceCache, platformTags);
    }

    @Override
    protected void processMethod(MethodDependency methodDep) {
        DependencyGraphBuilder graphBuilder = new DependencyGraphBuilder(this);
        graphBuilder.buildGraph(methodDep);
    }

    @Override
    DependencyNode createParameterNode(MethodReference method, ValueType type, int index) {
        DependencyNode node = this.createNode(type);
        node.method = method;
        if (shouldTag) {
            node.setTag(String.valueOf(method) + ":" + index);
        }
        return node;
    }

    @Override
    DependencyNode createResultNode(MethodReference method) {
        DependencyNode node = this.createNode(method.getReturnType());
        node.method = method;
        if (shouldTag) {
            node.setTag(String.valueOf(method) + ":RESULT");
        }
        return node;
    }

    @Override
    DependencyNode createThrownNode(MethodReference method) {
        DependencyNode node = this.createNode();
        node.method = method;
        if (shouldTag) {
            node.setTag(String.valueOf(method) + ":THROWN");
        }
        return node;
    }

    @Override
    DependencyNode createFieldNode(FieldReference field, ValueType type) {
        DependencyNode node = this.createNode(type);
        if (shouldTag) {
            node.setTag(field.getClassName() + "#" + field.getFieldName());
        }
        return node;
    }

    @Override
    DependencyNode createArrayItemNode(DependencyNode parent) {
        DependencyNode node;
        ValueType itemTypeFilter;
        ValueType valueType = itemTypeFilter = parent.typeFilter instanceof ValueType.Array ? ((ValueType.Array)parent.typeFilter).getItemType() : null;
        if (parent.degree > 2) {
            if (this.allArrayItemsNode == null) {
                this.allArrayItemsNode = this.createNode(null);
                if (DependencyAnalyzer.shouldTag) {
                    this.allArrayItemsNode.tag = "<any array item>";
                }
            }
            node = this.allArrayItemsNode;
        } else {
            node = this.createNode(itemTypeFilter);
            node.degree = parent.degree + 1;
            node.method = parent.method;
            if (DependencyAnalyzer.shouldTag) {
                node.tag = parent.tag + "[";
            }
        }
        return node;
    }

    @Override
    DependencyNode createClassValueNode(int degree, DependencyNode parent) {
        DependencyNode node = this.createNode();
        node.degree = degree;
        node.classValueNode = node;
        node.classNodeParent = parent;
        if (DependencyAnalyzer.shouldTag) {
            node.tag = parent.tag + "@";
        }
        return node;
    }

    @Override
    boolean domainOptimizationEnabled() {
        return true;
    }

    @Override
    public boolean isPrecise() {
        return true;
    }
}

