/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.debugging.information;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import org.teavm.debugging.information.DebugInformation;
import org.teavm.debugging.information.DebugInformationProvider;

public class URLDebugInformationProvider
implements DebugInformationProvider {
    private String baseURL;

    public URLDebugInformationProvider(String baseURL) {
        this.baseURL = baseURL;
    }

    @Override
    public DebugInformation getDebugInformation(String script) {
        DebugInformation debugInformation;
        block8: {
            URI uri = new URI(this.baseURL + script);
            uri = new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), uri.getPath() + ".teavmdbg", uri.getQuery(), uri.getFragment());
            InputStream input = uri.toURL().openStream();
            try {
                debugInformation = DebugInformation.read(input);
                if (input == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | URISyntaxException e) {
                    return null;
                }
            }
            input.close();
        }
        return debugInformation;
    }
}

