/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.common;

public final class HashUtils {
    private HashUtils() {
    }

    public static String[] createHashTable(String[] values) {
        int tableSize;
        int maxTableSize = Math.min(values.length * 5 / 2, tableSize + 10);
        String[] bestTable = null;
        int bestCollisionRatio = 0;
        for (tableSize = values.length * 2; tableSize <= maxTableSize; ++tableSize) {
            String[] table = new String[tableSize];
            int maxCollisionRatio = 0;
            for (String key : values) {
                int hashCode = key.hashCode();
                int collisionRatio = 0;
                while (true) {
                    int index;
                    if (table[index = Integer.remainderUnsigned(hashCode++, table.length)] == null) break;
                    ++collisionRatio;
                }
                table[index] = key;
                maxCollisionRatio = Math.max(maxCollisionRatio, collisionRatio);
            }
            if (bestTable != null && bestCollisionRatio <= maxCollisionRatio) continue;
            bestCollisionRatio = maxCollisionRatio;
            bestTable = table;
        }
        return bestTable;
    }
}

