/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.common;

import org.teavm.common.Graph;
import org.teavm.common.GraphSplittingBackend;
import org.teavm.common.IntegerArray;
import org.teavm.common.MutableDirectedGraph;
import org.teavm.hppc.IntIntHashMap;

public class DefaultGraphSplittingBackend
implements GraphSplittingBackend {
    private MutableDirectedGraph graph;
    private int index;
    private IntegerArray prototypeNodes;
    private IntegerArray copyIndexes;
    private int[] copyCount;

    public DefaultGraphSplittingBackend(Graph graph) {
        this.graph = new MutableDirectedGraph(graph);
        this.prototypeNodes = new IntegerArray(graph.size());
        this.copyIndexes = new IntegerArray(graph.size());
        this.copyCount = new int[graph.size()];
        this.index = graph.size();
        for (int i = 0; i < graph.size(); ++i) {
            this.prototypeNodes.add(i);
            this.copyIndexes.add(0);
        }
    }

    public Graph getGraph() {
        return this.graph.copyToImmutable();
    }

    public int prototype(int index) {
        return this.prototypeNodes.get(index);
    }

    @Override
    public int[] split(int[] remaining, int[] toCopy) {
        int node;
        int i;
        int[] copies = new int[toCopy.length];
        IntIntHashMap map = new IntIntHashMap();
        for (i = 0; i < toCopy.length; ++i) {
            ++this.index;
            map.put(toCopy[i], copies[i]);
            int proto = this.prototypeNodes.get(toCopy[i]);
            this.prototypeNodes.add(proto);
            int n = proto;
            int n2 = this.copyCount[n] + 1;
            this.copyCount[n] = n2;
            this.copyIndexes.add(n2);
        }
        for (i = 0; i < remaining.length; ++i) {
            node = remaining[i];
            for (int succ : this.graph.outgoingEdges(node)) {
                int succCopy = map.getOrDefault(succ, -1);
                if (succCopy < 0) continue;
                this.graph.deleteEdge(node, succ);
                this.graph.addEdge(node, succCopy);
            }
        }
        for (i = 0; i < toCopy.length; ++i) {
            node = toCopy[i];
            int nodeCopy = copies[i];
            for (int succ : this.graph.outgoingEdges(node)) {
                int succCopy = map.getOrDefault(succ, -1);
                if (succCopy >= 0) {
                    this.graph.addEdge(nodeCopy, succCopy);
                    continue;
                }
                this.graph.addEdge(nodeCopy, succ);
            }
        }
        return copies;
    }
}

