/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.runtime.gc;

import org.teavm.interop.Import;

public class WasmGCSupport {
    private static int lastObjectId = 1831433054;

    private WasmGCSupport() {
    }

    public static NullPointerException npe() {
        return new NullPointerException();
    }

    public static ArrayIndexOutOfBoundsException aiiobe() {
        return new ArrayIndexOutOfBoundsException();
    }

    public static ClassCastException cce() {
        return new ClassCastException();
    }

    public static void throwCloneNotSupportedException() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public static Object defaultClone(Object object) throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public static int nextObjectId() {
        int x = lastObjectId;
        x ^= x << 13;
        x ^= x >>> 17;
        x ^= x << 5;
        lastObjectId = x;
        return x;
    }

    @Import(name="putcharStdout", module="teavmConsole")
    public static native void putCharStdout(char var0);

    @Import(name="putcharStderr", module="teavmConsole")
    public static native void putCharStderr(char var0);

    public static char[] nextCharArray() {
        int length = WasmGCSupport.nextLEB();
        char[] result = new char[length];
        int pos = 0;
        while (pos < length) {
            byte b3;
            byte b2;
            byte b = WasmGCSupport.nextByte();
            if ((b & 0x80) == 0) {
                result[pos++] = (char)b;
                continue;
            }
            if ((b & 0xE0) == 192) {
                b2 = WasmGCSupport.nextByte();
                result[pos++] = (char)((b & 0x1F) << 6 | b2 & 0x3F);
                continue;
            }
            if ((b & 0xF0) == 224) {
                b2 = WasmGCSupport.nextByte();
                b3 = WasmGCSupport.nextByte();
                char c = (char)((b & 0xF) << 12 | (b2 & 0x3F) << 6 | b3 & 0x3F);
                result[pos++] = c;
                continue;
            }
            if ((b & 0xF8) != 240) continue;
            b2 = WasmGCSupport.nextByte();
            b3 = WasmGCSupport.nextByte();
            byte b4 = WasmGCSupport.nextByte();
            int code = (b & 7) << 18 | (b2 & 0x3F) << 12 | (b3 & 0x3F) << 6 | b4 & 0x3F;
            result[pos++] = Character.highSurrogate(code);
            result[pos++] = Character.lowSurrogate(code);
        }
        return result;
    }

    private static int nextLEB() {
        int shift = 0;
        int result = 0;
        while (true) {
            byte b = WasmGCSupport.nextByte();
            int digit = b & 0x7F;
            result |= digit << shift;
            if ((b & 0x80) == 0) break;
            shift += 7;
        }
        return result;
    }

    private static native byte nextByte();

    private static native void error();

    public static StringBuilder createStringBuilder() {
        return new StringBuilder();
    }

    public static String[] createStringArray(int size) {
        return new String[size];
    }

    public static void setToStringArray(String[] array, int index, String value) {
        array[index] = value;
    }
}

