/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.model.expression;

import java.util.Objects;
import org.teavm.backend.wasm.model.WasmStructure;
import org.teavm.backend.wasm.model.expression.WasmExpression;
import org.teavm.backend.wasm.model.expression.WasmExpressionVisitor;
import org.teavm.backend.wasm.model.expression.WasmSignedType;

public class WasmStructGet
extends WasmExpression {
    private WasmStructure type;
    private WasmExpression instance;
    private int fieldIndex;
    private WasmSignedType signedType;

    public WasmStructGet(WasmStructure type, WasmExpression instance, int fieldIndex) {
        WasmStructGet.checkFieldIndex(fieldIndex);
        this.type = Objects.requireNonNull(type);
        this.instance = Objects.requireNonNull(instance);
        this.fieldIndex = fieldIndex;
    }

    public WasmStructure getType() {
        return this.type;
    }

    public void setType(WasmStructure type) {
        this.type = Objects.requireNonNull(type);
    }

    public WasmExpression getInstance() {
        return this.instance;
    }

    public void setInstance(WasmExpression instance) {
        this.instance = Objects.requireNonNull(instance);
    }

    public int getFieldIndex() {
        return this.fieldIndex;
    }

    public void setFieldIndex(int fieldIndex) {
        WasmStructGet.checkFieldIndex(fieldIndex);
        this.fieldIndex = fieldIndex;
    }

    public WasmSignedType getSignedType() {
        return this.signedType;
    }

    public void setSignedType(WasmSignedType signedType) {
        this.signedType = signedType;
    }

    @Override
    public void acceptVisitor(WasmExpressionVisitor visitor) {
        visitor.visit(this);
    }

    private static void checkFieldIndex(int fieldIndex) {
        if (fieldIndex < 0) {
            throw new IllegalArgumentException("Field index must be >= 0");
        }
    }
}

