/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.model.expression;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.teavm.backend.wasm.model.WasmType;
import org.teavm.backend.wasm.model.expression.WasmBreak;
import org.teavm.backend.wasm.model.expression.WasmDefaultExpressionVisitor;
import org.teavm.backend.wasm.model.expression.WasmExpression;
import org.teavm.backend.wasm.model.expression.WasmExpressionVisitor;

public class WasmBlock
extends WasmExpression {
    private boolean loop;
    private List<WasmExpression> body = new ArrayList<WasmExpression>();
    private WasmType type;

    public WasmBlock(boolean loop) {
        this.loop = loop;
    }

    public boolean isLoop() {
        return this.loop;
    }

    public void setLoop(boolean loop) {
        this.loop = loop;
    }

    public List<WasmExpression> getBody() {
        return this.body;
    }

    public WasmType getType() {
        return this.type;
    }

    public void setType(WasmType type) {
        this.type = type;
    }

    @Override
    public void acceptVisitor(WasmExpressionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    protected boolean isTerminating(Set<WasmBlock> blocks) {
        if (this.loop) {
            return false;
        }
        if (this.body.isEmpty()) {
            return false;
        }
        blocks.add(this);
        boolean result = this.body.get(this.body.size() - 1).isTerminating(blocks);
        if (result) {
            BreakFinder breakFinder = new BreakFinder();
            breakFinder.target = this;
            this.acceptVisitor(breakFinder);
            if (breakFinder.found) {
                result = false;
            }
        }
        blocks.remove(this);
        return result;
    }

    private static class BreakFinder
    extends WasmDefaultExpressionVisitor {
        private WasmBlock target;
        private boolean found;

        private BreakFinder() {
        }

        @Override
        public void visit(WasmBreak expression) {
            if (expression.getTarget() == this.target) {
                this.found = true;
            }
        }
    }
}

