/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.intrinsics.gc;

import org.teavm.ast.InvocationExpr;
import org.teavm.backend.wasm.generate.WasmGeneratorUtil;
import org.teavm.backend.wasm.intrinsics.gc.WasmGCIntrinsic;
import org.teavm.backend.wasm.intrinsics.gc.WasmGCIntrinsicContext;
import org.teavm.backend.wasm.model.WasmType;
import org.teavm.backend.wasm.model.expression.WasmExpression;
import org.teavm.backend.wasm.model.expression.WasmFloatBinary;
import org.teavm.backend.wasm.model.expression.WasmFloatBinaryOperation;
import org.teavm.backend.wasm.model.expression.WasmFloatType;
import org.teavm.backend.wasm.model.expression.WasmIntBinary;
import org.teavm.backend.wasm.model.expression.WasmIntBinaryOperation;
import org.teavm.backend.wasm.model.expression.WasmIntType;

public class WasmRuntimeIntrinsic
implements WasmGCIntrinsic {
    @Override
    public WasmExpression apply(InvocationExpr invocation, WasmGCIntrinsicContext context) {
        switch (invocation.getMethod().getName()) {
            case "lt": {
                return WasmRuntimeIntrinsic.comparison(WasmIntBinaryOperation.LT_SIGNED, WasmFloatBinaryOperation.LT, invocation, context);
            }
            case "gt": {
                return WasmRuntimeIntrinsic.comparison(WasmIntBinaryOperation.GT_SIGNED, WasmFloatBinaryOperation.GT, invocation, context);
            }
            case "ltu": {
                return WasmRuntimeIntrinsic.comparison(WasmIntBinaryOperation.LT_UNSIGNED, WasmFloatBinaryOperation.LT, invocation, context);
            }
            case "gtu": {
                return WasmRuntimeIntrinsic.comparison(WasmIntBinaryOperation.GT_UNSIGNED, WasmFloatBinaryOperation.GT, invocation, context);
            }
            case "min": {
                return WasmRuntimeIntrinsic.comparison(WasmIntBinaryOperation.GT_SIGNED, WasmFloatBinaryOperation.MIN, invocation, context);
            }
            case "max": {
                return WasmRuntimeIntrinsic.comparison(WasmIntBinaryOperation.GT_SIGNED, WasmFloatBinaryOperation.MAX, invocation, context);
            }
        }
        throw new IllegalArgumentException(invocation.getMethod().getName());
    }

    private static WasmExpression comparison(WasmIntBinaryOperation intOp, WasmFloatBinaryOperation floatOp, InvocationExpr invocation, WasmGCIntrinsicContext context) {
        WasmType.Number type = (WasmType.Number)WasmGeneratorUtil.mapType(invocation.getMethod().parameterType(0));
        WasmExpression first = context.generate(invocation.getArguments().get(0));
        WasmExpression second = context.generate(invocation.getArguments().get(1));
        switch (type.number) {
            case INT32: {
                return new WasmIntBinary(WasmIntType.INT32, intOp, first, second);
            }
            case INT64: {
                return new WasmIntBinary(WasmIntType.INT64, intOp, first, second);
            }
            case FLOAT32: {
                return new WasmFloatBinary(WasmFloatType.FLOAT32, floatOp, first, second);
            }
            case FLOAT64: {
                return new WasmFloatBinary(WasmFloatType.FLOAT64, floatOp, first, second);
            }
        }
        throw new IllegalArgumentException(type.toString());
    }
}

