/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.intrinsics;

import org.teavm.ast.InvocationExpr;
import org.teavm.backend.wasm.intrinsics.WasmIntrinsic;
import org.teavm.backend.wasm.intrinsics.WasmIntrinsicManager;
import org.teavm.backend.wasm.model.expression.WasmExpression;
import org.teavm.model.MethodDescriptor;
import org.teavm.model.MethodReference;

public class PlatformIntrinsic
implements WasmIntrinsic {
    private static final String PLATFORM = "org.teavm.platform.Platform";

    @Override
    public boolean isApplicable(MethodReference methodReference) {
        return methodReference.getClassName().equals(PLATFORM) && this.isApplicableToMethod(methodReference.getDescriptor());
    }

    private boolean isApplicableToMethod(MethodDescriptor methodDescriptor) {
        switch (methodDescriptor.getName()) {
            case "getPlatformObject": 
            case "asJavaClass": {
                return true;
            }
        }
        return false;
    }

    @Override
    public WasmExpression apply(InvocationExpr invocation, WasmIntrinsicManager manager) {
        switch (invocation.getMethod().getName()) {
            case "getPlatformObject": 
            case "asJavaClass": {
                return manager.generate(invocation.getArguments().get(0));
            }
        }
        throw new IllegalArgumentException(invocation.getMethod().toString());
    }
}

