/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.c.generate;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.teavm.backend.c.generate.FileNameProvider;
import org.teavm.backend.c.generate.StringPool;
import org.teavm.backend.c.generators.Generator;
import org.teavm.backend.c.intrinsic.Intrinsic;
import org.teavm.backend.lowlevel.generate.NameProvider;
import org.teavm.dependency.DependencyInfo;
import org.teavm.diagnostics.Diagnostics;
import org.teavm.model.ClassReaderSource;
import org.teavm.model.MethodReference;
import org.teavm.model.analysis.ClassInitializerInfo;
import org.teavm.model.classes.VirtualTableProvider;
import org.teavm.model.lowlevel.Characteristics;
import org.teavm.vm.BuildTarget;

public class GenerationContext {
    private VirtualTableProvider virtualTableProvider;
    private Characteristics characteristics;
    private DependencyInfo dependencies;
    private StringPool stringPool;
    private NameProvider names;
    private FileNameProvider fileNames;
    private Diagnostics diagnostics;
    private ClassReaderSource classSource;
    private List<Intrinsic> intrinsics;
    private List<Generator> generators;
    private Map<MethodReference, Intrinsic> intrinsicCache = new HashMap<MethodReference, Intrinsic>();
    private Predicate<MethodReference> asyncMethods;
    private BuildTarget buildTarget;
    private ClassInitializerInfo classInitializerInfo;
    private boolean incremental;
    private boolean vmAssertions;
    private boolean heapDump;
    private boolean obfuscated;

    public GenerationContext(VirtualTableProvider virtualTableProvider, Characteristics characteristics, DependencyInfo dependencies, StringPool stringPool, NameProvider names, FileNameProvider fileNames, Diagnostics diagnostics, ClassReaderSource classSource, List<Intrinsic> intrinsics, List<Generator> generators, Predicate<MethodReference> asyncMethods, BuildTarget buildTarget, ClassInitializerInfo classInitializerInfo, boolean incremental, boolean vmAssertions, boolean heapDump, boolean obfuscated) {
        this.virtualTableProvider = virtualTableProvider;
        this.characteristics = characteristics;
        this.dependencies = dependencies;
        this.stringPool = stringPool;
        this.names = names;
        this.fileNames = fileNames;
        this.diagnostics = diagnostics;
        this.classSource = classSource;
        this.intrinsics = new ArrayList<Intrinsic>(intrinsics);
        this.generators = new ArrayList<Generator>(generators);
        this.asyncMethods = asyncMethods;
        this.buildTarget = buildTarget;
        this.classInitializerInfo = classInitializerInfo;
        this.incremental = incremental;
        this.vmAssertions = vmAssertions;
        this.heapDump = heapDump;
        this.obfuscated = obfuscated;
    }

    public void addIntrinsic(Intrinsic intrinsic) {
        this.intrinsics.add(intrinsic);
    }

    public void addGenerator(Generator generator) {
        this.generators.add(generator);
    }

    public VirtualTableProvider getVirtualTableProvider() {
        return this.virtualTableProvider;
    }

    public Characteristics getCharacteristics() {
        return this.characteristics;
    }

    public DependencyInfo getDependencies() {
        return this.dependencies;
    }

    public StringPool getStringPool() {
        return this.stringPool;
    }

    public NameProvider getNames() {
        return this.names;
    }

    public FileNameProvider getFileNames() {
        return this.fileNames;
    }

    public Diagnostics getDiagnostics() {
        return this.diagnostics;
    }

    public ClassReaderSource getClassSource() {
        return this.classSource;
    }

    public Intrinsic getIntrinsic(MethodReference method) {
        return this.intrinsicCache.computeIfAbsent(method, m -> this.intrinsics.stream().filter(i -> i.canHandle((MethodReference)m)).findFirst().orElse(null));
    }

    public Generator getGenerator(MethodReference method) {
        for (Generator generator : this.generators) {
            if (!generator.canHandle(method)) continue;
            return generator;
        }
        return null;
    }

    public boolean isAsync(MethodReference method) {
        return this.asyncMethods.test(method);
    }

    public BuildTarget getBuildTarget() {
        return this.buildTarget;
    }

    public ClassInitializerInfo getClassInitializerInfo() {
        return this.classInitializerInfo;
    }

    public boolean isIncremental() {
        return this.incremental;
    }

    public boolean isHeapDump() {
        return this.heapDump;
    }

    public boolean isVmAssertions() {
        return this.vmAssertions;
    }

    public boolean isObfuscated() {
        return this.obfuscated;
    }
}

