/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.teavm.backend.wasm.model.WasmEntity;

public class WasmCollection<T extends WasmEntity>
implements Iterable<T> {
    private List<T> items = new ArrayList<T>();
    private List<T> readonlyItems = Collections.unmodifiableList(this.items);
    private boolean indexesInvalid;

    WasmCollection() {
    }

    public T get(int index) {
        return (T)((WasmEntity)this.items.get(index));
    }

    public int size() {
        return this.items.size();
    }

    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    public void add(T entity) {
        if (((WasmEntity)entity).collection != null) {
            throw new IllegalArgumentException("Entity already belongs some collection");
        }
        if (!this.indexesInvalid) {
            ((WasmEntity)entity).index = this.items.size();
        }
        ((WasmEntity)entity).collection = this;
        this.items.add(entity);
    }

    public void removeIf(Predicate<T> predicate) {
        for (WasmEntity item : this.items) {
            if (!predicate.test(item)) continue;
            item.collection = null;
        }
        if (this.items.removeIf(predicate)) {
            this.invalidateIndexes();
        }
    }

    public void clear() {
        for (WasmEntity item : this.items) {
            item.collection = null;
        }
        this.items.clear();
    }

    void invalidateIndexes() {
        this.indexesInvalid = true;
    }

    public int indexOf(T entity) {
        if (((WasmEntity)entity).collection != this) {
            throw new IllegalArgumentException("Given entity does not belong to this module");
        }
        if (this.indexesInvalid) {
            this.indexesInvalid = false;
            int index = 0;
            for (WasmEntity item : this.items) {
                if (!item.isImported()) continue;
                item.index = index++;
            }
            for (WasmEntity item : this.items) {
                if (item.isImported()) continue;
                item.index = index++;
            }
        }
        return ((WasmEntity)entity).index;
    }

    @Override
    public Iterator<T> iterator() {
        return this.readonlyItems.iterator();
    }

    public Stream<T> stream() {
        return this.readonlyItems.stream();
    }

    public void sort(Comparator<T> comparator) {
        this.items.sort(comparator);
        this.indexesInvalid = true;
    }
}

