/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.intrinsics.gc;

import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.teavm.backend.wasm.WasmRuntime;
import org.teavm.backend.wasm.generate.gc.methods.WasmGCIntrinsicProvider;
import org.teavm.backend.wasm.intrinsics.gc.ArrayIntrinsic;
import org.teavm.backend.wasm.intrinsics.gc.ClassIntrinsic;
import org.teavm.backend.wasm.intrinsics.gc.ClassSupportIntrinsic;
import org.teavm.backend.wasm.intrinsics.gc.DoubleIntrinsic;
import org.teavm.backend.wasm.intrinsics.gc.FloatIntrinsic;
import org.teavm.backend.wasm.intrinsics.gc.IntNumIntrinsic;
import org.teavm.backend.wasm.intrinsics.gc.ObjectIntrinsic;
import org.teavm.backend.wasm.intrinsics.gc.StringInternPoolIntrinsic;
import org.teavm.backend.wasm.intrinsics.gc.SystemArrayCopyIntrinsic;
import org.teavm.backend.wasm.intrinsics.gc.SystemIntrinsic;
import org.teavm.backend.wasm.intrinsics.gc.WasmGCIntrinsic;
import org.teavm.backend.wasm.intrinsics.gc.WasmGCIntrinsicFactory;
import org.teavm.backend.wasm.intrinsics.gc.WasmGCIntrinsicFactoryContext;
import org.teavm.backend.wasm.intrinsics.gc.WasmGCResourcesIntrinsic;
import org.teavm.backend.wasm.intrinsics.gc.WasmRuntimeIntrinsic;
import org.teavm.backend.wasm.model.expression.WasmIntType;
import org.teavm.backend.wasm.runtime.StringInternPool;
import org.teavm.backend.wasm.runtime.gc.WasmGCResources;
import org.teavm.common.ServiceRepository;
import org.teavm.model.ClassReaderSource;
import org.teavm.model.MethodReference;
import org.teavm.model.ValueType;

public class WasmGCIntrinsics
implements WasmGCIntrinsicProvider {
    private Map<MethodReference, IntrinsicContainer> intrinsics = new HashMap<MethodReference, IntrinsicContainer>();
    private List<WasmGCIntrinsicFactory> factories;
    private ClassReaderSource classes;
    private ServiceRepository services;
    private final WasmGCIntrinsicFactoryContext factoryContext = new WasmGCIntrinsicFactoryContext(){

        @Override
        public ClassReaderSource classes() {
            return WasmGCIntrinsics.this.classes;
        }

        @Override
        public ServiceRepository services() {
            return WasmGCIntrinsics.this.services;
        }
    };

    public WasmGCIntrinsics(ClassReaderSource classes, ServiceRepository services, List<WasmGCIntrinsicFactory> factories, Map<MethodReference, WasmGCIntrinsic> customIntrinsics) {
        this.classes = classes;
        this.services = services;
        this.factories = List.copyOf(factories);
        this.fillWasmRuntime();
        this.fillObject();
        this.fillClass();
        this.fillClassSupport();
        this.fillSystem();
        this.fillLongAndInteger();
        this.fillFloat();
        this.fillDouble();
        this.fillArray();
        this.fillString();
        this.fillResources();
        for (Map.Entry<MethodReference, WasmGCIntrinsic> entry : customIntrinsics.entrySet()) {
            this.add(entry.getKey(), entry.getValue());
        }
    }

    private void fillWasmRuntime() {
        WasmRuntimeIntrinsic intrinsic = new WasmRuntimeIntrinsic();
        for (Class<Double> clazz : List.of(Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE)) {
            this.add(new MethodReference(WasmRuntime.class, "lt", clazz, clazz, Boolean.TYPE), intrinsic);
            this.add(new MethodReference(WasmRuntime.class, "gt", clazz, clazz, Boolean.TYPE), intrinsic);
        }
        for (Class<Number> clazz : List.of(Integer.TYPE, Long.TYPE)) {
            this.add(new MethodReference(WasmRuntime.class, "ltu", clazz, clazz, Boolean.TYPE), intrinsic);
            this.add(new MethodReference(WasmRuntime.class, "gtu", clazz, clazz, Boolean.TYPE), intrinsic);
        }
        for (Class<Number> clazz : List.of(Float.TYPE, Double.TYPE)) {
            this.add(new MethodReference(WasmRuntime.class, "min", clazz, clazz, clazz), intrinsic);
            this.add(new MethodReference(WasmRuntime.class, "max", clazz, clazz, clazz), intrinsic);
        }
    }

    private void fillObject() {
        ObjectIntrinsic intrinsic = new ObjectIntrinsic();
        this.add(new MethodReference(Object.class, "getClass", Class.class), intrinsic);
        this.add(new MethodReference(Object.class, "cloneObject", Object.class), intrinsic);
        this.add(new MethodReference(Object.class.getName(), "getMonitor", ValueType.object("java.lang.Object$Monitor")), intrinsic);
        this.add(new MethodReference(Object.class.getName(), "setMonitor", ValueType.object("java.lang.Object$Monitor"), ValueType.VOID), intrinsic);
        this.add(new MethodReference(Object.class.getName(), "wasmGCIdentity", ValueType.INTEGER), intrinsic);
        this.add(new MethodReference(Object.class.getName(), "setWasmGCIdentity", ValueType.INTEGER, ValueType.VOID), intrinsic);
    }

    private void fillClass() {
        ClassIntrinsic intrinsic = new ClassIntrinsic();
        this.add(new MethodReference(Class.class, "getComponentType", Class.class), intrinsic);
        this.add(new MethodReference(Class.class, "getWasmGCFlags", Integer.TYPE), intrinsic);
        this.add(new MethodReference(Class.class, "getNameImpl", String.class), intrinsic);
        this.add(new MethodReference(Class.class, "setNameImpl", String.class, Void.TYPE), intrinsic);
        this.add(new MethodReference(Class.class, "getEnclosingClass", Class.class), intrinsic);
        this.add(new MethodReference(Class.class, "getDeclaringClass", Class.class), intrinsic);
        this.add(new MethodReference(Class.class, "getSuperclass", Class.class), intrinsic);
        this.add(new MethodReference(Class.class, "getSimpleNameCache", Class.class, String.class), intrinsic);
        this.add(new MethodReference(Class.class, "setSimpleNameCache", Class.class, String.class, Void.TYPE), intrinsic);
        this.add(new MethodReference(Class.class, "getCanonicalNameCache", String.class), intrinsic);
        this.add(new MethodReference(Class.class, "setCanonicalNameCache", String.class, Void.TYPE), intrinsic);
    }

    private void fillClassSupport() {
        ClassSupportIntrinsic intrinsic = new ClassSupportIntrinsic();
        this.add(new MethodReference("org.teavm.classlib.impl.reflection.ClassSupport", "getEnumConstants", ValueType.object("java.lang.Class"), ValueType.arrayOf(ValueType.object("java.lang.Enum"))), intrinsic);
    }

    private void fillSystem() {
        SystemArrayCopyIntrinsic arrayCopyIntrinsic = new SystemArrayCopyIntrinsic();
        this.add(new MethodReference(System.class, "arraycopy", Object.class, Integer.TYPE, Object.class, Integer.TYPE, Integer.TYPE, Void.TYPE), arrayCopyIntrinsic);
        this.add(new MethodReference(System.class, "doArrayCopy", Object.class, Integer.TYPE, Object.class, Integer.TYPE, Integer.TYPE, Void.TYPE), arrayCopyIntrinsic);
        this.add(new MethodReference(System.class, "currentTimeMillis", Long.TYPE), new SystemIntrinsic());
    }

    private void fillLongAndInteger() {
        this.fillIntNum(Integer.TYPE, Integer.class, WasmIntType.INT32);
        this.fillIntNum(Long.TYPE, Long.class, WasmIntType.INT64);
    }

    private void fillIntNum(Class<?> javaClass, Class<?> wrapperClass, WasmIntType wasmType) {
        IntNumIntrinsic intrinsic = new IntNumIntrinsic(javaClass, wasmType);
        this.add(new MethodReference(wrapperClass, "divideUnsigned", javaClass, javaClass, javaClass), intrinsic);
        this.add(new MethodReference(wrapperClass, "remainderUnsigned", javaClass, javaClass, javaClass), intrinsic);
        this.add(new MethodReference(wrapperClass, "compareUnsigned", javaClass, javaClass, Integer.TYPE), intrinsic);
        this.add(new MethodReference(wrapperClass, "numberOfLeadingZeros", javaClass, Integer.TYPE), intrinsic);
        this.add(new MethodReference(wrapperClass, "numberOfTrailingZeros", javaClass, Integer.TYPE), intrinsic);
        this.add(new MethodReference(wrapperClass, "bitCount", javaClass, Integer.TYPE), intrinsic);
    }

    private void fillFloat() {
        FloatIntrinsic intrinsic = new FloatIntrinsic();
        this.add(new MethodReference(Float.class, "getNaN", Float.TYPE), intrinsic);
        this.add(new MethodReference(Float.class, "isNaN", Float.TYPE, Boolean.TYPE), intrinsic);
        this.add(new MethodReference(Float.class, "isInfinite", Float.TYPE, Boolean.TYPE), intrinsic);
        this.add(new MethodReference(Float.class, "isFinite", Float.TYPE, Boolean.TYPE), intrinsic);
        this.add(new MethodReference(Float.class, "floatToRawIntBits", Float.TYPE, Integer.TYPE), intrinsic);
        this.add(new MethodReference(Float.class, "intBitsToFloat", Integer.TYPE, Float.TYPE), intrinsic);
    }

    private void fillDouble() {
        DoubleIntrinsic intrinsic = new DoubleIntrinsic();
        this.add(new MethodReference(Double.class, "getNaN", Double.TYPE), intrinsic);
        this.add(new MethodReference(Double.class, "isNaN", Double.TYPE, Boolean.TYPE), intrinsic);
        this.add(new MethodReference(Double.class, "isInfinite", Double.TYPE, Boolean.TYPE), intrinsic);
        this.add(new MethodReference(Double.class, "isFinite", Double.TYPE, Boolean.TYPE), intrinsic);
        this.add(new MethodReference(Double.class, "doubleToRawLongBits", Double.TYPE, Long.TYPE), intrinsic);
        this.add(new MethodReference(Double.class, "longBitsToDouble", Long.TYPE, Double.TYPE), intrinsic);
    }

    private void fillArray() {
        ArrayIntrinsic intrinsic = new ArrayIntrinsic();
        this.add(new MethodReference(Array.class, "getLength", Object.class, Integer.TYPE), intrinsic);
        this.add(new MethodReference(Array.class, "getImpl", Object.class, Integer.TYPE, Object.class), intrinsic);
    }

    private void fillString() {
        StringInternPoolIntrinsic intrinsic = new StringInternPoolIntrinsic();
        String className = StringInternPool.class.getName() + "$Entry";
        this.add(new MethodReference(className, "getValue", ValueType.parse(String.class)), intrinsic);
        this.add(new MethodReference(className, "setValue", ValueType.parse(String.class), ValueType.VOID), intrinsic);
    }

    private void fillResources() {
        WasmGCResourcesIntrinsic intrinsic = new WasmGCResourcesIntrinsic();
        this.add(new MethodReference(WasmGCResources.class, "readSingleByte", Integer.TYPE, Integer.TYPE), intrinsic);
    }

    private void add(MethodReference methodRef, WasmGCIntrinsic intrinsic) {
        this.intrinsics.put(methodRef, new IntrinsicContainer(intrinsic));
    }

    @Override
    public WasmGCIntrinsic get(MethodReference method) {
        IntrinsicContainer result = this.intrinsics.get(method);
        if (result == null) {
            WasmGCIntrinsicFactory factory;
            WasmGCIntrinsic intrinsic = null;
            Iterator<WasmGCIntrinsicFactory> iterator = this.factories.iterator();
            while (iterator.hasNext() && (intrinsic = (factory = iterator.next()).createIntrinsic(method, this.factoryContext)) == null) {
            }
            this.intrinsics.put(method, new IntrinsicContainer(intrinsic));
            result = new IntrinsicContainer(intrinsic);
        }
        return result.intrinsic;
    }

    static class IntrinsicContainer {
        final WasmGCIntrinsic intrinsic;

        IntrinsicContainer(WasmGCIntrinsic intrinsic) {
            this.intrinsic = intrinsic;
        }
    }
}

