/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.intrinsics.gc;

import org.teavm.ast.InvocationExpr;
import org.teavm.backend.wasm.generate.CachedExpression;
import org.teavm.backend.wasm.intrinsics.gc.WasmGCIntrinsic;
import org.teavm.backend.wasm.intrinsics.gc.WasmGCIntrinsicContext;
import org.teavm.backend.wasm.model.WasmLocal;
import org.teavm.backend.wasm.model.WasmStructure;
import org.teavm.backend.wasm.model.WasmType;
import org.teavm.backend.wasm.model.expression.WasmBlock;
import org.teavm.backend.wasm.model.expression.WasmBranch;
import org.teavm.backend.wasm.model.expression.WasmCallReference;
import org.teavm.backend.wasm.model.expression.WasmCast;
import org.teavm.backend.wasm.model.expression.WasmDrop;
import org.teavm.backend.wasm.model.expression.WasmExpression;
import org.teavm.backend.wasm.model.expression.WasmGetLocal;
import org.teavm.backend.wasm.model.expression.WasmInt31Get;
import org.teavm.backend.wasm.model.expression.WasmInt31Reference;
import org.teavm.backend.wasm.model.expression.WasmInt32Constant;
import org.teavm.backend.wasm.model.expression.WasmIntType;
import org.teavm.backend.wasm.model.expression.WasmIntUnary;
import org.teavm.backend.wasm.model.expression.WasmIntUnaryOperation;
import org.teavm.backend.wasm.model.expression.WasmNullConstant;
import org.teavm.backend.wasm.model.expression.WasmSetLocal;
import org.teavm.backend.wasm.model.expression.WasmSignedType;
import org.teavm.backend.wasm.model.expression.WasmStructGet;
import org.teavm.backend.wasm.model.expression.WasmStructSet;
import org.teavm.backend.wasm.model.expression.WasmTest;
import org.teavm.model.ValueType;

public class ObjectIntrinsic
implements WasmGCIntrinsic {
    @Override
    public WasmExpression apply(InvocationExpr invocation, WasmGCIntrinsicContext context) {
        switch (invocation.getMethod().getName()) {
            case "getClass": {
                return this.generateGetClass(invocation, context);
            }
            case "getMonitor": {
                return this.generateGetMonitor(invocation, context);
            }
            case "setMonitor": {
                return this.generateSetMonitor(invocation, context);
            }
            case "wasmGCIdentity": {
                return this.generateGetIdentity(invocation, context);
            }
            case "setWasmGCIdentity": {
                return this.generateSetIdentity(invocation, context);
            }
            case "cloneObject": {
                return this.generateClone(invocation, context);
            }
        }
        throw new IllegalArgumentException();
    }

    private WasmExpression generateGetClass(InvocationExpr invocation, WasmGCIntrinsicContext context) {
        WasmExpression obj = context.generate(invocation.getArguments().get(0));
        WasmStructure objectStruct = context.classInfoProvider().getClassInfo("java.lang.Object").getStructure();
        WasmStructGet result = new WasmStructGet(objectStruct, obj, 0);
        result.setLocation(invocation.getLocation());
        return result;
    }

    private WasmExpression generateGetMonitor(InvocationExpr invocation, WasmGCIntrinsicContext context) {
        WasmStructure monitorStruct = context.classInfoProvider().getClassInfo(ValueType.object("java.lang.Object$Monitor")).getStructure();
        WasmType.CompositeReference monitorType = monitorStruct.getReference();
        WasmType.CompositeReference monitorNotNullType = monitorStruct.getNonNullReference();
        WasmStructure objectStruct = context.classInfoProvider().getClassInfo(ValueType.object("java.lang.Object")).getStructure();
        WasmBlock block = new WasmBlock(false);
        block.setType(monitorType);
        WasmLocal tmpVar = context.tempVars().acquire(WasmType.Reference.ANY);
        WasmExpression instance = context.generate(invocation.getArguments().get(0));
        block.getBody().add(new WasmSetLocal(tmpVar, new WasmStructGet(objectStruct, instance, 1)));
        WasmExpression test = new WasmTest(new WasmGetLocal(tmpVar), monitorNotNullType);
        test = new WasmIntUnary(WasmIntType.INT32, WasmIntUnaryOperation.EQZ, test);
        WasmBranch branch = new WasmBranch(test, block);
        branch.setResult(new WasmNullConstant(monitorType));
        block.getBody().add(new WasmDrop(branch));
        block.getBody().add(new WasmCast(new WasmGetLocal(tmpVar), monitorNotNullType));
        context.tempVars().release(tmpVar);
        return block;
    }

    private WasmExpression generateSetMonitor(InvocationExpr invocation, WasmGCIntrinsicContext context) {
        WasmStructure objectStruct = context.classInfoProvider().getClassInfo(ValueType.object("java.lang.Object")).getStructure();
        WasmExpression instance = context.generate(invocation.getArguments().get(0));
        WasmExpression monitor = context.generate(invocation.getArguments().get(1));
        return new WasmStructSet(objectStruct, instance, 1, monitor);
    }

    private WasmExpression generateGetIdentity(InvocationExpr invocation, WasmGCIntrinsicContext context) {
        WasmStructure objectStruct = context.classInfoProvider().getClassInfo(ValueType.object("java.lang.Object")).getStructure();
        WasmBlock block = new WasmBlock(false);
        block.setType(WasmType.INT32);
        WasmLocal tmpVar = context.tempVars().acquire(WasmType.Reference.ANY);
        WasmExpression instance = context.generate(invocation.getArguments().get(0));
        block.getBody().add(new WasmSetLocal(tmpVar, new WasmStructGet(objectStruct, instance, 1)));
        WasmExpression test = new WasmTest(new WasmGetLocal(tmpVar), WasmType.SpecialReferenceKind.I31.asNonNullType());
        test = new WasmIntUnary(WasmIntType.INT32, WasmIntUnaryOperation.EQZ, test);
        WasmBranch branch = new WasmBranch(test, block);
        branch.setResult(new WasmInt32Constant(-1));
        block.getBody().add(new WasmDrop(branch));
        WasmCast i31ref = new WasmCast(new WasmGetLocal(tmpVar), WasmType.SpecialReferenceKind.I31.asNonNullType());
        block.getBody().add(new WasmInt31Get(i31ref, WasmSignedType.UNSIGNED));
        context.tempVars().release(tmpVar);
        return block;
    }

    private WasmExpression generateSetIdentity(InvocationExpr invocation, WasmGCIntrinsicContext context) {
        WasmStructure objectStruct = context.classInfoProvider().getClassInfo(ValueType.object("java.lang.Object")).getStructure();
        WasmExpression instance = context.generate(invocation.getArguments().get(0));
        WasmExpression identity = context.generate(invocation.getArguments().get(1));
        WasmInt31Reference identityWrapper = new WasmInt31Reference(identity);
        return new WasmStructSet(objectStruct, instance, 1, identityWrapper);
    }

    private WasmExpression generateClone(InvocationExpr invocation, WasmGCIntrinsicContext context) {
        WasmStructure objectStruct = context.classInfoProvider().getClassInfo("java.lang.Object").getStructure();
        WasmStructure classStruct = context.classInfoProvider().getClassInfo("java.lang.Class").getStructure();
        WasmBlock block = new WasmBlock(false);
        block.setType(objectStruct.getReference());
        CachedExpression obj = context.exprCache().create(context.generate(invocation.getArguments().get(0)), objectStruct.getReference(), invocation.getLocation(), block.getBody());
        WasmStructGet cls = new WasmStructGet(objectStruct, obj.expr(), 0);
        WasmStructGet functionRef = new WasmStructGet(classStruct, cls, context.classInfoProvider().getCloneOffset());
        WasmCallReference call = new WasmCallReference(functionRef, context.functionTypes().of(objectStruct.getReference(), objectStruct.getReference()));
        call.getArguments().add(obj.expr());
        block.getBody().add(call);
        obj.release();
        return block;
    }
}

