/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.intrinsics.gc;

import org.teavm.ast.InvocationExpr;
import org.teavm.backend.wasm.generate.gc.classes.WasmGCClassInfo;
import org.teavm.backend.wasm.intrinsics.gc.WasmGCIntrinsic;
import org.teavm.backend.wasm.intrinsics.gc.WasmGCIntrinsicContext;
import org.teavm.backend.wasm.model.WasmStructure;
import org.teavm.backend.wasm.model.expression.WasmExpression;
import org.teavm.backend.wasm.model.expression.WasmStructGet;
import org.teavm.backend.wasm.model.expression.WasmStructSet;

public class ClassIntrinsic
implements WasmGCIntrinsic {
    @Override
    public WasmExpression apply(InvocationExpr invocation, WasmGCIntrinsicContext context) {
        switch (invocation.getMethod().getName()) {
            case "getWasmGCFlags": {
                WasmExpression cls = context.generate(invocation.getArguments().get(0));
                WasmStructure clsStruct = context.classInfoProvider().getClassInfo("java.lang.Class").getStructure();
                WasmStructGet result = new WasmStructGet(clsStruct, cls, context.classInfoProvider().getClassFlagsOffset());
                result.setLocation(invocation.getLocation());
                return result;
            }
            case "getComponentType": {
                WasmExpression cls = context.generate(invocation.getArguments().get(0));
                WasmStructure clsStruct = context.classInfoProvider().getClassInfo("java.lang.Class").getStructure();
                WasmStructGet result = new WasmStructGet(clsStruct, cls, context.classInfoProvider().getClassArrayItemOffset());
                result.setLocation(invocation.getLocation());
                return result;
            }
            case "getEnclosingClass": {
                WasmExpression cls = context.generate(invocation.getArguments().get(0));
                WasmStructure clsStruct = context.classInfoProvider().getClassInfo("java.lang.Class").getStructure();
                WasmStructGet result = new WasmStructGet(clsStruct, cls, context.classInfoProvider().getClassEnclosingClassOffset());
                result.setLocation(invocation.getLocation());
                return result;
            }
            case "getDeclaringClass": {
                WasmExpression cls = context.generate(invocation.getArguments().get(0));
                WasmStructure clsStruct = context.classInfoProvider().getClassInfo("java.lang.Class").getStructure();
                WasmStructGet result = new WasmStructGet(clsStruct, cls, context.classInfoProvider().getClassDeclaringClassOffset());
                result.setLocation(invocation.getLocation());
                return result;
            }
            case "getSuperclass": {
                WasmExpression cls = context.generate(invocation.getArguments().get(0));
                WasmStructure clsStruct = context.classInfoProvider().getClassInfo("java.lang.Class").getStructure();
                WasmStructGet result = new WasmStructGet(clsStruct, cls, context.classInfoProvider().getClassParentOffset());
                result.setLocation(invocation.getLocation());
                return result;
            }
            case "getNameImpl": {
                return this.generateGetName(invocation, context);
            }
            case "setNameImpl": {
                return this.generateSetName(invocation, context);
            }
            case "getSimpleNameCache": {
                return this.generateGetSimpleName(invocation, context);
            }
            case "setSimpleNameCache": {
                return this.generateSetSimpleName(invocation, context);
            }
            case "getCanonicalNameCache": {
                return this.generateGetCanonicalName(invocation, context);
            }
            case "setCanonicalNameCache": {
                return this.generateSetCanonicalName(invocation, context);
            }
        }
        throw new IllegalArgumentException("Unsupported invocation method: " + String.valueOf(invocation.getMethod()));
    }

    private WasmExpression generateGetName(InvocationExpr invocation, WasmGCIntrinsicContext context) {
        WasmGCClassInfo classCls = context.classInfoProvider().getClassInfo("java.lang.Class");
        WasmExpression arg = context.generate(invocation.getArguments().get(0));
        return new WasmStructGet(classCls.getStructure(), arg, context.classInfoProvider().getClassNameOffset());
    }

    private WasmExpression generateSetName(InvocationExpr invocation, WasmGCIntrinsicContext context) {
        WasmGCClassInfo classCls = context.classInfoProvider().getClassInfo("java.lang.Class");
        WasmExpression arg = context.generate(invocation.getArguments().get(0));
        WasmExpression value = context.generate(invocation.getArguments().get(1));
        return new WasmStructSet(classCls.getStructure(), arg, context.classInfoProvider().getClassNameOffset(), value);
    }

    private WasmExpression generateGetSimpleName(InvocationExpr invocation, WasmGCIntrinsicContext context) {
        WasmGCClassInfo classCls = context.classInfoProvider().getClassInfo("java.lang.Class");
        WasmExpression arg = context.generate(invocation.getArguments().get(0));
        return new WasmStructGet(classCls.getStructure(), arg, context.classInfoProvider().getClassSimpleNameOffset());
    }

    private WasmExpression generateSetSimpleName(InvocationExpr invocation, WasmGCIntrinsicContext context) {
        WasmGCClassInfo classCls = context.classInfoProvider().getClassInfo("java.lang.Class");
        WasmExpression arg = context.generate(invocation.getArguments().get(0));
        WasmExpression value = context.generate(invocation.getArguments().get(1));
        return new WasmStructSet(classCls.getStructure(), arg, context.classInfoProvider().getClassSimpleNameOffset(), value);
    }

    private WasmExpression generateGetCanonicalName(InvocationExpr invocation, WasmGCIntrinsicContext context) {
        WasmGCClassInfo classCls = context.classInfoProvider().getClassInfo("java.lang.Class");
        WasmExpression arg = context.generate(invocation.getArguments().get(0));
        return new WasmStructGet(classCls.getStructure(), arg, context.classInfoProvider().getClassCanonicalNameOffset());
    }

    private WasmExpression generateSetCanonicalName(InvocationExpr invocation, WasmGCIntrinsicContext context) {
        WasmGCClassInfo classCls = context.classInfoProvider().getClassInfo("java.lang.Class");
        WasmExpression arg = context.generate(invocation.getArguments().get(0));
        WasmExpression value = context.generate(invocation.getArguments().get(1));
        return new WasmStructSet(classCls.getStructure(), arg, context.classInfoProvider().getClassCanonicalNameOffset(), value);
    }
}

