/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.intrinsics.gc;

import org.teavm.ast.InvocationExpr;
import org.teavm.backend.wasm.generate.CachedExpression;
import org.teavm.backend.wasm.intrinsics.gc.WasmGCIntrinsic;
import org.teavm.backend.wasm.intrinsics.gc.WasmGCIntrinsicContext;
import org.teavm.backend.wasm.model.WasmFunctionType;
import org.teavm.backend.wasm.model.WasmStructure;
import org.teavm.backend.wasm.model.WasmType;
import org.teavm.backend.wasm.model.expression.WasmBlock;
import org.teavm.backend.wasm.model.expression.WasmCallReference;
import org.teavm.backend.wasm.model.expression.WasmCast;
import org.teavm.backend.wasm.model.expression.WasmExpression;
import org.teavm.backend.wasm.model.expression.WasmStructGet;

public class ArrayIntrinsic
implements WasmGCIntrinsic {
    @Override
    public WasmExpression apply(InvocationExpr invocation, WasmGCIntrinsicContext context) {
        switch (invocation.getMethod().getName()) {
            case "getLength": {
                return this.arrayLength(invocation, context);
            }
            case "getImpl": {
                return this.arrayGet(invocation, context);
            }
        }
        throw new IllegalArgumentException("Unknown method: " + String.valueOf(invocation.getMethod()));
    }

    private WasmExpression arrayLength(InvocationExpr invocation, WasmGCIntrinsicContext context) {
        return this.arrayVirtualCall(invocation, context, context.classInfoProvider().getArrayLengthOffset());
    }

    private WasmExpression arrayGet(InvocationExpr invocation, WasmGCIntrinsicContext context) {
        return this.arrayVirtualCall(invocation, context, context.classInfoProvider().getArrayGetOffset());
    }

    private WasmExpression arrayVirtualCall(InvocationExpr invocation, WasmGCIntrinsicContext context, int offset) {
        WasmStructure objectStruct = context.classInfoProvider().getClassInfo("java.lang.Object").getStructure();
        WasmStructure vtStruct = context.classInfoProvider().getArrayVirtualTableStructure();
        WasmType.CompositeReference type = (WasmType.CompositeReference)vtStruct.getFields().get(offset).getUnpackedType();
        WasmFunctionType functionType = (WasmFunctionType)type.composite;
        WasmBlock block = new WasmBlock(false);
        block.setType(functionType.getReturnType());
        WasmExpression originalObject = context.generate(invocation.getArguments().get(0));
        CachedExpression object = context.exprCache().create(originalObject, objectStruct.getReference(), invocation.getLocation(), block.getBody());
        WasmStructGet classRef = new WasmStructGet(objectStruct, object.expr(), 0);
        WasmCast vt = new WasmCast(classRef, vtStruct.getNonNullReference());
        WasmStructGet function = new WasmStructGet(vtStruct, vt, offset);
        WasmCallReference call = new WasmCallReference(function, functionType);
        call.getArguments().add(object.expr());
        for (int i = 1; i < invocation.getArguments().size(); ++i) {
            call.getArguments().add(context.generate(invocation.getArguments().get(i)));
        }
        block.getBody().add(call);
        object.release();
        return block;
    }
}

