/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.generators.gc;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import org.teavm.backend.wasm.generators.gc.WasmGCCustomGenerator;
import org.teavm.backend.wasm.generators.gc.WasmGCCustomGeneratorContext;
import org.teavm.backend.wasm.model.WasmFunction;
import org.teavm.backend.wasm.model.WasmLocal;
import org.teavm.backend.wasm.model.WasmStructure;
import org.teavm.backend.wasm.model.WasmType;
import org.teavm.backend.wasm.model.expression.WasmBlock;
import org.teavm.backend.wasm.model.expression.WasmCall;
import org.teavm.backend.wasm.model.expression.WasmGetLocal;
import org.teavm.backend.wasm.model.expression.WasmNullBranch;
import org.teavm.backend.wasm.model.expression.WasmNullCondition;
import org.teavm.backend.wasm.model.expression.WasmNullConstant;
import org.teavm.backend.wasm.model.expression.WasmReturn;
import org.teavm.backend.wasm.model.expression.WasmStructGet;
import org.teavm.backend.wasm.model.expression.WasmStructSet;
import org.teavm.model.MethodReference;
import org.teavm.model.ValueType;

public class WeakReferenceGenerator
implements WasmGCCustomGenerator {
    private WasmFunction createWeakReferenceFunction;

    @Override
    public void apply(MethodReference method, WasmFunction function, WasmGCCustomGeneratorContext context) {
        switch (method.getName()) {
            case "<init>": {
                this.generateConstructor(context, function);
                break;
            }
            case "get": {
                this.generateDeref(context, function);
                break;
            }
            case "clear": {
                this.generateClear(context, function);
            }
        }
    }

    private void generateConstructor(WasmGCCustomGeneratorContext context, WasmFunction function) {
        WasmStructure weakRefStruct = context.classInfoProvider().getClassInfo(WeakReference.class.getName()).getStructure();
        WasmLocal thisLocal = new WasmLocal(weakRefStruct.getReference(), "this");
        WasmLocal valueLocal = new WasmLocal(context.typeMapper().mapType(ValueType.parse(Object.class)), "value");
        WasmLocal queueLocal = new WasmLocal(context.typeMapper().mapType(ValueType.parse(ReferenceQueue.class)), "queue");
        function.add(thisLocal);
        function.add(valueLocal);
        function.add(queueLocal);
        WasmFunction weakRefConstructor = this.getCreateWeakReferenceFunction(context);
        WasmCall weakRef = new WasmCall(weakRefConstructor, new WasmGetLocal(valueLocal), new WasmGetLocal(thisLocal), new WasmGetLocal(queueLocal));
        function.getBody().add(new WasmStructSet(weakRefStruct, new WasmGetLocal(thisLocal), 2, weakRef));
    }

    private void generateDeref(WasmGCCustomGeneratorContext context, WasmFunction function) {
        WasmStructure weakRefStruct = context.classInfoProvider().getClassInfo(WeakReference.class.getName()).getStructure();
        WasmType.CompositeReference objectType = context.classInfoProvider().getClassInfo("java.lang.Object").getType();
        WasmLocal thisLocal = new WasmLocal(weakRefStruct.getReference(), "this");
        function.add(thisLocal);
        WasmBlock block = new WasmBlock(false);
        block.setType(WasmType.Reference.EXTERN);
        WasmStructGet weakRef = new WasmStructGet(weakRefStruct, new WasmGetLocal(thisLocal), 2);
        WasmNullBranch br = new WasmNullBranch(WasmNullCondition.NOT_NULL, weakRef, block);
        block.getBody().add(br);
        block.getBody().add(new WasmReturn(new WasmNullConstant(objectType)));
        function.getBody().add(new WasmCall(this.createDerefFunction(context), block));
    }

    private void generateClear(WasmGCCustomGeneratorContext context, WasmFunction function) {
        WasmStructure weakRefStruct = context.classInfoProvider().getClassInfo(WeakReference.class.getName()).getStructure();
        WasmLocal thisLocal = new WasmLocal(weakRefStruct.getReference(), "this");
        function.add(thisLocal);
        function.getBody().add(new WasmStructSet(weakRefStruct, new WasmGetLocal(thisLocal), 2, new WasmNullConstant(WasmType.Reference.EXTERN)));
    }

    private WasmFunction getCreateWeakReferenceFunction(WasmGCCustomGeneratorContext context) {
        if (this.createWeakReferenceFunction == null) {
            WasmFunction function = new WasmFunction(context.functionTypes().of(WasmType.Reference.EXTERN, context.typeMapper().mapType(ValueType.parse(Object.class)), context.typeMapper().mapType(ValueType.parse(WeakReference.class)), context.typeMapper().mapType(ValueType.parse(ReferenceQueue.class))));
            function.setName(context.names().topLevel("teavm@createWeakReference"));
            function.setImportName("createWeakRef");
            function.setImportModule("teavm");
            context.module().functions.add(function);
            this.createWeakReferenceFunction = function;
        }
        return this.createWeakReferenceFunction;
    }

    private WasmFunction createDerefFunction(WasmGCCustomGeneratorContext context) {
        WasmFunction function = new WasmFunction(context.functionTypes().of(context.typeMapper().mapType(ValueType.parse(Object.class)), WasmType.Reference.EXTERN));
        function.setName(context.names().topLevel("teavm@deref"));
        function.setImportName("deref");
        function.setImportModule("teavm");
        context.module().functions.add(function);
        return function;
    }
}

