/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.generators.gc;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.ServiceLoader;
import org.teavm.backend.wasm.generate.gc.methods.WasmGCGenerationUtil;
import org.teavm.backend.wasm.generate.gc.strings.WasmGCStringConstant;
import org.teavm.backend.wasm.generators.gc.WasmGCCustomGenerator;
import org.teavm.backend.wasm.generators.gc.WasmGCCustomGeneratorContext;
import org.teavm.backend.wasm.model.WasmFunction;
import org.teavm.backend.wasm.model.WasmGlobal;
import org.teavm.backend.wasm.model.WasmMemorySegment;
import org.teavm.backend.wasm.model.WasmModule;
import org.teavm.backend.wasm.model.WasmType;
import org.teavm.backend.wasm.model.expression.WasmCall;
import org.teavm.backend.wasm.model.expression.WasmGetGlobal;
import org.teavm.backend.wasm.model.expression.WasmInt32Constant;
import org.teavm.backend.wasm.model.expression.WasmIntBinary;
import org.teavm.backend.wasm.model.expression.WasmIntBinaryOperation;
import org.teavm.backend.wasm.model.expression.WasmIntType;
import org.teavm.backend.wasm.runtime.gc.WasmGCResources;
import org.teavm.classlib.ResourceSupplier;
import org.teavm.classlib.ResourceSupplierContext;
import org.teavm.model.CallLocation;
import org.teavm.model.ListableClassReaderSource;
import org.teavm.model.MethodReference;
import org.teavm.model.ValueType;

public class WasmGCResourcesGenerator
implements WasmGCCustomGenerator {
    private Properties properties;
    private ByteArrayOutputStream resources = new ByteArrayOutputStream();
    private WasmGlobal baseGlobal;

    public WasmGCResourcesGenerator(Properties properties) {
        this.properties = properties;
    }

    public void writeModule(WasmModule module) {
        if (this.resources.size() == 0) {
            return;
        }
        WasmMemorySegment segment = new WasmMemorySegment();
        if (!module.getSegments().isEmpty()) {
            WasmMemorySegment lastSegment = module.getSegments().get(module.getSegments().size() - 1);
            segment.setOffset(lastSegment.getOffset() + lastSegment.getLength());
        }
        segment.setData(this.resources.toByteArray());
        module.getSegments().add(segment);
        this.baseGlobal.setInitialValue(new WasmInt32Constant(segment.getOffset()));
    }

    @Override
    public void apply(MethodReference method, WasmFunction function, WasmGCCustomGeneratorContext context) {
        SupplierContextImpl supplierContext = new SupplierContextImpl(context.classLoader(), context.classes(), this.properties);
        LinkedHashSet<String> resourceSet = new LinkedHashSet<String>();
        for (ResourceSupplier supplier : ServiceLoader.load(ResourceSupplier.class, context.classLoader())) {
            String[] resources = supplier.supplyResources(supplierContext);
            if (resources == null) continue;
            resourceSet.addAll(Arrays.asList(resources));
        }
        ArrayList<ResourceDescriptor> descriptors = new ArrayList<ResourceDescriptor>();
        CallLocation location = new CallLocation(new MethodReference(ClassLoader.class, "getResourceAsStream", String.class, InputStream.class));
        for (String resource : resourceSet) {
            try {
                InputStream input = context.classLoader().getResourceAsStream(resource);
                try {
                    if (input == null) {
                        context.diagnostics().error(location, "Resource not found: " + resource, new Object[0]);
                        continue;
                    }
                    int start = this.resources.size();
                    input.transferTo(this.resources);
                    int end = this.resources.size();
                    descriptors.add(new ResourceDescriptor(resource, start, end));
                }
                finally {
                    if (input == null) continue;
                    input.close();
                }
            }
            catch (IOException e) {
                context.diagnostics().error(location, "Error occurred reading resource '" + resource + "'", new Object[0]);
            }
        }
        if (!descriptors.isEmpty()) {
            this.baseGlobal = new WasmGlobal(context.names().topLevel("teavm@resourcesBaseAddress"), WasmType.INT32, new WasmInt32Constant(0));
            context.module().globals.add(this.baseGlobal);
            WasmGCGenerationUtil genUtil = new WasmGCGenerationUtil(context.classInfoProvider());
            WasmFunction constructor = context.functions().forStaticMethod(new MethodReference(WasmGCResources.class, "create", String.class, Integer.TYPE, Integer.TYPE, WasmGCResources.Resource.class));
            function.getBody().add(genUtil.allocateArrayWithElements(ValueType.parse(WasmGCResources.Resource.class), () -> {
                ArrayList<WasmCall> items = new ArrayList<WasmCall>();
                for (ResourceDescriptor descriptor : descriptors) {
                    WasmGCStringConstant name = context.strings().getStringConstant(descriptor.name);
                    WasmIntBinary offset = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.ADD, new WasmGetGlobal(this.baseGlobal), new WasmInt32Constant(descriptor.address));
                    WasmInt32Constant end = new WasmInt32Constant(descriptor.end - descriptor.address);
                    items.add(new WasmCall(constructor, new WasmGetGlobal(name.global), offset, end));
                }
                return items;
            }));
        }
    }

    static class SupplierContextImpl
    implements ResourceSupplierContext {
        private ClassLoader classLoader;
        private ListableClassReaderSource classSource;
        private Properties properties;

        SupplierContextImpl(ClassLoader classLoader, ListableClassReaderSource classSource, Properties properties) {
            this.classLoader = classLoader;
            this.classSource = classSource;
            this.properties = properties;
        }

        @Override
        public ClassLoader getClassLoader() {
            return this.classLoader;
        }

        @Override
        public ListableClassReaderSource getClassSource() {
            return this.classSource;
        }

        @Override
        public Properties getProperties() {
            return this.properties;
        }
    }

    private static class ResourceDescriptor {
        String name;
        int address;
        int end;

        ResourceDescriptor(String name, int address, int end) {
            this.name = name;
            this.address = address;
            this.end = end;
        }
    }
}

