/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.generate.gc.methods;

import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import org.teavm.backend.wasm.generate.gc.classes.WasmGCClassInfo;
import org.teavm.backend.wasm.generate.gc.classes.WasmGCClassInfoProvider;
import org.teavm.backend.wasm.model.WasmArray;
import org.teavm.backend.wasm.model.WasmType;
import org.teavm.backend.wasm.model.expression.WasmArrayNewDefault;
import org.teavm.backend.wasm.model.expression.WasmArrayNewFixed;
import org.teavm.backend.wasm.model.expression.WasmExpression;
import org.teavm.backend.wasm.model.expression.WasmGetGlobal;
import org.teavm.backend.wasm.model.expression.WasmNullConstant;
import org.teavm.backend.wasm.model.expression.WasmStructNew;
import org.teavm.model.ValueType;

public class WasmGCGenerationUtil {
    private WasmGCClassInfoProvider classInfoProvider;

    public WasmGCGenerationUtil(WasmGCClassInfoProvider classInfoProvider) {
        this.classInfoProvider = classInfoProvider;
    }

    public WasmExpression allocateArray(ValueType itemType, Supplier<WasmExpression> length) {
        return this.allocateArray(itemType, (WasmArray arrayType) -> new WasmArrayNewDefault((WasmArray)arrayType, (WasmExpression)length.get()));
    }

    public WasmExpression allocateArrayWithElements(ValueType itemType, Supplier<List<? extends WasmExpression>> data) {
        return this.allocateArray(itemType, (WasmArray arrayType) -> {
            WasmArrayNewFixed expr = new WasmArrayNewFixed((WasmArray)arrayType);
            expr.getElements().addAll((Collection)data.get());
            return expr;
        });
    }

    public WasmExpression allocateArray(ValueType itemType, Function<WasmArray, WasmExpression> data) {
        WasmGCClassInfo classInfo = this.classInfoProvider.getClassInfo(ValueType.arrayOf(itemType));
        WasmType.CompositeReference wasmArrayType = (WasmType.CompositeReference)classInfo.getStructure().getFields().get(2).getUnpackedType();
        WasmArray wasmArray = (WasmArray)wasmArrayType.composite;
        WasmStructNew structNew = new WasmStructNew(classInfo.getStructure());
        structNew.getInitializers().add(new WasmGetGlobal(classInfo.getPointer()));
        structNew.getInitializers().add(new WasmNullConstant(WasmType.Reference.EQ));
        structNew.getInitializers().add(data.apply(wasmArray));
        return structNew;
    }
}

