/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.generate.gc.methods;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.teavm.backend.wasm.BaseWasmFunctionRepository;
import org.teavm.backend.wasm.WasmFunctionTypes;
import org.teavm.backend.wasm.gc.vtable.WasmGCVirtualTableProvider;
import org.teavm.backend.wasm.generate.common.methods.BaseWasmGenerationContext;
import org.teavm.backend.wasm.generate.gc.WasmGCInitializerContributor;
import org.teavm.backend.wasm.generate.gc.WasmGCNameProvider;
import org.teavm.backend.wasm.generate.gc.classes.WasmGCClassInfoProvider;
import org.teavm.backend.wasm.generate.gc.classes.WasmGCStandardClasses;
import org.teavm.backend.wasm.generate.gc.classes.WasmGCSupertypeFunctionProvider;
import org.teavm.backend.wasm.generate.gc.classes.WasmGCTypeMapper;
import org.teavm.backend.wasm.generate.gc.methods.WasmGCCustomGeneratorProvider;
import org.teavm.backend.wasm.generate.gc.methods.WasmGCIntrinsicProvider;
import org.teavm.backend.wasm.generate.gc.strings.WasmGCStringProvider;
import org.teavm.backend.wasm.model.WasmFunction;
import org.teavm.backend.wasm.model.WasmModule;
import org.teavm.backend.wasm.model.WasmTag;
import org.teavm.backend.wasm.runtime.gc.WasmGCSupport;
import org.teavm.diagnostics.Diagnostics;
import org.teavm.model.ClassHierarchy;
import org.teavm.model.ClassReader;
import org.teavm.model.ClassReaderSource;
import org.teavm.model.ElementModifier;
import org.teavm.model.ListableClassReaderSource;
import org.teavm.model.MethodReference;

public class WasmGCGenerationContext
implements BaseWasmGenerationContext {
    private WasmModule module;
    private WasmGCClassInfoProvider classInfoProvider;
    private WasmGCStandardClasses standardClasses;
    private WasmGCStringProvider strings;
    private WasmGCVirtualTableProvider virtualTables;
    private WasmGCTypeMapper typeMapper;
    private WasmFunctionTypes functionTypes;
    private ListableClassReaderSource classes;
    private ClassLoader classLoader;
    private ClassHierarchy hierarchy;
    private BaseWasmFunctionRepository functions;
    private WasmGCSupertypeFunctionProvider supertypeFunctions;
    private WasmGCCustomGeneratorProvider customGenerators;
    private WasmGCIntrinsicProvider intrinsics;
    private WasmFunction npeMethod;
    private WasmFunction aaiobeMethod;
    private WasmFunction cceMethod;
    private WasmTag exceptionTag;
    private Map<String, Set<String>> interfaceImplementors;
    private WasmGCNameProvider names;
    private boolean strict;
    private String entryPoint;
    private Consumer<WasmGCInitializerContributor> initializerContributors;
    private Diagnostics diagnostics;

    public WasmGCGenerationContext(WasmModule module, WasmGCVirtualTableProvider virtualTables, WasmGCTypeMapper typeMapper, WasmFunctionTypes functionTypes, ListableClassReaderSource classes, ClassLoader classLoader, ClassHierarchy hierarchy, BaseWasmFunctionRepository functions, WasmGCSupertypeFunctionProvider supertypeFunctions, WasmGCClassInfoProvider classInfoProvider, WasmGCStandardClasses standardClasses, WasmGCStringProvider strings, WasmGCCustomGeneratorProvider customGenerators, WasmGCIntrinsicProvider intrinsics, WasmGCNameProvider names, boolean strict, String entryPoint, Consumer<WasmGCInitializerContributor> initializerContributors, Diagnostics diagnostics) {
        this.module = module;
        this.virtualTables = virtualTables;
        this.typeMapper = typeMapper;
        this.functionTypes = functionTypes;
        this.classes = classes;
        this.classLoader = classLoader;
        this.hierarchy = hierarchy;
        this.functions = functions;
        this.supertypeFunctions = supertypeFunctions;
        this.classInfoProvider = classInfoProvider;
        this.standardClasses = standardClasses;
        this.strings = strings;
        this.customGenerators = customGenerators;
        this.intrinsics = intrinsics;
        this.names = names;
        this.strict = strict;
        this.entryPoint = entryPoint;
        this.initializerContributors = initializerContributors;
        this.diagnostics = diagnostics;
    }

    public WasmGCClassInfoProvider classInfoProvider() {
        return this.classInfoProvider;
    }

    public WasmGCNameProvider names() {
        return this.names;
    }

    public WasmGCStandardClasses standardClasses() {
        return this.standardClasses;
    }

    public WasmGCStringProvider strings() {
        return this.strings;
    }

    public String entryPoint() {
        return this.entryPoint;
    }

    public WasmGCVirtualTableProvider virtualTables() {
        return this.virtualTables;
    }

    public WasmGCTypeMapper typeMapper() {
        return this.typeMapper;
    }

    @Override
    public BaseWasmFunctionRepository functions() {
        return this.functions;
    }

    public WasmGCSupertypeFunctionProvider supertypeFunctions() {
        return this.supertypeFunctions;
    }

    @Override
    public WasmFunctionTypes functionTypes() {
        return this.functionTypes;
    }

    @Override
    public WasmTag getExceptionTag() {
        if (this.exceptionTag == null) {
            this.exceptionTag = new WasmTag(this.functionTypes.of(null, this.classInfoProvider.getClassInfo("java.lang.Throwable").getStructure().getReference()));
            this.exceptionTag.setExportName("teavm.javaException");
            this.module.tags.add(this.exceptionTag);
        }
        return this.exceptionTag;
    }

    @Override
    public ClassReaderSource classes() {
        return this.classes;
    }

    public boolean isStrict() {
        return this.strict;
    }

    public ClassLoader classLoader() {
        return this.classLoader;
    }

    public ClassHierarchy hierarchy() {
        return this.hierarchy;
    }

    public WasmFunction npeMethod() {
        if (this.npeMethod == null) {
            this.npeMethod = this.functions().forStaticMethod(new MethodReference(WasmGCSupport.class, "npe", NullPointerException.class));
        }
        return this.npeMethod;
    }

    public WasmFunction aaiobeMethod() {
        if (this.aaiobeMethod == null) {
            this.aaiobeMethod = this.functions().forStaticMethod(new MethodReference(WasmGCSupport.class, "aiiobe", ArrayIndexOutOfBoundsException.class));
        }
        return this.aaiobeMethod;
    }

    public WasmFunction cceMethod() {
        if (this.cceMethod == null) {
            this.cceMethod = this.functions().forStaticMethod(new MethodReference(WasmGCSupport.class, "cce", ClassCastException.class));
        }
        return this.cceMethod;
    }

    public WasmModule module() {
        return this.module;
    }

    public WasmGCCustomGeneratorProvider customGenerators() {
        return this.customGenerators;
    }

    public WasmGCIntrinsicProvider intrinsics() {
        return this.intrinsics;
    }

    public Diagnostics diagnostics() {
        return this.diagnostics;
    }

    public Collection<String> getInterfaceImplementors(String className) {
        Set<String> result;
        if (this.interfaceImplementors == null) {
            this.fillInterfaceImplementors();
        }
        return (result = this.interfaceImplementors.get(className)) != null ? result : List.of();
    }

    private void fillInterfaceImplementors() {
        this.interfaceImplementors = new HashMap<String, Set<String>>();
        for (String className : this.classes.getClassNames()) {
            ClassReader cls = this.classes.get(className);
            if (cls.hasModifier(ElementModifier.INTERFACE)) continue;
            for (String itf : cls.getInterfaces()) {
                this.addInterfaceImplementor(className, itf);
            }
        }
    }

    private void addInterfaceImplementor(String implementorName, String interfaceName) {
        ClassReader itf;
        Set implementorsByKey = this.interfaceImplementors.computeIfAbsent(interfaceName, k -> new LinkedHashSet());
        if (implementorsByKey.add(implementorName) && (itf = this.classes.get(implementorName)) != null) {
            for (String parentItf : itf.getInterfaces()) {
                this.addInterfaceImplementor(implementorName, parentItf);
            }
        }
    }

    public void addToInitializer(final Consumer<WasmFunction> initializer) {
        this.initializerContributors.accept(new WasmGCInitializerContributor(){

            @Override
            public void contributeToInitializerDefinitions(WasmFunction function) {
            }

            @Override
            public void contributeToInitializer(WasmFunction function) {
                initializer.accept(function);
            }
        });
    }
}

