/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.generate.gc.classes;

import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import org.teavm.backend.wasm.WasmFunctionTypes;
import org.teavm.backend.wasm.generate.gc.WasmGCNameProvider;
import org.teavm.backend.wasm.generate.gc.classes.WasmGCClassGenerator;
import org.teavm.backend.wasm.generate.gc.classes.WasmGCSupertypeFunctionProvider;
import org.teavm.backend.wasm.model.WasmFunction;
import org.teavm.backend.wasm.model.WasmFunctionType;
import org.teavm.backend.wasm.model.WasmGlobal;
import org.teavm.backend.wasm.model.WasmLocal;
import org.teavm.backend.wasm.model.WasmModule;
import org.teavm.backend.wasm.model.WasmType;
import org.teavm.backend.wasm.model.expression.WasmCall;
import org.teavm.backend.wasm.model.expression.WasmConditional;
import org.teavm.backend.wasm.model.expression.WasmExpression;
import org.teavm.backend.wasm.model.expression.WasmGetGlobal;
import org.teavm.backend.wasm.model.expression.WasmGetLocal;
import org.teavm.backend.wasm.model.expression.WasmInt32Constant;
import org.teavm.backend.wasm.model.expression.WasmIntBinary;
import org.teavm.backend.wasm.model.expression.WasmIntBinaryOperation;
import org.teavm.backend.wasm.model.expression.WasmIntType;
import org.teavm.backend.wasm.model.expression.WasmIsNull;
import org.teavm.backend.wasm.model.expression.WasmReferencesEqual;
import org.teavm.backend.wasm.model.expression.WasmReturn;
import org.teavm.backend.wasm.model.expression.WasmSetLocal;
import org.teavm.backend.wasm.model.expression.WasmStructGet;
import org.teavm.model.ValueType;
import org.teavm.model.classes.TagRegistry;

public class WasmGCSupertypeFunctionGenerator
implements WasmGCSupertypeFunctionProvider {
    private Map<ValueType, WasmFunction> functions = new HashMap<ValueType, WasmFunction>();
    private WasmModule module;
    private WasmGCClassGenerator classGenerator;
    private WasmGCNameProvider nameProvider;
    private TagRegistry tagRegistry;
    private WasmFunctionTypes functionTypes;
    private WasmFunctionType functionType;
    private Queue<Runnable> queue;

    WasmGCSupertypeFunctionGenerator(WasmModule module, WasmGCClassGenerator classGenerator, WasmGCNameProvider nameProvider, TagRegistry tagRegistry, WasmFunctionTypes functionTypes, Queue<Runnable> queue) {
        this.module = module;
        this.classGenerator = classGenerator;
        this.nameProvider = nameProvider;
        this.tagRegistry = tagRegistry;
        this.functionTypes = functionTypes;
        this.queue = queue;
    }

    @Override
    public WasmFunction getIsSupertypeFunction(ValueType type) {
        WasmFunction result = this.functions.get(type);
        if (result == null) {
            result = this.generateIsSupertypeFunction(type);
            this.functions.put(type, result);
        }
        return result;
    }

    private WasmFunction generateIsSupertypeFunction(ValueType type) {
        WasmFunction function = new WasmFunction(this.getFunctionType());
        function.setName(this.nameProvider.topLevel(this.nameProvider.suggestForType(type) + "@isSupertypes"));
        WasmLocal subtypeVar = new WasmLocal(this.classGenerator.standardClasses.classClass().getType(), "subtype");
        function.add(subtypeVar);
        this.module.functions.add(function);
        this.queue.add(() -> {
            if (type instanceof ValueType.Object) {
                String className = ((ValueType.Object)type).getClassName();
                this.generateIsClass(subtypeVar, className, function);
            } else if (type instanceof ValueType.Array) {
                ValueType itemType = ((ValueType.Array)type).getItemType();
                this.generateIsArray(subtypeVar, itemType, function.getBody());
            } else {
                WasmGlobal expected = this.classGenerator.getClassInfo((ValueType)type).pointer;
                WasmReferencesEqual condition = new WasmReferencesEqual(new WasmGetLocal(subtypeVar), new WasmGetGlobal(expected));
                function.getBody().add(condition);
            }
        });
        return function;
    }

    private void generateIsClass(WasmLocal subtypeVar, String className, WasmFunction function) {
        List<WasmExpression> body = function.getBody();
        List<TagRegistry.Range> ranges = this.tagRegistry.getRanges(className);
        if (ranges.isEmpty()) {
            body.add(new WasmInt32Constant(0));
            return;
        }
        int tagOffset = this.classGenerator.getClassTagOffset();
        WasmLocal tagVar = new WasmLocal(WasmType.INT32, "tag");
        function.add(tagVar);
        WasmExpression tagExpression = this.getClassField(new WasmGetLocal(subtypeVar), tagOffset);
        body.add(new WasmSetLocal(tagVar, tagExpression));
        ranges.sort(Comparator.comparingInt(range -> range.lower));
        int lower = ranges.get((int)0).lower;
        int upper = ranges.get((int)(ranges.size() - 1)).upper;
        WasmIntBinary lowerCondition = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.LT_SIGNED, new WasmGetLocal(tagVar), new WasmInt32Constant(lower));
        WasmConditional testLower = new WasmConditional(lowerCondition);
        testLower.getThenBlock().getBody().add(new WasmReturn(new WasmInt32Constant(0)));
        body.add(testLower);
        WasmIntBinary upperCondition = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.GE_SIGNED, new WasmGetLocal(tagVar), new WasmInt32Constant(upper));
        WasmConditional testUpper = new WasmConditional(upperCondition);
        testUpper.getThenBlock().getBody().add(new WasmReturn(new WasmInt32Constant(0)));
        body.add(testUpper);
        for (int i = 1; i < ranges.size(); ++i) {
            int lowerHole = ranges.get((int)(i - 1)).upper;
            int upperHole = ranges.get((int)i).lower;
            lowerCondition = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.GE_SIGNED, new WasmGetLocal(tagVar), new WasmInt32Constant(lowerHole));
            testLower = new WasmConditional(lowerCondition);
            body.add(testLower);
            upperCondition = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.LT_SIGNED, new WasmGetLocal(tagVar), new WasmInt32Constant(upperHole));
            testUpper = new WasmConditional(upperCondition);
            testUpper.getThenBlock().getBody().add(new WasmReturn(new WasmInt32Constant(0)));
            testLower.getThenBlock().getBody().add(testUpper);
        }
        body.add(new WasmInt32Constant(1));
    }

    private void generateIsArray(WasmLocal subtypeVar, ValueType itemType, List<WasmExpression> body) {
        int itemOffset = this.classGenerator.getClassArrayItemOffset();
        WasmExpression itemExpression = this.getClassField(new WasmGetLocal(subtypeVar), itemOffset);
        body.add(new WasmSetLocal(subtypeVar, itemExpression));
        WasmConditional itemTest = new WasmConditional(new WasmIsNull(new WasmGetLocal(subtypeVar)));
        itemTest.setType(WasmType.INT32);
        itemTest.getThenBlock().getBody().add(new WasmInt32Constant(0));
        WasmCall delegateToItem = new WasmCall(this.getIsSupertypeFunction(itemType));
        delegateToItem.getArguments().add(new WasmGetLocal(subtypeVar));
        itemTest.getElseBlock().getBody().add(delegateToItem);
        body.add(itemTest);
    }

    public WasmFunctionType getFunctionType() {
        if (this.functionType == null) {
            this.functionType = this.functionTypes.of(WasmType.INT32, this.classGenerator.standardClasses.classClass().getType());
        }
        return this.functionType;
    }

    private WasmExpression getClassField(WasmExpression instance, int fieldIndex) {
        return new WasmStructGet(this.classGenerator.standardClasses.classClass().getStructure(), instance, fieldIndex);
    }
}

