/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.generate.gc.classes;

import java.util.Arrays;
import java.util.List;
import java.util.Queue;
import org.teavm.backend.wasm.WasmFunctionTypes;
import org.teavm.backend.wasm.generate.gc.WasmGCNameProvider;
import org.teavm.backend.wasm.generate.gc.classes.WasmGCClassInfo;
import org.teavm.backend.wasm.generate.gc.classes.WasmGCClassInfoProvider;
import org.teavm.backend.wasm.generate.gc.methods.WasmGCGenerationUtil;
import org.teavm.backend.wasm.model.WasmArray;
import org.teavm.backend.wasm.model.WasmField;
import org.teavm.backend.wasm.model.WasmFunction;
import org.teavm.backend.wasm.model.WasmFunctionType;
import org.teavm.backend.wasm.model.WasmLocal;
import org.teavm.backend.wasm.model.WasmModule;
import org.teavm.backend.wasm.model.WasmType;
import org.teavm.backend.wasm.model.expression.WasmArraySet;
import org.teavm.backend.wasm.model.expression.WasmBlock;
import org.teavm.backend.wasm.model.expression.WasmBranch;
import org.teavm.backend.wasm.model.expression.WasmCall;
import org.teavm.backend.wasm.model.expression.WasmExpression;
import org.teavm.backend.wasm.model.expression.WasmGetLocal;
import org.teavm.backend.wasm.model.expression.WasmInt32Constant;
import org.teavm.backend.wasm.model.expression.WasmIntBinary;
import org.teavm.backend.wasm.model.expression.WasmIntBinaryOperation;
import org.teavm.backend.wasm.model.expression.WasmIntType;
import org.teavm.backend.wasm.model.expression.WasmIntUnary;
import org.teavm.backend.wasm.model.expression.WasmIntUnaryOperation;
import org.teavm.backend.wasm.model.expression.WasmSetLocal;
import org.teavm.backend.wasm.model.expression.WasmStructGet;
import org.teavm.model.ValueType;

class WasmGCNewArrayFunctionGenerator {
    private WasmModule module;
    private WasmFunctionTypes functionTypes;
    private WasmGCClassInfoProvider classInfoProvider;
    private WasmFunctionType newArrayFunctionType;
    private WasmGCNameProvider names;
    private Queue<Runnable> queue;

    WasmGCNewArrayFunctionGenerator(WasmModule module, WasmFunctionTypes functionTypes, WasmGCClassInfoProvider classInfoProvider, WasmGCNameProvider names, Queue<Runnable> queue) {
        this.module = module;
        this.functionTypes = functionTypes;
        this.classInfoProvider = classInfoProvider;
        this.names = names;
        this.queue = queue;
    }

    WasmFunction generateNewArrayFunction(ValueType itemType) {
        WasmGCClassInfo classInfo = this.classInfoProvider.getClassInfo(ValueType.arrayOf(itemType));
        WasmFunctionType functionType = new WasmFunctionType(null, classInfo.getType(), List.of(WasmType.INT32));
        this.module.types.add(functionType);
        functionType.setFinal(true);
        functionType.getSupertypes().add(this.getNewArrayFunctionType());
        WasmFunction function = new WasmFunction(functionType);
        function.setName(this.names.topLevel("Array<" + this.names.suggestForType(itemType) + ">@new"));
        this.module.functions.add(function);
        this.queue.add(() -> {
            WasmLocal sizeLocal = new WasmLocal(WasmType.INT32, "length");
            function.add(sizeLocal);
            WasmGCGenerationUtil genUtil = new WasmGCGenerationUtil(this.classInfoProvider);
            WasmLocal targetVar = new WasmLocal(classInfo.getType(), "result");
            function.add(targetVar);
            function.getBody().add(genUtil.allocateArray(itemType, () -> new WasmGetLocal(sizeLocal)));
        });
        return function;
    }

    WasmFunction generateNewMultiArrayFunction(ValueType itemType, int depth) {
        ValueType arrayType = itemType;
        for (int i = 0; i < depth; ++i) {
            arrayType = ValueType.arrayOf(arrayType);
        }
        WasmGCClassInfo classInfo = this.classInfoProvider.getClassInfo(arrayType);
        Object[] parameterTypes = new WasmType[depth];
        Arrays.fill(parameterTypes, WasmType.INT32);
        WasmFunctionType functionType = this.functionTypes.of(classInfo.getType(), (WasmType[])parameterTypes);
        WasmFunction function = new WasmFunction(functionType);
        function.setName(this.names.topLevel(this.names.suggestForType(arrayType) + "@new:" + depth));
        this.module.functions.add(function);
        ValueType finalArrayType = arrayType;
        this.queue.add(() -> {
            WasmLocal[] dimensionLocals = new WasmLocal[depth];
            for (int i = 0; i < depth; ++i) {
                WasmLocal dimensionLocal;
                dimensionLocals[i] = dimensionLocal = new WasmLocal(WasmType.INT32, "dim" + i);
                function.add(dimensionLocal);
            }
            WasmLocal indexLocal = new WasmLocal(WasmType.INT32, "index");
            function.add(indexLocal);
            WasmField dataField = classInfo.getStructure().getFields().get(2);
            WasmType.CompositeReference dataFieldTypeRef = (WasmType.CompositeReference)dataField.getUnpackedType();
            WasmArray dataArray = (WasmArray)dataFieldTypeRef.composite;
            WasmLocal dataLocal = new WasmLocal(dataArray.getReference(), "data");
            function.add(dataLocal);
            WasmLocal resultVar = new WasmLocal(classInfo.getType(), "result");
            function.add(resultVar);
            ValueType arrayItemType = ((ValueType.Array)finalArrayType).getItemType();
            WasmFunction allocFunction = this.classInfoProvider.getArrayConstructor(arrayItemType, 1);
            function.getBody().add(new WasmSetLocal(resultVar, new WasmCall(allocFunction, new WasmGetLocal(dimensionLocals[0]))));
            function.getBody().add(new WasmSetLocal(dataLocal, new WasmStructGet(classInfo.getStructure(), new WasmGetLocal(resultVar), 2)));
            WasmBlock zeroGuard = new WasmBlock(false);
            function.getBody().add(zeroGuard);
            zeroGuard.getBody().add(new WasmBranch(new WasmIntUnary(WasmIntType.INT32, WasmIntUnaryOperation.EQZ, new WasmGetLocal(dimensionLocals[0])), zeroGuard));
            WasmBlock loop = new WasmBlock(true);
            zeroGuard.getBody().add(loop);
            WasmFunction itemFunction = this.classInfoProvider.getArrayConstructor(itemType, depth - 1);
            WasmExpression[] args = new WasmExpression[depth - 1];
            for (int i = 0; i < args.length; ++i) {
                args[i] = new WasmGetLocal(dimensionLocals[i + 1]);
            }
            loop.getBody().add(new WasmArraySet(dataArray, new WasmGetLocal(dataLocal), new WasmGetLocal(indexLocal), new WasmCall(itemFunction, args)));
            WasmIntBinary incrementIndex = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.ADD, new WasmGetLocal(indexLocal), new WasmInt32Constant(1));
            loop.getBody().add(new WasmSetLocal(indexLocal, incrementIndex));
            WasmIntBinary continueCondition = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.LT_UNSIGNED, new WasmGetLocal(indexLocal), new WasmGetLocal(dimensionLocals[0]));
            loop.getBody().add(new WasmBranch(continueCondition, loop));
            function.getBody().add(new WasmGetLocal(resultVar));
        });
        return function;
    }

    WasmFunctionType getNewArrayFunctionType() {
        if (this.newArrayFunctionType == null) {
            this.newArrayFunctionType = this.functionTypes.of(this.classInfoProvider.getClassInfo("java.lang.Object").getType(), WasmType.INT32);
            this.newArrayFunctionType.setFinal(false);
        }
        return this.newArrayFunctionType;
    }
}

