/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.generate.gc.classes;

import java.util.List;
import java.util.function.Consumer;
import org.teavm.backend.wasm.model.WasmArray;
import org.teavm.backend.wasm.model.WasmField;
import org.teavm.backend.wasm.model.WasmFunction;
import org.teavm.backend.wasm.model.WasmGlobal;
import org.teavm.backend.wasm.model.WasmStructure;
import org.teavm.backend.wasm.model.WasmType;
import org.teavm.backend.wasm.model.expression.WasmExpression;
import org.teavm.model.ValueType;

public class WasmGCClassInfo {
    private ValueType valueType;
    WasmStructure structure;
    WasmStructure virtualTableStructure;
    WasmGlobal pointer;
    WasmGlobal initializerPointer;
    Consumer<List<WasmExpression>> initializer;
    List<WasmFunction> newArrayFunctions;
    WasmFunction initArrayFunction;
    WasmFunction supertypeFunction;

    WasmGCClassInfo(ValueType valueType) {
        this.valueType = valueType;
    }

    public ValueType getValueType() {
        return this.valueType;
    }

    public WasmStructure getStructure() {
        return this.structure;
    }

    public WasmArray getArray() {
        WasmField field = this.structure.getFields().get(2);
        WasmType.CompositeReference type = (WasmType.CompositeReference)field.getUnpackedType();
        return (WasmArray)type.composite;
    }

    public WasmStructure getVirtualTableStructure() {
        return this.virtualTableStructure;
    }

    public WasmType.CompositeReference getType() {
        return this.getStructure().getReference();
    }

    public WasmGlobal getPointer() {
        return this.pointer;
    }

    public WasmGlobal getInitializerPointer() {
        return this.initializerPointer;
    }
}

