/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.generate.gc.classes;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.ServiceLoader;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.teavm.backend.wasm.BaseWasmFunctionRepository;
import org.teavm.backend.wasm.WasmFunctionTypes;
import org.teavm.backend.wasm.gc.vtable.WasmGCVirtualTable;
import org.teavm.backend.wasm.gc.vtable.WasmGCVirtualTableEntry;
import org.teavm.backend.wasm.gc.vtable.WasmGCVirtualTableProvider;
import org.teavm.backend.wasm.generate.gc.WasmGCInitializerContributor;
import org.teavm.backend.wasm.generate.gc.WasmGCNameProvider;
import org.teavm.backend.wasm.generate.gc.classes.WasmGCClassInfo;
import org.teavm.backend.wasm.generate.gc.classes.WasmGCClassInfoProvider;
import org.teavm.backend.wasm.generate.gc.classes.WasmGCCustomTypeMapperFactory;
import org.teavm.backend.wasm.generate.gc.classes.WasmGCCustomTypeMapperFactoryContext;
import org.teavm.backend.wasm.generate.gc.classes.WasmGCNewArrayFunctionGenerator;
import org.teavm.backend.wasm.generate.gc.classes.WasmGCStandardClasses;
import org.teavm.backend.wasm.generate.gc.classes.WasmGCSupertypeFunctionGenerator;
import org.teavm.backend.wasm.generate.gc.classes.WasmGCSupertypeFunctionProvider;
import org.teavm.backend.wasm.generate.gc.classes.WasmGCTypeMapper;
import org.teavm.backend.wasm.generate.gc.methods.WasmGCGenerationUtil;
import org.teavm.backend.wasm.generate.gc.strings.WasmGCStringConstant;
import org.teavm.backend.wasm.generate.gc.strings.WasmGCStringPool;
import org.teavm.backend.wasm.model.WasmArray;
import org.teavm.backend.wasm.model.WasmField;
import org.teavm.backend.wasm.model.WasmFunction;
import org.teavm.backend.wasm.model.WasmFunctionType;
import org.teavm.backend.wasm.model.WasmGlobal;
import org.teavm.backend.wasm.model.WasmLocal;
import org.teavm.backend.wasm.model.WasmModule;
import org.teavm.backend.wasm.model.WasmStorageType;
import org.teavm.backend.wasm.model.WasmStructure;
import org.teavm.backend.wasm.model.WasmType;
import org.teavm.backend.wasm.model.expression.WasmArrayCopy;
import org.teavm.backend.wasm.model.expression.WasmArrayGet;
import org.teavm.backend.wasm.model.expression.WasmArrayLength;
import org.teavm.backend.wasm.model.expression.WasmArrayNewDefault;
import org.teavm.backend.wasm.model.expression.WasmCall;
import org.teavm.backend.wasm.model.expression.WasmCallReference;
import org.teavm.backend.wasm.model.expression.WasmCast;
import org.teavm.backend.wasm.model.expression.WasmExpression;
import org.teavm.backend.wasm.model.expression.WasmFloat32Constant;
import org.teavm.backend.wasm.model.expression.WasmFloat64Constant;
import org.teavm.backend.wasm.model.expression.WasmFunctionReference;
import org.teavm.backend.wasm.model.expression.WasmGetGlobal;
import org.teavm.backend.wasm.model.expression.WasmGetLocal;
import org.teavm.backend.wasm.model.expression.WasmInt32Constant;
import org.teavm.backend.wasm.model.expression.WasmInt64Constant;
import org.teavm.backend.wasm.model.expression.WasmIntBinary;
import org.teavm.backend.wasm.model.expression.WasmIntBinaryOperation;
import org.teavm.backend.wasm.model.expression.WasmIntType;
import org.teavm.backend.wasm.model.expression.WasmNullConstant;
import org.teavm.backend.wasm.model.expression.WasmSetGlobal;
import org.teavm.backend.wasm.model.expression.WasmSetLocal;
import org.teavm.backend.wasm.model.expression.WasmSignedType;
import org.teavm.backend.wasm.model.expression.WasmStructGet;
import org.teavm.backend.wasm.model.expression.WasmStructNew;
import org.teavm.backend.wasm.model.expression.WasmStructNewDefault;
import org.teavm.backend.wasm.model.expression.WasmStructSet;
import org.teavm.backend.wasm.runtime.StringInternPool;
import org.teavm.backend.wasm.runtime.gc.WasmGCSupport;
import org.teavm.dependency.DependencyInfo;
import org.teavm.dependency.MethodDependencyInfo;
import org.teavm.hppc.ObjectIntHashMap;
import org.teavm.hppc.ObjectIntMap;
import org.teavm.model.ClassHierarchy;
import org.teavm.model.ClassReader;
import org.teavm.model.ClassReaderSource;
import org.teavm.model.ElementModifier;
import org.teavm.model.FieldReader;
import org.teavm.model.FieldReference;
import org.teavm.model.MethodDescriptor;
import org.teavm.model.MethodReference;
import org.teavm.model.PrimitiveType;
import org.teavm.model.ValueType;
import org.teavm.model.analysis.ClassInitializerInfo;
import org.teavm.model.analysis.ClassMetadataRequirements;
import org.teavm.model.classes.TagRegistry;
import org.teavm.model.util.ReflectionUtil;

public class WasmGCClassGenerator
implements WasmGCClassInfoProvider,
WasmGCInitializerContributor {
    private static final MethodDescriptor CLINIT_METHOD_DESC = new MethodDescriptor("<clinit>", ValueType.VOID);
    private static final MethodDescriptor CLONE_METHOD_DESC = new MethodDescriptor("clone", ValueType.object("java.lang.Object"));
    private static final MethodDescriptor GET_CLASS_METHOD = new MethodDescriptor("getClass", ValueType.parse(Class.class));
    private static final FieldReference FAKE_CLASS_FIELD = new FieldReference(Object.class.getName(), "class");
    private static final FieldReference FAKE_MONITOR_FIELD = new FieldReference(Object.class.getName(), "monitor");
    private static final ValueType OBJECT_TYPE = ValueType.parse(Object.class);
    private final WasmModule module;
    private ClassReaderSource classSource;
    private ClassReaderSource originalClassSource;
    private ClassHierarchy hierarchy;
    private WasmFunctionTypes functionTypes;
    private TagRegistry tagRegistry;
    private ClassMetadataRequirements metadataRequirements;
    private WasmGCVirtualTableProvider virtualTables;
    private BaseWasmFunctionRepository functionProvider;
    private Map<ValueType, WasmGCClassInfo> classInfoMap = new LinkedHashMap<ValueType, WasmGCClassInfo>();
    private Queue<Runnable> queue = new ArrayDeque<Runnable>();
    private ObjectIntMap<FieldReference> fieldIndexes = new ObjectIntHashMap();
    private Map<FieldReference, WasmGlobal> staticFieldLocations = new HashMap<FieldReference, WasmGlobal>();
    private List<Consumer<WasmFunction>> staticFieldInitializers = new ArrayList<Consumer<WasmFunction>>();
    private ClassInitializerInfo classInitializerInfo;
    public final WasmGCStringPool strings;
    public final WasmGCStandardClasses standardClasses;
    public final WasmGCTypeMapper typeMapper;
    private final WasmGCNameProvider names;
    private List<WasmExpression> initializerFunctionStatements = new ArrayList<WasmExpression>();
    private WasmFunction createPrimitiveClassFunction;
    private WasmFunction createArrayClassFunction;
    private WasmFunction fillRegularClassFunction;
    private final WasmGCSupertypeFunctionGenerator supertypeGenerator;
    private final WasmGCNewArrayFunctionGenerator newArrayGenerator;
    private String arrayDataFieldName;
    private int classTagOffset;
    private int classFlagsOffset = -1;
    private int classNameOffset;
    private int classSimpleNameOffset;
    private int classCanonicalNameOffset;
    private int classParentOffset = -1;
    private int classArrayOffset;
    private int classArrayItemOffset;
    private int classNewArrayOffset;
    private int classSupertypeFunctionOffset;
    private int classEnclosingClassOffset;
    private int classDeclaringClassOffset;
    private int virtualTableFieldOffset;
    private int enumConstantsFunctionOffset;
    private int arrayLengthOffset = -1;
    private int arrayGetOffset = -1;
    private int arrayCopyOffset = -1;
    private int cloneOffset = -1;
    private int servicesOffset = -1;
    private int throwableNativeOffset = -1;
    private WasmStructure arrayVirtualTableStruct;
    private WasmFunction arrayGetObjectFunction;
    private WasmFunction arrayLengthObjectFunction;
    private WasmFunction arrayCopyObjectFunction;
    private WasmFunctionType arrayGetType;
    private WasmFunctionType arrayLengthType;
    private WasmFunctionType arrayCopyType;
    private List<WasmStructure> nonInitializedStructures = new ArrayList<WasmStructure>();
    private WasmArray objectArrayType;
    private boolean hasLoadServices;

    public WasmGCClassGenerator(WasmModule module, ClassReaderSource classSource, ClassReaderSource originalClassSource, ClassHierarchy hierarchy, DependencyInfo dependencyInfo, WasmFunctionTypes functionTypes, TagRegistry tagRegistry, ClassMetadataRequirements metadataRequirements, WasmGCVirtualTableProvider virtualTables, BaseWasmFunctionRepository functionProvider, WasmGCNameProvider names, ClassInitializerInfo classInitializerInfo, List<WasmGCCustomTypeMapperFactory> customTypeMapperFactories) {
        this.module = module;
        this.classSource = classSource;
        this.originalClassSource = originalClassSource;
        this.hierarchy = hierarchy;
        this.functionTypes = functionTypes;
        this.tagRegistry = tagRegistry;
        this.metadataRequirements = metadataRequirements;
        this.virtualTables = virtualTables;
        this.functionProvider = functionProvider;
        this.names = names;
        this.classInitializerInfo = classInitializerInfo;
        this.standardClasses = new WasmGCStandardClasses(this);
        this.strings = new WasmGCStringPool(this.standardClasses, module, functionProvider, names, functionTypes, dependencyInfo);
        this.supertypeGenerator = new WasmGCSupertypeFunctionGenerator(module, this, names, tagRegistry, functionTypes, this.queue);
        this.newArrayGenerator = new WasmGCNewArrayFunctionGenerator(module, functionTypes, this, names, this.queue);
        this.typeMapper = new WasmGCTypeMapper(classSource, this, functionTypes, module);
        WasmGCCustomTypeMapperFactoryContext customTypeMapperFactoryContext = this.customTypeMapperFactoryContext();
        this.typeMapper.setCustomTypeMappers(customTypeMapperFactories.stream().map(factory -> factory.createTypeMapper(customTypeMapperFactoryContext)).collect(Collectors.toList()));
        MethodDependencyInfo loadServicesMethod = dependencyInfo.getMethod(new MethodReference(ServiceLoader.class, "loadServices", Class.class, Object[].class));
        if (loadServicesMethod != null && loadServicesMethod.isUsed()) {
            this.hasLoadServices = true;
        }
    }

    private WasmGCCustomTypeMapperFactoryContext customTypeMapperFactoryContext() {
        return new WasmGCCustomTypeMapperFactoryContext(){

            @Override
            public ClassReaderSource originalClasses() {
                return WasmGCClassGenerator.this.originalClassSource;
            }

            @Override
            public ClassReaderSource classes() {
                return WasmGCClassGenerator.this.classSource;
            }

            @Override
            public WasmModule module() {
                return WasmGCClassGenerator.this.module;
            }

            @Override
            public WasmGCClassInfoProvider classInfoProvider() {
                return WasmGCClassGenerator.this;
            }

            @Override
            public WasmGCNameProvider names() {
                return WasmGCClassGenerator.this.names;
            }

            @Override
            public WasmGCTypeMapper typeMapper() {
                return WasmGCClassGenerator.this.typeMapper;
            }
        };
    }

    public WasmGCSupertypeFunctionProvider getSupertypeProvider() {
        return this.supertypeGenerator;
    }

    public boolean process() {
        if (this.queue.isEmpty()) {
            return false;
        }
        while (!this.queue.isEmpty()) {
            Runnable action = this.queue.remove();
            action.run();
            this.initStructures();
        }
        return true;
    }

    private void initStructures() {
        if (this.nonInitializedStructures.isEmpty()) {
            return;
        }
        List<WasmStructure> copy = List.copyOf(this.nonInitializedStructures);
        this.nonInitializedStructures.clear();
        for (WasmStructure structure : copy) {
            structure.init();
        }
    }

    @Override
    public void contributeToInitializerDefinitions(WasmFunction function) {
    }

    @Override
    public void contributeToInitializer(WasmFunction function) {
        function.getBody().addAll(this.initializerFunctionStatements);
        this.initializerFunctionStatements.clear();
        for (WasmGCClassInfo wasmGCClassInfo : this.classInfoMap.values()) {
            if (wasmGCClassInfo.supertypeFunction != null) {
                function.getBody().add(this.setClassField(wasmGCClassInfo, this.classSupertypeFunctionOffset, new WasmFunctionReference(wasmGCClassInfo.supertypeFunction)));
            }
            if (wasmGCClassInfo.initArrayFunction == null) continue;
            function.getBody().add(this.setClassField(wasmGCClassInfo, this.classNewArrayOffset, new WasmFunctionReference(wasmGCClassInfo.initArrayFunction)));
        }
        for (Consumer consumer : this.staticFieldInitializers) {
            consumer.accept(function);
        }
    }

    @Override
    public WasmGCClassInfo getClassInfo(ValueType type) {
        WasmGCClassInfo classInfo = this.classInfoMap.get(type);
        if (classInfo == null) {
            WasmGCClassInfo finalClassInfo = classInfo = new WasmGCClassInfo(type);
            this.queue.add(() -> {
                finalClassInfo.initializer.accept(this.initializerFunctionStatements);
                finalClassInfo.initializer = null;
            });
            this.classInfoMap.put(type, classInfo);
            WasmGCVirtualTable virtualTable = null;
            if (!(type instanceof ValueType.Primitive)) {
                ClassReader classReader;
                String name = type instanceof ValueType.Object ? ((ValueType.Object)type).getClassName() : null;
                boolean isInterface = false;
                ClassReader classReader2 = classReader = name != null ? this.classSource.get(name) : null;
                if (classReader != null && classReader.hasModifier(ElementModifier.INTERFACE)) {
                    isInterface = true;
                    classInfo.structure = this.standardClasses.objectClass().structure;
                } else {
                    ValueType itemType;
                    if (type instanceof ValueType.Array && !((itemType = ((ValueType.Array)type).getItemType()) instanceof ValueType.Primitive) && !itemType.equals(OBJECT_TYPE)) {
                        classInfo.structure = this.getClassInfo((ValueType)ValueType.arrayOf((ValueType)WasmGCClassGenerator.OBJECT_TYPE)).structure;
                    }
                    if (classInfo.structure == null) {
                        String structName = this.names.topLevel(this.names.suggestForType(type));
                        classInfo.structure = new WasmStructure(structName, fields -> this.fillFields(finalClassInfo, (List<WasmField>)fields, type));
                        classInfo.structure.setNominal(true);
                        this.module.types.add(classInfo.structure);
                        this.nonInitializedStructures.add(classInfo.structure);
                    }
                }
                if (name != null) {
                    if (!isInterface) {
                        virtualTable = this.virtualTables.lookup(name);
                    }
                    if (classReader != null && classReader.getParent() != null && !isInterface) {
                        classInfo.structure.setSupertype(this.getClassInfo((String)classReader.getParent()).structure);
                    }
                } else {
                    virtualTable = this.virtualTables.lookup("java.lang.Object");
                    classInfo.structure.setSupertype(this.standardClasses.objectClass().structure);
                }
            }
            String pointerName = this.names.topLevel(this.names.suggestForType(type) + "@class");
            if (virtualTable != null) {
                if (type instanceof ValueType.Object) {
                    if (virtualTable.isUsed()) {
                        this.initRegularClassStructure(classInfo, ((ValueType.Object)type).getClassName());
                    } else {
                        WasmGCVirtualTable usedVt = virtualTable.getFirstUsed();
                        classInfo.virtualTableStructure = usedVt != null ? this.getClassInfo((String)usedVt.getClassName()).virtualTableStructure : this.standardClasses.classClass().getStructure();
                    }
                } else {
                    classInfo.virtualTableStructure = this.getArrayVirtualTableStructure();
                }
            } else {
                classInfo.virtualTableStructure = this.standardClasses.classClass().getStructure();
            }
            WasmStructure classStructure = classInfo.virtualTableStructure;
            classInfo.pointer = new WasmGlobal(pointerName, classStructure.getNonNullReference(), new WasmStructNewDefault(classStructure));
            classInfo.pointer.setImmutable(true);
            this.module.globals.add(classInfo.pointer);
            if (type instanceof ValueType.Primitive) {
                this.initPrimitiveClass(classInfo, (ValueType.Primitive)type);
            } else if (type instanceof ValueType.Void) {
                this.initVoidClass(classInfo);
            } else if (type instanceof ValueType.Array) {
                this.initArrayClass(classInfo, (ValueType.Array)type);
            } else if (type instanceof ValueType.Object) {
                this.initRegularClass(classInfo, virtualTable, classStructure, ((ValueType.Object)type).getClassName());
            }
            ClassMetadataRequirements.Info req = this.metadataRequirements.getInfo(type);
            if (req != null) {
                if (req.newArray()) {
                    classInfo.initArrayFunction = this.getArrayConstructor(classInfo.getValueType(), 1);
                    classInfo.initArrayFunction.setReferenced(true);
                }
                if (req.isAssignable()) {
                    WasmFunction supertypeFunction = this.supertypeGenerator.getIsSupertypeFunction(classInfo.getValueType());
                    supertypeFunction.setReferenced(true);
                    classInfo.supertypeFunction = supertypeFunction;
                }
            }
        }
        return classInfo;
    }

    @Override
    public WasmFunction getArrayConstructor(ValueType type, int depth) {
        WasmFunction function;
        WasmGCClassInfo arrayInfo = this.getClassInfo(type);
        if (arrayInfo.newArrayFunctions == null) {
            arrayInfo.newArrayFunctions = new ArrayList<WasmFunction>();
        }
        if (depth >= arrayInfo.newArrayFunctions.size()) {
            arrayInfo.newArrayFunctions.addAll(Collections.nCopies(depth - arrayInfo.newArrayFunctions.size() + 1, null));
        }
        if ((function = arrayInfo.newArrayFunctions.get(depth)) == null) {
            function = depth == 1 ? this.newArrayGenerator.generateNewArrayFunction(type) : this.newArrayGenerator.generateNewMultiArrayFunction(type, depth);
            arrayInfo.newArrayFunctions.set(depth, function);
        }
        return function;
    }

    public int getClassTagOffset() {
        this.standardClasses.classClass().getStructure().init();
        return this.classTagOffset;
    }

    @Override
    public int getClassArrayItemOffset() {
        this.standardClasses.classClass().getStructure().init();
        return this.classArrayItemOffset;
    }

    @Override
    public int getClassFlagsOffset() {
        this.standardClasses.classClass().getStructure().init();
        return this.classFlagsOffset;
    }

    @Override
    public int getClassSupertypeFunctionOffset() {
        this.standardClasses.classClass().getStructure().init();
        return this.classSupertypeFunctionOffset;
    }

    @Override
    public int getClassEnclosingClassOffset() {
        this.standardClasses.classClass().getStructure().init();
        return this.classEnclosingClassOffset;
    }

    @Override
    public int getClassDeclaringClassOffset() {
        this.standardClasses.classClass().getStructure().init();
        return this.classDeclaringClassOffset;
    }

    @Override
    public int getClassParentOffset() {
        this.standardClasses.classClass().getStructure().init();
        return this.classParentOffset;
    }

    @Override
    public int getClassNameOffset() {
        this.standardClasses.classClass().getStructure().init();
        return this.classNameOffset;
    }

    @Override
    public int getClassSimpleNameOffset() {
        this.standardClasses.classClass().getStructure().init();
        return this.classSimpleNameOffset;
    }

    @Override
    public int getClassCanonicalNameOffset() {
        this.standardClasses.classClass().getStructure().init();
        return this.classCanonicalNameOffset;
    }

    @Override
    public int getNewArrayFunctionOffset() {
        this.standardClasses.classClass().getStructure().init();
        return this.classNewArrayOffset;
    }

    @Override
    public int getVirtualMethodsOffset() {
        this.standardClasses.classClass().getStructure().init();
        return this.virtualTableFieldOffset;
    }

    @Override
    public int getCloneOffset() {
        this.standardClasses.classClass().getStructure().init();
        return this.cloneOffset;
    }

    @Override
    public int getServicesOffset() {
        this.standardClasses.classClass().getStructure().init();
        return this.servicesOffset;
    }

    @Override
    public int getThrowableNativeOffset() {
        return this.throwableNativeOffset;
    }

    private void initPrimitiveClass(WasmGCClassInfo classInfo, ValueType.Primitive type) {
        classInfo.initializer = target -> {
            int kind;
            switch (type.getKind()) {
                case BOOLEAN: {
                    kind = 0;
                    break;
                }
                case BYTE: {
                    kind = 1;
                    break;
                }
                case SHORT: {
                    kind = 2;
                    break;
                }
                case CHARACTER: {
                    kind = 3;
                    break;
                }
                case INTEGER: {
                    kind = 4;
                    break;
                }
                case LONG: {
                    kind = 5;
                    break;
                }
                case FLOAT: {
                    kind = 6;
                    break;
                }
                case DOUBLE: {
                    kind = 7;
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            ClassMetadataRequirements.Info req = this.metadataRequirements.getInfo(type);
            String name = req != null && req.name() ? ReflectionUtil.typeName(type.getKind()) : null;
            target.add(this.fillPrimitiveClass(classInfo.pointer, name, kind));
        };
    }

    private void initVoidClass(WasmGCClassInfo classInfo) {
        classInfo.initializer = target -> target.add(this.fillPrimitiveClass(classInfo.pointer, "void", 8));
    }

    private void initRegularClass(WasmGCClassInfo classInfo, WasmGCVirtualTable virtualTable, WasmStructure classStructure, String name) {
        ClassReader cls = this.classSource.get(name);
        if (this.classInitializerInfo.isDynamicInitializer(name) && cls != null && cls.getMethod(CLINIT_METHOD_DESC) != null) {
            WasmFunctionType clinitType = this.functionTypes.of(null, new WasmType[0]);
            String wasmName = this.names.topLevel(this.names.suggestForClass(name) + "@initializer");
            classInfo.initializerPointer = new WasmGlobal(wasmName, clinitType.getReference(), new WasmNullConstant(clinitType.getReference()));
            this.module.globals.add(classInfo.initializerPointer);
        }
        classInfo.initializer = target -> {
            WasmGlobal namePtr;
            this.standardClasses.classClass().getStructure().init();
            List<TagRegistry.Range> ranges = this.tagRegistry.getRanges(name);
            int tag = ranges.stream().mapToInt(range -> range.lower).min().orElse(0);
            int flags = cls != null ? this.getFlags(cls) : 0;
            target.add(new WasmCall(this.getFillRegularClassFunction(), new WasmGetGlobal(classInfo.pointer), new WasmInt32Constant(tag), new WasmInt32Constant(flags)));
            ClassMetadataRequirements.Info metadataReq = this.metadataRequirements.getInfo(name);
            if (metadataReq.name()) {
                namePtr = this.strings.getStringConstant((String)name).global;
                target.add(this.setClassField(classInfo, this.classNameOffset, new WasmGetGlobal(namePtr)));
            }
            if (cls != null) {
                WasmGCClassInfo owner;
                if (metadataReq.simpleName() && cls.getSimpleName() != null) {
                    namePtr = this.strings.getStringConstant((String)cls.getSimpleName()).global;
                    target.add(this.setClassField(classInfo, this.classSimpleNameOffset, new WasmGetGlobal(namePtr)));
                }
                if (cls.getParent() != null && metadataReq.superclass()) {
                    WasmGCClassInfo parent = this.getClassInfo(cls.getParent());
                    target.add(this.setClassField(classInfo, this.classParentOffset, new WasmGetGlobal(parent.pointer)));
                }
                if (cls.getOwnerName() != null && metadataReq.enclosingClass()) {
                    owner = this.getClassInfo(cls.getOwnerName());
                    target.add(this.setClassField(classInfo, this.classEnclosingClassOffset, new WasmGetGlobal(owner.pointer)));
                }
                if (cls.getDeclaringClassName() != null && metadataReq.declaringClass()) {
                    owner = this.getClassInfo(cls.getDeclaringClassName());
                    target.add(this.setClassField(classInfo, this.classDeclaringClassOffset, new WasmGetGlobal(owner.pointer)));
                }
                if (metadataReq.cloneMethod()) {
                    WasmFunction cloneFunction = this.hierarchy.isSuperType("java.lang.Cloneable", name, false) ? this.generateCloneFunction(classInfo, name) : this.functionProvider.forStaticMethod(new MethodReference(WasmGCSupport.class, "defaultClone", Object.class, Object.class));
                    cloneFunction.setReferenced(true);
                    target.add(this.setClassField(classInfo, this.cloneOffset, new WasmFunctionReference(cloneFunction)));
                }
                if (metadataReq.enumConstants() && cls.hasModifier(ElementModifier.ENUM)) {
                    target.add(this.setClassField(classInfo, this.enumConstantsFunctionOffset, new WasmFunctionReference(this.createEnumConstantsFunction(classInfo, cls))));
                }
            }
            if (virtualTable != null && virtualTable.isConcrete()) {
                this.fillVirtualTableMethods((List<WasmExpression>)target, classStructure, classInfo.pointer, virtualTable);
            }
            if (classInfo.initializerPointer != null) {
                WasmFunction initFunction = this.functionProvider.forStaticMethod(new MethodReference(name, CLINIT_METHOD_DESC));
                initFunction.setReferenced(true);
                classInfo.initializerPointer.setInitialValue(new WasmFunctionReference(initFunction));
            }
        };
    }

    private int getFlags(ClassReader cls) {
        int flags = 0;
        if (cls.hasModifier(ElementModifier.ABSTRACT)) {
            flags |= 1;
        }
        if (cls.hasModifier(ElementModifier.INTERFACE)) {
            flags |= 2;
        }
        if (cls.hasModifier(ElementModifier.FINAL)) {
            flags |= 4;
        }
        if (cls.hasModifier(ElementModifier.ANNOTATION)) {
            flags |= 0x10;
        }
        if (cls.hasModifier(ElementModifier.SYNTHETIC)) {
            flags |= 0x20;
        }
        if (cls.hasModifier(ElementModifier.ENUM)) {
            flags |= 8;
        }
        return flags;
    }

    private WasmFunction generateCloneFunction(WasmGCClassInfo classInfo, String className) {
        WasmFunction function = new WasmFunction(this.functionTypes.of(this.standardClasses.objectClass().getType(), this.standardClasses.objectClass().getType()));
        function.setName(this.names.topLevel(className + "@clone"));
        this.module.functions.add(function);
        WasmLocal objLocal = new WasmLocal(this.standardClasses.objectClass().getType(), "obj");
        WasmLocal castObjLocal = new WasmLocal(classInfo.getType(), "castObj");
        function.add(objLocal);
        function.add(castObjLocal);
        WasmCast cast = new WasmCast(new WasmGetLocal(objLocal), classInfo.getStructure().getReference());
        function.getBody().add(new WasmSetLocal(castObjLocal, cast));
        WasmStructNew copy = new WasmStructNew(classInfo.structure);
        for (int i = 0; i < classInfo.structure.getFields().size(); ++i) {
            if (i == 1) {
                copy.getInitializers().add(new WasmNullConstant(WasmType.Reference.EQ));
                continue;
            }
            WasmStorageType fieldType = classInfo.structure.getFields().get(i).getType();
            WasmStructGet getExpr = new WasmStructGet(classInfo.structure, new WasmGetLocal(castObjLocal), i);
            if (fieldType instanceof WasmStorageType.Packed) {
                getExpr.setSignedType(WasmSignedType.UNSIGNED);
            }
            copy.getInitializers().add(getExpr);
        }
        function.getBody().add(copy);
        return function;
    }

    private void fillVirtualTableMethods(List<WasmExpression> target, WasmStructure structure, WasmGlobal global, WasmGCVirtualTable virtualTable) {
        WasmGCVirtualTable usedVt = virtualTable.getFirstUsed();
        if (usedVt == null) {
            return;
        }
        for (int i = 0; i < usedVt.getEntries().size(); ++i) {
            WasmGCVirtualTableEntry entry = virtualTable.getEntries().get(i);
            this.fillVirtualTableEntry(target, global, structure, virtualTable, entry);
        }
    }

    private void fillArrayVirtualTableMethods(ValueType type, List<WasmExpression> target, WasmGlobal global, WasmStructure objectStructure) {
        WasmGCVirtualTable virtualTable = this.virtualTables.lookup("java.lang.Object");
        WasmStructure structure = this.getArrayVirtualTableStructure();
        structure.init();
        ValueType itemType = ((ValueType.Array)type).getItemType();
        for (WasmGCVirtualTableEntry wasmGCVirtualTableEntry : virtualTable.getEntries()) {
            this.fillVirtualTableEntry(target, global, structure, virtualTable, wasmGCVirtualTableEntry);
        }
        ClassMetadataRequirements.Info info = this.metadataRequirements.getInfo(type);
        if (info.arrayLength()) {
            WasmFunction wasmFunction = this.getArrayLengthFunction(objectStructure);
            target.add(new WasmStructSet(structure, new WasmGetGlobal(global), this.arrayLengthOffset, new WasmFunctionReference(wasmFunction)));
        }
        if (info.arrayGet()) {
            WasmFunction wasmFunction = this.getArrayGetFunction(itemType);
            target.add(new WasmStructSet(structure, new WasmGetGlobal(global), this.arrayGetOffset, new WasmFunctionReference(wasmFunction)));
        }
        if (info.arrayCopy()) {
            WasmFunction wasmFunction = this.getArrayCopyFunction(itemType);
            target.add(new WasmStructSet(structure, new WasmGetGlobal(global), this.arrayCopyOffset, new WasmFunctionReference(wasmFunction)));
        }
    }

    private WasmFunction getArrayLengthFunction(WasmStructure objectStructure) {
        WasmType.CompositeReference arrayTypeRef = (WasmType.CompositeReference)objectStructure.getFields().get(2).getUnpackedType();
        WasmArray arrayType = (WasmArray)arrayTypeRef.composite;
        WasmType elementType = arrayType.getElementType().asUnpackedType();
        if (elementType instanceof WasmType.Reference) {
            if (this.arrayLengthObjectFunction == null) {
                this.arrayLengthObjectFunction = this.createArrayLengthFunction(objectStructure);
            }
            return this.arrayLengthObjectFunction;
        }
        return this.createArrayLengthFunction(objectStructure);
    }

    private WasmFunction createArrayLengthFunction(WasmStructure objectStructure) {
        WasmFunction function = new WasmFunction(this.functionTypes.of(WasmType.INT32, this.standardClasses.objectClass().getType()));
        function.setReferenced(true);
        function.setName(this.names.topLevel("Array<*>::length"));
        this.module.functions.add(function);
        WasmLocal objectLocal = new WasmLocal(this.standardClasses.objectClass().getType(), "object");
        function.add(objectLocal);
        WasmCast castObject = new WasmCast(new WasmGetLocal(objectLocal), objectStructure.getNonNullReference());
        WasmStructGet arrayField = new WasmStructGet(objectStructure, castObject, 2);
        WasmArrayLength result = new WasmArrayLength(arrayField);
        function.getBody().add(result);
        return function;
    }

    private WasmFunction getArrayGetFunction(ValueType itemType) {
        if (itemType instanceof ValueType.Primitive) {
            return this.generateArrayGetPrimitiveFunction(((ValueType.Primitive)itemType).getKind());
        }
        return this.getArrayGetObjectFunction();
    }

    private WasmFunction getArrayGetObjectFunction() {
        if (this.arrayGetObjectFunction == null) {
            this.arrayGetObjectFunction = new WasmFunction(this.getArrayGetType());
            this.arrayGetObjectFunction.setName(this.names.topLevel("Array<" + this.names.suggestForClass("java.lang.Object") + "::get"));
            this.module.functions.add(this.arrayGetObjectFunction);
            this.arrayGetObjectFunction.setReferenced(true);
            WasmStructure arrayStruct = this.getClassInfo((ValueType)ValueType.arrayOf((ValueType)WasmGCClassGenerator.OBJECT_TYPE)).structure;
            WasmType.CompositeReference arrayDataTypeRef = (WasmType.CompositeReference)arrayStruct.getFields().get(2).getUnpackedType();
            WasmArray arrayDataType = (WasmArray)arrayDataTypeRef.composite;
            WasmLocal objectLocal = new WasmLocal(this.standardClasses.objectClass().getType(), "object");
            WasmLocal indexLocal = new WasmLocal(WasmType.INT32, "index");
            this.arrayGetObjectFunction.add(objectLocal);
            this.arrayGetObjectFunction.add(indexLocal);
            WasmCast array = new WasmCast(new WasmGetLocal(objectLocal), arrayStruct.getNonNullReference());
            WasmStructGet arrayData = new WasmStructGet(arrayStruct, array, 2);
            WasmArrayGet result = new WasmArrayGet(arrayDataType, arrayData, new WasmGetLocal(indexLocal));
            this.arrayGetObjectFunction.getBody().add(result);
        }
        return this.arrayGetObjectFunction;
    }

    private WasmFunction generateArrayGetPrimitiveFunction(PrimitiveType type) {
        Class wrapperType;
        Class<Comparable<Boolean>> primitiveType;
        WasmFunction function = new WasmFunction(this.getArrayGetType());
        function.setName(this.names.topLevel("Array<" + this.names.suggestForType(ValueType.primitive(type)) + ">::get"));
        this.module.functions.add(function);
        function.setReferenced(true);
        WasmStructure arrayStruct = this.getClassInfo((ValueType)ValueType.arrayOf((ValueType)ValueType.primitive((PrimitiveType)type))).structure;
        WasmType.CompositeReference arrayDataTypeRef = (WasmType.CompositeReference)arrayStruct.getFields().get(2).getUnpackedType();
        WasmArray arrayDataType = (WasmArray)arrayDataTypeRef.composite;
        WasmLocal objectLocal = new WasmLocal(this.standardClasses.objectClass().getType(), "object");
        WasmLocal indexLocal = new WasmLocal(WasmType.INT32, "index");
        function.add(objectLocal);
        function.add(indexLocal);
        WasmCast array = new WasmCast(new WasmGetLocal(objectLocal), arrayStruct.getNonNullReference());
        WasmStructGet arrayData = new WasmStructGet(arrayStruct, array, 2);
        WasmArrayGet result = new WasmArrayGet(arrayDataType, arrayData, new WasmGetLocal(indexLocal));
        switch (type) {
            case BOOLEAN: {
                primitiveType = Boolean.TYPE;
                wrapperType = Boolean.class;
                result.setSignedType(WasmSignedType.UNSIGNED);
                break;
            }
            case BYTE: {
                primitiveType = Byte.TYPE;
                wrapperType = Byte.class;
                result.setSignedType(WasmSignedType.SIGNED);
                break;
            }
            case SHORT: {
                primitiveType = Short.TYPE;
                wrapperType = Short.class;
                result.setSignedType(WasmSignedType.SIGNED);
                break;
            }
            case CHARACTER: {
                primitiveType = Character.TYPE;
                wrapperType = Character.class;
                result.setSignedType(WasmSignedType.UNSIGNED);
                break;
            }
            case INTEGER: {
                primitiveType = Integer.TYPE;
                wrapperType = Integer.class;
                break;
            }
            case LONG: {
                primitiveType = Long.TYPE;
                wrapperType = Long.class;
                break;
            }
            case FLOAT: {
                primitiveType = Float.TYPE;
                wrapperType = Float.class;
                break;
            }
            case DOUBLE: {
                primitiveType = Double.TYPE;
                wrapperType = Double.class;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        MethodReference method = new MethodReference(wrapperType, "valueOf", primitiveType, wrapperType);
        WasmFunction wrapFunction = this.functionProvider.forStaticMethod(method);
        WasmCall castResult = new WasmCall(wrapFunction, result);
        function.getBody().add(castResult);
        return function;
    }

    private WasmFunction getArrayCopyFunction(ValueType itemType) {
        if (itemType instanceof ValueType.Primitive) {
            return this.createArrayCopyFunction(itemType);
        }
        return this.getArrayCopyObjectFunction();
    }

    private WasmFunction getArrayCopyObjectFunction() {
        if (this.arrayCopyObjectFunction == null) {
            this.arrayCopyObjectFunction = this.createArrayCopyFunction(OBJECT_TYPE);
        }
        return this.arrayCopyObjectFunction;
    }

    private WasmFunction createArrayCopyFunction(ValueType type) {
        WasmFunction function = new WasmFunction(this.getArrayCopyType());
        function.setName(this.names.topLevel("Array<" + this.names.suggestForType(type) + ">::copy"));
        this.module.functions.add(function);
        function.setReferenced(true);
        WasmStructure arrayStruct = this.getClassInfo((ValueType)ValueType.arrayOf((ValueType)type)).structure;
        WasmType.CompositeReference arrayDataTypeRef = (WasmType.CompositeReference)arrayStruct.getFields().get(2).getUnpackedType();
        WasmArray arrayDataType = (WasmArray)arrayDataTypeRef.composite;
        WasmLocal sourceLocal = new WasmLocal(this.standardClasses.objectClass().getType(), "source");
        WasmLocal sourceIndexLocal = new WasmLocal(WasmType.INT32, "sourceIndex");
        WasmLocal targetLocal = new WasmLocal(this.standardClasses.objectClass().getType(), "target");
        WasmLocal targetIndexLocal = new WasmLocal(WasmType.INT32, "targetIndex");
        WasmLocal countLocal = new WasmLocal(WasmType.INT32, "count");
        function.add(sourceLocal);
        function.add(sourceIndexLocal);
        function.add(targetLocal);
        function.add(targetIndexLocal);
        function.add(countLocal);
        WasmCast sourceArray = new WasmCast(new WasmGetLocal(sourceLocal), arrayStruct.getNonNullReference());
        WasmStructGet sourceArrayData = new WasmStructGet(arrayStruct, sourceArray, 2);
        WasmCast targetArray = new WasmCast(new WasmGetLocal(targetLocal), arrayStruct.getNonNullReference());
        WasmStructGet targetArrayData = new WasmStructGet(arrayStruct, targetArray, 2);
        function.getBody().add(new WasmArrayCopy(arrayDataType, targetArrayData, new WasmGetLocal(targetIndexLocal), arrayDataType, sourceArrayData, new WasmGetLocal(sourceIndexLocal), new WasmGetLocal(countLocal)));
        return function;
    }

    private WasmFunctionType getArrayGetType() {
        if (this.arrayGetType == null) {
            this.arrayGetType = this.functionTypes.of(this.standardClasses.objectClass().getType(), this.standardClasses.objectClass().getType(), WasmType.INT32);
        }
        return this.arrayGetType;
    }

    private WasmFunctionType getArrayLengthType() {
        if (this.arrayLengthType == null) {
            this.arrayLengthType = this.functionTypes.of(WasmType.INT32, this.standardClasses.objectClass().getType());
        }
        return this.arrayLengthType;
    }

    private WasmFunctionType getArrayCopyType() {
        if (this.arrayCopyType == null) {
            this.arrayCopyType = this.functionTypes.of(null, this.standardClasses.objectClass().getType(), WasmType.INT32, this.standardClasses.objectClass().getType(), WasmType.INT32, WasmType.INT32);
        }
        return this.arrayCopyType;
    }

    private void fillVirtualTableEntry(List<WasmExpression> target, WasmGlobal global, WasmStructure structure, WasmGCVirtualTable virtualTable, WasmGCVirtualTableEntry entry) {
        MethodReference implementor = virtualTable.implementor(entry);
        if (implementor != null && !entry.getMethod().equals(GET_CLASS_METHOD)) {
            int fieldIndex = this.virtualTableFieldOffset + entry.getIndex();
            WasmType.CompositeReference expectedType = (WasmType.CompositeReference)structure.getFields().get(fieldIndex).getUnpackedType();
            WasmFunctionType expectedFunctionType = (WasmFunctionType)expectedType.composite;
            WasmFunction function = this.functionProvider.forInstanceMethod(implementor);
            if (!entry.getOrigin().getClassName().equals(implementor.getClassName()) || expectedFunctionType != function.getType()) {
                WasmFunction wrapperFunction = new WasmFunction(expectedFunctionType);
                wrapperFunction.setName(this.names.topLevel(this.names.suggestForMethod(implementor) + "@caller"));
                this.module.functions.add(wrapperFunction);
                WasmCall call = new WasmCall(function);
                WasmLocal instanceParam = new WasmLocal(this.getClassInfo(virtualTable.getClassName()).getType());
                wrapperFunction.add(instanceParam);
                WasmType.CompositeReference castTarget = this.getClassInfo(implementor.getClassName()).getStructure().getNonNullReference();
                call.getArguments().add(new WasmCast(new WasmGetLocal(instanceParam), castTarget));
                WasmLocal[] params = new WasmLocal[entry.getMethod().parameterCount()];
                for (int i = 0; i < entry.getMethod().parameterCount(); ++i) {
                    params[i] = new WasmLocal(this.typeMapper.mapType(entry.getMethod().parameterType(i)));
                    call.getArguments().add(new WasmGetLocal(params[i]));
                    wrapperFunction.add(params[i]);
                }
                wrapperFunction.getBody().add(call);
                function = wrapperFunction;
            }
            function.setReferenced(true);
            WasmFunctionReference ref = new WasmFunctionReference(function);
            target.add(new WasmStructSet(structure, new WasmGetGlobal(global), fieldIndex, ref));
        }
    }

    private WasmFunction generateArrayCloneMethod(WasmStructure objectStructure, ValueType itemType) {
        WasmType.CompositeReference arrayTypeRef = (WasmType.CompositeReference)objectStructure.getFields().get(2).getUnpackedType();
        WasmArray arrayType = (WasmArray)arrayTypeRef.composite;
        WasmFunctionType type = this.typeMapper.getFunctionType(this.standardClasses.objectClass().getType(), CLONE_METHOD_DESC, false);
        WasmFunction function = new WasmFunction(type);
        function.setName(this.names.topLevel("Array<" + this.names.suggestForType(itemType) + ">::clone"));
        this.module.functions.add(function);
        WasmLocal instanceLocal = new WasmLocal(this.standardClasses.objectClass().getType(), "instance");
        WasmLocal originalLocal = new WasmLocal(objectStructure.getReference(), "original");
        WasmLocal originalDataLocal = new WasmLocal(arrayType.getNonNullReference(), "originalData");
        WasmLocal dataCopyLocal = new WasmLocal(arrayType.getNonNullReference(), "resultData");
        function.add(instanceLocal);
        function.add(originalLocal);
        function.add(originalDataLocal);
        function.add(dataCopyLocal);
        WasmStructNew newExpr = new WasmStructNew(objectStructure);
        function.getBody().add(new WasmSetLocal(originalLocal, new WasmCast(new WasmGetLocal(instanceLocal), objectStructure.getNonNullReference())));
        WasmStructGet classValue = new WasmStructGet(objectStructure, new WasmGetLocal(originalLocal), 0);
        newExpr.getInitializers().add(classValue);
        newExpr.getInitializers().add(new WasmNullConstant(WasmType.Reference.EQ));
        WasmStructGet originalDataValue = new WasmStructGet(objectStructure, new WasmGetLocal(originalLocal), 2);
        function.getBody().add(new WasmSetLocal(originalDataLocal, originalDataValue));
        WasmArrayLength originalLength = new WasmArrayLength(new WasmGetLocal(originalDataLocal));
        function.getBody().add(new WasmSetLocal(dataCopyLocal, new WasmArrayNewDefault(arrayType, originalLength)));
        newExpr.getInitializers().add(new WasmGetLocal(dataCopyLocal));
        function.getBody().add(new WasmArrayCopy(arrayType, new WasmGetLocal(dataCopyLocal), new WasmInt32Constant(0), arrayType, new WasmGetLocal(originalDataLocal), new WasmInt32Constant(0), new WasmArrayLength(new WasmGetLocal(originalDataLocal))));
        function.getBody().add(newExpr);
        return function;
    }

    private void initRegularClassStructure(WasmGCClassInfo classInfo, String className) {
        WasmStructure structure;
        WasmGCVirtualTable virtualTable = this.virtualTables.lookup(className);
        String wasmName = this.names.topLevel("Class<" + this.names.suggestForClass(className) + ">");
        classInfo.virtualTableStructure = structure = new WasmStructure(wasmName, fields -> {
            this.addSystemFields((List<WasmField>)fields);
            this.fillSimpleClassFields((List<WasmField>)fields, "java.lang.Class");
            this.addVirtualTableFields((List<WasmField>)fields, virtualTable);
        });
        this.nonInitializedStructures.add(structure);
        WasmGCVirtualTable usedParent = virtualTable.getUsedParent();
        WasmStructure supertype = usedParent != null ? this.getClassInfo(usedParent.getClassName()).getVirtualTableStructure() : this.standardClasses.classClass().getStructure();
        structure.setSupertype(supertype);
        this.module.types.add(structure);
    }

    private void addSystemFields(List<WasmField> fields) {
        WasmField classField = new WasmField(this.standardClasses.classClass().getType().asStorage());
        classField.setName(this.names.forMemberField(FAKE_CLASS_FIELD));
        fields.add(classField);
        WasmField monitorField = new WasmField(WasmType.Reference.EQ.asStorage());
        monitorField.setName(this.names.forMemberField(FAKE_MONITOR_FIELD));
        fields.add(monitorField);
    }

    private void addVirtualTableFields(List<WasmField> fields, WasmGCVirtualTable virtualTable) {
        for (WasmGCVirtualTableEntry wasmGCVirtualTableEntry : virtualTable.getEntries()) {
            WasmFunctionType functionType = this.typeMapper.getFunctionType(wasmGCVirtualTableEntry.getOrigin().getClassName(), wasmGCVirtualTableEntry.getMethod(), false);
            WasmField field = new WasmField(functionType.getReference().asStorage());
            field.setName(this.names.forVirtualMethod(wasmGCVirtualTableEntry.getMethod()));
            fields.add(field);
        }
    }

    @Override
    public WasmStructure getArrayVirtualTableStructure() {
        if (this.arrayVirtualTableStruct == null) {
            String wasmName = this.names.topLevel("Class<Array<*>>");
            this.arrayVirtualTableStruct = new WasmStructure(wasmName, fields -> {
                this.addSystemFields((List<WasmField>)fields);
                this.fillSimpleClassFields((List<WasmField>)fields, "java.lang.Class");
                this.addVirtualTableFields((List<WasmField>)fields, this.virtualTables.lookup("java.lang.Object"));
                if (this.metadataRequirements.hasArrayLength()) {
                    this.arrayLengthOffset = fields.size();
                    WasmFunctionType arrayLengthType = this.getArrayLengthType();
                    fields.add(new WasmField(arrayLengthType.getReference().asStorage(), this.names.structureField("@arrayLength")));
                }
                if (this.metadataRequirements.hasArrayGet()) {
                    this.arrayGetOffset = fields.size();
                    WasmFunctionType arrayGetType = this.getArrayGetType();
                    fields.add(new WasmField(arrayGetType.getReference().asStorage(), this.names.structureField("@arrayGet")));
                }
                if (this.metadataRequirements.hasArrayCopy()) {
                    this.arrayCopyOffset = fields.size();
                    WasmFunctionType arrayCopyType = this.getArrayCopyType();
                    fields.add(new WasmField(arrayCopyType.getReference().asStorage(), this.names.structureField("@arrayCopy")));
                }
            });
            this.arrayVirtualTableStruct.setSupertype(this.standardClasses.objectClass().getVirtualTableStructure());
            this.module.types.add(this.arrayVirtualTableStruct);
            this.nonInitializedStructures.add(this.arrayVirtualTableStruct);
        }
        return this.arrayVirtualTableStruct;
    }

    @Override
    public int getArrayLengthOffset() {
        this.initStructures();
        return this.arrayLengthOffset;
    }

    @Override
    public int getArrayGetOffset() {
        this.initStructures();
        return this.arrayGetOffset;
    }

    @Override
    public int getArrayCopyOffset() {
        this.initStructures();
        return this.arrayCopyOffset;
    }

    @Override
    public int getEnumConstantsFunctionOffset() {
        return this.enumConstantsFunctionOffset;
    }

    private void initArrayClass(WasmGCClassInfo classInfo, ValueType.Array type) {
        classInfo.initializer = target -> {
            WasmGCClassInfo itemTypeInfo = this.getClassInfo(type.getItemType());
            target.add(new WasmCall(this.getCreateArrayClassFunction(), new WasmGetGlobal(classInfo.pointer), new WasmGetGlobal(itemTypeInfo.pointer)));
            this.fillArrayVirtualTableMethods(classInfo.getValueType(), (List<WasmExpression>)target, classInfo.pointer, classInfo.structure);
            ClassMetadataRequirements.Info metadataReq = this.metadataRequirements.getInfo(type);
            if (metadataReq.cloneMethod()) {
                WasmFunction cloneFunction = this.generateArrayCloneMethod(classInfo.structure, type.getItemType());
                cloneFunction.setReferenced(true);
                target.add(this.setClassField(classInfo, this.cloneOffset, new WasmFunctionReference(cloneFunction)));
            }
            if (metadataReq.name() && type.getItemType() instanceof ValueType.Primitive) {
                WasmGCStringConstant name = this.strings.getStringConstant(type.toString());
                target.add(this.setClassField(classInfo, this.classNameOffset, new WasmGetGlobal(name.global)));
            }
        };
    }

    private WasmExpression fillPrimitiveClass(WasmGlobal global, String name, int kind) {
        WasmCall call = new WasmCall(this.getCreatePrimitiveClassFunction());
        call.getArguments().add(new WasmGetGlobal(global));
        if (this.metadataRequirements.hasName()) {
            call.getArguments().add(name != null ? new WasmGetGlobal(this.strings.getStringConstant((String)name).global) : new WasmNullConstant(this.standardClasses.stringClass().getType()));
        }
        call.getArguments().add(new WasmInt32Constant(kind));
        return call;
    }

    @Override
    public int getFieldIndex(FieldReference fieldRef) {
        this.getClassInfo((String)fieldRef.getClassName()).structure.init();
        return this.fieldIndexes.getOrDefault((Object)fieldRef, -1);
    }

    @Override
    public WasmGlobal getStaticFieldLocation(FieldReference fieldRef) {
        return this.staticFieldLocations.computeIfAbsent(fieldRef, this::generateStaticFieldLocation);
    }

    private WasmGlobal generateStaticFieldLocation(FieldReference fieldRef) {
        FieldReader field;
        ValueType javaType = null;
        Object initValue = null;
        ClassReader cls = this.classSource.get(fieldRef.getClassName());
        if (cls != null && (field = cls.getField(fieldRef.getFieldName())) != null) {
            javaType = field.getType();
            initValue = field.getInitialValue();
        }
        if (javaType == null) {
            javaType = ValueType.object("java.lang.Object");
        }
        WasmType type = this.typeMapper.mapType(javaType);
        WasmExpression wasmInitialValue = initValue != null ? this.initialValue(initValue) : WasmExpression.defaultValueOfType(type);
        String wasmName = this.names.topLevel(this.names.suggestForStaticField(fieldRef));
        WasmGlobal global = new WasmGlobal(wasmName, type, wasmInitialValue);
        this.dynamicInitialValue(global, initValue);
        this.module.globals.add(global);
        return global;
    }

    private WasmExpression initialValue(Object value) {
        if (value instanceof Boolean) {
            return new WasmInt32Constant((Boolean)value != false ? 1 : 0);
        }
        if (value instanceof Byte) {
            return new WasmInt32Constant(((Byte)value).byteValue());
        }
        if (value instanceof Short) {
            return new WasmInt32Constant(((Short)value).shortValue());
        }
        if (value instanceof Character) {
            return new WasmInt32Constant(((Character)value).charValue());
        }
        if (value instanceof Integer) {
            return new WasmInt32Constant((Integer)value);
        }
        if (value instanceof Long) {
            return new WasmInt64Constant((Long)value);
        }
        if (value instanceof Float) {
            return new WasmFloat32Constant(((Float)value).floatValue());
        }
        if (value instanceof Double) {
            return new WasmFloat64Constant((Double)value);
        }
        return new WasmNullConstant(this.standardClasses.stringClass().getType());
    }

    private void dynamicInitialValue(WasmGlobal global, Object value) {
        if (value instanceof String) {
            WasmGlobal constant = this.strings.getStringConstant((String)((String)value)).global;
            this.staticFieldInitializers.add(function -> function.getBody().add(new WasmSetGlobal(global, new WasmGetGlobal(constant))));
        } else if (value instanceof ValueType) {
            WasmGlobal constant = this.getClassInfo((ValueType)((ValueType)value)).pointer;
            this.staticFieldInitializers.add(function -> function.getBody().add(new WasmSetGlobal(global, new WasmGetGlobal(constant))));
        }
    }

    private void fillFields(WasmGCClassInfo classInfo, List<WasmField> fields, ValueType type) {
        this.addSystemFields(fields);
        if (type instanceof ValueType.Object) {
            this.fillClassFields(fields, ((ValueType.Object)type).getClassName());
        } else if (type instanceof ValueType.Array) {
            this.fillArrayFields(classInfo, ((ValueType.Array)type).getItemType());
        }
    }

    private void fillClassFields(List<WasmField> fields, String className) {
        ClassReader classReader = this.classSource.get(className);
        if (classReader == null || classReader.hasModifier(ElementModifier.INTERFACE)) {
            this.fillSimpleClassFields(fields, "java.lang.Object");
        } else {
            this.fillSimpleClassFields(fields, className);
        }
    }

    private void fillSimpleClassFields(List<WasmField> fields, String className) {
        Object field;
        ClassReader classReader = this.classSource.get(className);
        if (classReader.getParent() != null) {
            this.fillClassFields(fields, classReader.getParent());
        }
        if (className.equals("java.lang.ref.WeakReference")) {
            field = new WasmField(WasmType.Reference.EXTERN.asStorage(), "nativeRef");
            fields.add((WasmField)field);
        } else {
            for (FieldReader fieldReader : classReader.getFields()) {
                if (className.equals("java.lang.Object") && fieldReader.getName().equals("monitor") || className.equals("java.lang.Class") && fieldReader.getName().equals("platformClass") || fieldReader.hasModifier(ElementModifier.STATIC)) continue;
                this.fieldIndexes.putIfAbsent((Object)fieldReader.getReference(), fields.size());
                WasmField wasmField = new WasmField(this.typeMapper.mapStorageType(fieldReader.getType()), this.names.forMemberField(fieldReader.getReference()));
                fields.add(wasmField);
            }
        }
        if (className.equals(StringInternPool.class.getName() + "$Entry")) {
            field = new WasmField(WasmType.Reference.EXTERN.asStorage(), "nativeRef");
            fields.add((WasmField)field);
        }
        if (className.equals("java.lang.Throwable")) {
            this.throwableNativeOffset = fields.size();
            field = new WasmField(WasmType.Reference.EXTERN.asStorage(), "nativeRef");
            fields.add((WasmField)field);
        }
        if (className.equals("java.lang.Class")) {
            ClassReader cls = this.classSource.get("java.lang.Class");
            this.classFlagsOffset = fields.size();
            fields.add(this.createClassField(WasmType.INT32.asStorage(), "flags"));
            this.classTagOffset = fields.size();
            fields.add(this.createClassField(WasmType.INT32.asStorage(), "id"));
            if (this.metadataRequirements.hasSuperclass()) {
                this.classParentOffset = fields.size();
                fields.add(this.createClassField(this.standardClasses.classClass().getType().asStorage(), "parent"));
            }
            this.classArrayItemOffset = fields.size();
            fields.add(this.createClassField(this.standardClasses.classClass().getType().asStorage(), "arrayItem"));
            this.classArrayOffset = fields.size();
            fields.add(this.createClassField(this.standardClasses.classClass().getType().asStorage(), "array"));
            if (this.metadataRequirements.hasIsAssignable()) {
                this.classSupertypeFunctionOffset = fields.size();
                fields.add(this.createClassField(this.supertypeGenerator.getFunctionType().getReference().asStorage(), "isSupertype"));
            }
            if (this.metadataRequirements.hasArrayNewInstance()) {
                this.classNewArrayOffset = fields.size();
                fields.add(this.createClassField(this.newArrayGenerator.getNewArrayFunctionType().getReference().asStorage(), "createArrayInstance"));
            }
            if (this.metadataRequirements.hasEnclosingClass()) {
                this.classEnclosingClassOffset = fields.size();
                fields.add(this.createClassField(this.standardClasses.classClass().getType().asStorage(), "enclosingClass"));
            }
            if (this.metadataRequirements.hasDeclaringClass()) {
                this.classDeclaringClassOffset = fields.size();
                fields.add(this.createClassField(this.standardClasses.classClass().getType().asStorage(), "declaringClass"));
            }
            if (this.metadataRequirements.hasName()) {
                this.classNameOffset = fields.size();
                fields.add(this.createClassField(this.standardClasses.stringClass().getType().asStorage(), "name"));
            }
            if (this.metadataRequirements.hasSimpleName()) {
                this.classSimpleNameOffset = fields.size();
                fields.add(this.createClassField(this.standardClasses.stringClass().getType().asStorage(), "simpleName"));
            }
            if (cls != null && cls.getMethod(new MethodDescriptor("getCanonicalName", String.class)) != null) {
                this.classCanonicalNameOffset = fields.size();
                fields.add(this.createClassField(this.standardClasses.stringClass().getType().asStorage(), "canonicalName"));
            }
            this.cloneOffset = fields.size();
            fields.add(this.createClassField(this.functionTypes.of(this.standardClasses.objectClass().getType(), this.standardClasses.objectClass().getType()).getReference().asStorage(), "clone"));
            if (this.hasLoadServices) {
                this.servicesOffset = fields.size();
                WasmFunctionType wasmFunctionType = this.functionTypes.of(this.getClassInfo(ValueType.parse(Object[].class)).getType(), new WasmType[0]);
                fields.add(this.createClassField(wasmFunctionType.getReference().asStorage(), "services"));
            }
            if (this.metadataRequirements.hasEnumConstants()) {
                this.enumConstantsFunctionOffset = fields.size();
                WasmType.CompositeReference compositeReference = this.getClassInfo(ValueType.arrayOf(ValueType.object("java.lang.Enum"))).getType();
                WasmFunctionType enumConstantsType = this.functionTypes.of(compositeReference, new WasmType[0]);
                fields.add(this.createClassField(enumConstantsType.getReference().asStorage(), "getEnumConstants"));
            }
            this.virtualTableFieldOffset = fields.size();
        }
    }

    private WasmField createClassField(WasmStorageType type, String name) {
        return new WasmField(type, this.names.forMemberField(new FieldReference("java.lang.Class", name)));
    }

    private void fillArrayFields(WasmGCClassInfo classInfo, ValueType elementType) {
        WasmArray wasmArray;
        if (elementType instanceof ValueType.Primitive) {
            WasmStorageType wasmElementType;
            switch (((ValueType.Primitive)elementType).getKind()) {
                case BOOLEAN: 
                case BYTE: {
                    wasmElementType = WasmStorageType.INT8;
                    break;
                }
                case SHORT: 
                case CHARACTER: {
                    wasmElementType = WasmStorageType.INT16;
                    break;
                }
                case INTEGER: {
                    wasmElementType = WasmType.INT32.asStorage();
                    break;
                }
                case LONG: {
                    wasmElementType = WasmType.INT64.asStorage();
                    break;
                }
                case FLOAT: {
                    wasmElementType = WasmType.FLOAT32.asStorage();
                    break;
                }
                case DOUBLE: {
                    wasmElementType = WasmType.FLOAT64.asStorage();
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            String wasmArrayName = this.names.topLevel(this.names.suggestForType(classInfo.getValueType()) + "$Data");
            wasmArray = new WasmArray(wasmArrayName, wasmElementType);
            this.module.types.add(wasmArray);
        } else {
            WasmStorageType.Regular wasmElementType = this.standardClasses.objectClass().getType().asStorage();
            wasmArray = this.objectArrayType;
            if (wasmArray == null) {
                String wasmArrayName = this.names.topLevel(this.names.suggestForType(ValueType.arrayOf(ValueType.object("java.lang.Object"))) + "$Data");
                wasmArray = new WasmArray(wasmArrayName, wasmElementType);
                this.module.types.add(wasmArray);
                this.objectArrayType = wasmArray;
            }
        }
        classInfo.structure.getFields().add(new WasmField(wasmArray.getNonNullReference().asStorage(), this.arrayDataFieldName()));
    }

    private String arrayDataFieldName() {
        if (this.arrayDataFieldName == null) {
            this.arrayDataFieldName = this.names.structureField("@data");
        }
        return this.arrayDataFieldName;
    }

    private WasmFunction getCreatePrimitiveClassFunction() {
        if (this.createPrimitiveClassFunction == null) {
            this.createPrimitiveClassFunction = this.createCreatePrimitiveClassFunction();
        }
        return this.createPrimitiveClassFunction;
    }

    private WasmFunction createCreatePrimitiveClassFunction() {
        WasmLocal nameVar;
        ArrayList<WasmType> params = new ArrayList<WasmType>();
        params.add(this.standardClasses.classClass().getType());
        if (this.metadataRequirements.hasName()) {
            params.add(this.standardClasses.stringClass().getType());
        }
        params.add(WasmType.INT32);
        WasmFunctionType functionType = this.functionTypes.of(null, params.toArray(new WasmType[0]));
        WasmFunction function = new WasmFunction(functionType);
        function.setName(this.names.topLevel("teavm@fillPrimitiveClass"));
        this.module.functions.add(function);
        WasmLocal targetVar = new WasmLocal(this.standardClasses.classClass().getType(), "target");
        function.add(targetVar);
        if (this.metadataRequirements.hasName()) {
            nameVar = new WasmLocal(this.standardClasses.stringClass().getType(), "name");
            function.add(nameVar);
        } else {
            nameVar = null;
        }
        WasmLocal kindVar = new WasmLocal(WasmType.INT32, "kind");
        function.add(kindVar);
        this.standardClasses.classClass().getStructure().init();
        function.getBody().add(new WasmStructSet(this.standardClasses.classClass().getStructure(), new WasmGetLocal(targetVar), 0, new WasmGetGlobal(this.standardClasses.classClass().pointer)));
        WasmIntBinary flagsExpr = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.SHL, new WasmGetLocal(kindVar), new WasmInt32Constant(16));
        flagsExpr = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.OR, flagsExpr, new WasmInt32Constant(32772));
        function.getBody().add(new WasmStructSet(this.standardClasses.classClass().getStructure(), new WasmGetLocal(targetVar), this.classFlagsOffset, flagsExpr));
        if (nameVar != null) {
            function.getBody().add(new WasmStructSet(this.standardClasses.classClass().getStructure(), new WasmGetLocal(targetVar), this.classNameOffset, new WasmGetLocal(nameVar)));
        }
        function.getBody().add(new WasmStructSet(this.standardClasses.classClass().getStructure(), new WasmGetLocal(targetVar), this.classTagOffset, new WasmInt32Constant(Integer.MAX_VALUE)));
        return function;
    }

    private WasmFunction getFillRegularClassFunction() {
        if (this.fillRegularClassFunction == null) {
            this.fillRegularClassFunction = this.createFillRegularClassFunction();
        }
        return this.fillRegularClassFunction;
    }

    private WasmFunction createFillRegularClassFunction() {
        WasmFunctionType functionType = this.functionTypes.of(null, this.standardClasses.classClass().getType(), WasmType.INT32, WasmType.INT32);
        WasmFunction function = new WasmFunction(functionType);
        this.module.functions.add(function);
        function.setName(this.names.topLevel("teavm@fillRegularClass"));
        WasmLocal targetVar = new WasmLocal(this.standardClasses.classClass().getType(), "target");
        WasmLocal idVar = new WasmLocal(this.standardClasses.classClass().getType(), "id");
        WasmLocal flagsVar = new WasmLocal(this.standardClasses.classClass().getType(), "flags");
        function.add(targetVar);
        function.add(idVar);
        function.add(flagsVar);
        this.standardClasses.classClass().getStructure().init();
        function.getBody().add(new WasmStructSet(this.standardClasses.classClass().getStructure(), new WasmGetLocal(targetVar), 0, new WasmGetGlobal(this.standardClasses.classClass().pointer)));
        function.getBody().add(new WasmStructSet(this.standardClasses.classClass().getStructure(), new WasmGetLocal(targetVar), this.classTagOffset, new WasmGetLocal(idVar)));
        function.getBody().add(new WasmStructSet(this.standardClasses.classClass().getStructure(), new WasmGetLocal(targetVar), this.classFlagsOffset, new WasmGetLocal(flagsVar)));
        return function;
    }

    private WasmFunction getCreateArrayClassFunction() {
        if (this.createArrayClassFunction == null) {
            this.createArrayClassFunction = this.createCreateArrayClassFunction();
        }
        return this.createArrayClassFunction;
    }

    private WasmFunction createCreateArrayClassFunction() {
        WasmFunctionType functionType = this.functionTypes.of(null, this.standardClasses.classClass().getType(), this.standardClasses.classClass().getType());
        WasmFunction function = new WasmFunction(functionType);
        this.module.functions.add(function);
        function.setName(this.names.topLevel("teavm@fillArrayClass"));
        WasmLocal targetVar = new WasmLocal(this.standardClasses.classClass().getType(), "target");
        WasmLocal itemVar = new WasmLocal(this.standardClasses.classClass().getType(), "item");
        function.add(targetVar);
        function.add(itemVar);
        this.standardClasses.classClass().getStructure().init();
        function.getBody().add(new WasmStructSet(this.standardClasses.classClass().getStructure(), new WasmGetLocal(targetVar), 0, new WasmGetGlobal(this.standardClasses.classClass().pointer)));
        function.getBody().add(new WasmStructSet(this.standardClasses.classClass().getStructure(), new WasmGetLocal(targetVar), this.classFlagsOffset, new WasmInt32Constant(4)));
        function.getBody().add(new WasmStructSet(this.standardClasses.classClass().getStructure(), new WasmGetLocal(targetVar), this.classArrayItemOffset, new WasmGetLocal(itemVar)));
        function.getBody().add(new WasmStructSet(this.standardClasses.classClass().getStructure(), new WasmGetLocal(itemVar), this.classArrayOffset, new WasmGetLocal(targetVar)));
        function.getBody().add(new WasmStructSet(this.standardClasses.classClass().getStructure(), new WasmGetLocal(targetVar), this.classTagOffset, new WasmInt32Constant(0)));
        if (this.classParentOffset >= 0) {
            function.getBody().add(new WasmStructSet(this.standardClasses.classClass().getStructure(), new WasmGetLocal(targetVar), this.classParentOffset, new WasmGetGlobal(this.standardClasses.objectClass().pointer)));
        }
        return function;
    }

    private WasmFunction createEnumConstantsFunction(WasmGCClassInfo classInfo, ClassReader cls) {
        WasmStructure enumArrayStruct = this.getClassInfo((ValueType)ValueType.parse(Enum[].class)).structure;
        WasmFunction function = new WasmFunction(this.functionTypes.of(enumArrayStruct.getReference(), new WasmType[0]));
        function.setName(this.names.topLevel(cls.getName() + "@constants"));
        this.module.functions.add(function);
        function.setReferenced(true);
        List fields = cls.getFields().stream().filter(field -> field.hasModifier(ElementModifier.ENUM)).filter(field -> field.hasModifier(ElementModifier.STATIC)).map(field -> new WasmGetGlobal(this.getStaticFieldLocation(field.getReference()))).collect(Collectors.toList());
        if (classInfo.getInitializerPointer() != null) {
            function.getBody().add(new WasmCallReference(new WasmGetGlobal(classInfo.getInitializerPointer()), this.functionTypes.of(null, new WasmType[0])));
        }
        WasmGCGenerationUtil util = new WasmGCGenerationUtil(this);
        function.getBody().add(util.allocateArrayWithElements(ValueType.parse(Enum.class), () -> fields));
        return function;
    }

    private WasmExpression setClassField(WasmGCClassInfo classInfo, int fieldIndex, WasmExpression value) {
        return new WasmStructSet(this.standardClasses.classClass().getStructure(), new WasmGetGlobal(classInfo.pointer), fieldIndex, value);
    }
}

