/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.generate.gc;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.teavm.model.FieldReference;
import org.teavm.model.MethodDescriptor;
import org.teavm.model.MethodReference;
import org.teavm.model.ValueType;

public class WasmGCNameProvider {
    private Set<String> occupiedTopLevelNames = new HashSet<String>();
    private Set<String> occupiedStructNames = new HashSet<String>();
    private Map<MethodDescriptor, String> virtualMethodNames = new HashMap<MethodDescriptor, String>();
    private Map<FieldReference, String> memberFieldNames = new HashMap<FieldReference, String>();

    public String topLevel(String name) {
        return this.pickUnoccupied(name);
    }

    public String structureField(String name) {
        return this.pickUnoccupied(name, this.occupiedStructNames);
    }

    public String forVirtualMethod(MethodDescriptor method) {
        return this.virtualMethodNames.computeIfAbsent(method, k -> this.pickUnoccupied(WasmGCNameProvider.sanitize(k.getName()), this.occupiedStructNames));
    }

    public String forMemberField(FieldReference field) {
        return this.memberFieldNames.computeIfAbsent(field, k -> this.pickUnoccupied(WasmGCNameProvider.sanitize(field.getFieldName()), this.occupiedStructNames));
    }

    public String suggestForMethod(MethodReference method) {
        StringBuilder sb = new StringBuilder();
        sb.append(WasmGCNameProvider.sanitize(method.getClassName()));
        sb.append("::");
        sb.append(WasmGCNameProvider.sanitize(method.getName()));
        return sb.toString();
    }

    public String suggestForStaticField(FieldReference field) {
        StringBuilder sb = new StringBuilder();
        sb.append(WasmGCNameProvider.sanitize(field.getClassName()));
        sb.append('#');
        sb.append(WasmGCNameProvider.sanitize(field.getFieldName()));
        return sb.toString();
    }

    public String suggestForClass(String className) {
        return WasmGCNameProvider.sanitize(className);
    }

    public String suggestForType(ValueType type) {
        StringBuilder sb = new StringBuilder();
        this.suggestForType(type, sb);
        return sb.toString();
    }

    private void suggestForType(ValueType type, StringBuilder sb) {
        if (type instanceof ValueType.Object) {
            sb.append(this.suggestForClass(((ValueType.Object)type).getClassName()));
        } else if (type instanceof ValueType.Array) {
            sb.append("Array<");
            this.suggestForType(((ValueType.Array)type).getItemType(), sb);
            sb.append(">");
        } else {
            sb.append("&").append(type.toString());
        }
    }

    public static String sanitize(String name) {
        int c;
        int i;
        char[] chars = null;
        for (i = 0; i < name.length(); ++i) {
            c = name.charAt(i);
            if (WasmGCNameProvider.isIdentifierPart((char)c)) continue;
            chars = new char[name.length()];
            name.getChars(0, i, chars, 0);
            chars[i++] = 95;
            break;
        }
        if (chars == null) {
            return name;
        }
        while (i < name.length()) {
            c = name.charAt(i);
            chars[i] = WasmGCNameProvider.isIdentifierPart((char)c) ? c : 95;
            ++i;
        }
        return new String(chars);
    }

    public static boolean isIdentifierPart(char c) {
        switch (c) {
            case '!': 
            case '#': 
            case '$': 
            case '%': 
            case '&': 
            case '\'': 
            case '*': 
            case '+': 
            case '-': 
            case '.': 
            case '/': 
            case ':': 
            case '<': 
            case '=': 
            case '>': 
            case '?': 
            case '@': 
            case '\\': 
            case '^': 
            case '_': 
            case '`': 
            case '|': 
            case '~': {
                return true;
            }
        }
        return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9';
    }

    private String pickUnoccupied(String name) {
        return this.pickUnoccupied(name, this.occupiedTopLevelNames);
    }

    private String pickUnoccupied(String name, Set<String> occupied) {
        Object result = name;
        int index = 0;
        while (!occupied.add((String)result)) {
            result = name + "_" + index++;
        }
        return result;
    }
}

