/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.gc.vtable;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.teavm.backend.wasm.gc.vtable.WasmGCVirtualTable;
import org.teavm.backend.wasm.gc.vtable.WasmGCVirtualTableEntry;
import org.teavm.common.LCATree;
import org.teavm.hppc.ObjectIntHashMap;
import org.teavm.hppc.cursors.ObjectIntCursor;
import org.teavm.model.ClassReader;
import org.teavm.model.ElementModifier;
import org.teavm.model.ListableClassReaderSource;
import org.teavm.model.MethodDescriptor;
import org.teavm.model.MethodReader;
import org.teavm.model.MethodReference;

class WasmGCVirtualTableBuilder {
    private static final MethodReference CLONE_METHOD = new MethodReference(Object.class, "clone", Object.class);
    ListableClassReaderSource classes;
    Collection<MethodReference> methodsAtCallSites;
    Predicate<MethodReference> isVirtual;
    private Map<String, Set<MethodDescriptor>> groupedMethodsAtCallSites = new HashMap<String, Set<MethodDescriptor>>();
    private List<Table> tables = new ArrayList<Table>();
    private Map<String, Table> tableMap = new HashMap<String, Table>();
    private LCATree lcaTree;
    private Map<String, Table> interfaceImplementors = new HashMap<String, Table>();
    Map<String, WasmGCVirtualTable> result = new HashMap<String, WasmGCVirtualTable>();

    WasmGCVirtualTableBuilder() {
    }

    void build() {
        this.initTables();
        this.buildLCA();
        this.fillInterfaceImplementors();
        this.groupMethodsFromCallSites();
        this.fillTables();
        this.buildResult();
    }

    private void initTables() {
        for (String className : this.classes.getClassNames()) {
            this.initTable(className);
        }
    }

    private void initTable(String className) {
        ClassReader cls = this.classes.get(className);
        if (!cls.hasModifier(ElementModifier.INTERFACE) && !this.tableMap.containsKey(className)) {
            if (cls.getParent() != null) {
                this.initTable(cls.getParent());
            }
            Table table = new Table(cls, this.tables.size());
            this.tables.add(table);
            this.tableMap.put(className, table);
        }
    }

    private void buildLCA() {
        this.lcaTree = new LCATree(this.tables.size() + 1);
        for (int i = 0; i < this.tables.size(); ++i) {
            Table table = this.tables.get(i);
            Table parentTable = table.cls.getParent() != null ? this.tableMap.get(table.cls.getParent()) : null;
            this.lcaTree.addNode(parentTable != null ? parentTable.index + 1 : 0);
        }
    }

    private void fillInterfaceImplementors() {
        for (String className : this.classes.getClassNames()) {
            ClassReader cls = this.classes.get(className);
            if (cls.hasModifier(ElementModifier.INTERFACE)) continue;
            HashSet<String> visited = new HashSet<String>();
            do {
                Table table = this.tableMap.get(cls.getName());
                for (String itfName : cls.getInterfaces()) {
                    this.addImplementorToInterface(itfName, table, visited);
                }
            } while ((cls = cls.getParent() != null ? this.classes.get(cls.getParent()) : null) != null);
        }
    }

    private void addImplementorToInterface(String interfaceName, Table newImplementor, Set<String> visited) {
        if (!visited.add(interfaceName)) {
            return;
        }
        Table knownImplementor = this.interfaceImplementors.get(interfaceName);
        if (knownImplementor == null) {
            this.interfaceImplementors.put(interfaceName, newImplementor);
        } else {
            int lcaIndex = this.lcaTree.lcaOf(newImplementor.index + 1, knownImplementor.index + 1);
            if (lcaIndex > 0) {
                this.interfaceImplementors.put(interfaceName, this.tables.get(lcaIndex - 1));
            }
        }
        ClassReader cls = this.classes.get(interfaceName);
        if (cls != null) {
            for (String superInterface : cls.getInterfaces()) {
                this.addImplementorToInterface(superInterface, newImplementor, visited);
            }
        }
    }

    private void groupMethodsFromCallSites() {
        for (MethodReference methodRef : this.methodsAtCallSites) {
            String className = this.mapInterface(methodRef.getClassName());
            Set group = this.groupedMethodsAtCallSites.computeIfAbsent(className, k -> new LinkedHashSet());
            group.add(methodRef.getDescriptor());
        }
    }

    private String mapInterface(String name) {
        ClassReader cls = this.classes.get(name);
        if (cls == null || !cls.hasModifier(ElementModifier.INTERFACE)) {
            return name;
        }
        Table implementor = this.interfaceImplementors.get(cls.getName());
        if (implementor == null) {
            return name;
        }
        return implementor.cls.getName();
    }

    private void fillTables() {
        for (String className : this.classes.getClassNames()) {
            Table table = this.tableMap.get(className);
            if (table == null) continue;
            this.fillTable(table);
        }
    }

    private void fillTable(Table table) {
        Table parent;
        if (table.filled) {
            return;
        }
        table.filled = true;
        table.parent = parent = table.cls.getParent() != null ? this.tableMap.get(table.cls.getParent()) : null;
        ObjectIntHashMap indexes = new ObjectIntHashMap();
        if (parent != null) {
            this.fillTable(parent);
            table.entries.addAll(parent.entries);
            table.implementors.addAll(parent.implementors);
            for (Entry entry : table.entries) {
                indexes.put((Object)entry.method, entry.index);
            }
            table.currentImplementors.putAll(parent.currentImplementors);
            table.interfaces.addAll(parent.interfaces);
        }
        for (MethodReader methodReader : table.cls.getMethods()) {
            if (methodReader.hasModifier(ElementModifier.STATIC) || methodReader.hasModifier(ElementModifier.ABSTRACT) || methodReader.getProgram() == null && !methodReader.hasModifier(ElementModifier.NATIVE) || !this.isVirtual.test(methodReader.getReference()) && !methodReader.getReference().equals(CLONE_METHOD)) continue;
            table.currentImplementors.put(methodReader.getDescriptor(), methodReader.getReference());
        }
        for (String string : table.cls.getInterfaces()) {
            this.fillFromInterfaces(string, table);
        }
        Set<MethodDescriptor> group = this.groupedMethodsAtCallSites.get(table.cls.getName());
        if (group != null) {
            table.used = true;
            for (MethodDescriptor method : group) {
                if (indexes.getOrDefault((Object)method, -1) >= 0) continue;
                Entry entry = new Entry(method, table, table.entries.size());
                table.entries.add(entry);
                indexes.put((Object)method, entry.index);
                table.implementors.add(null);
            }
        }
        for (ObjectIntCursor entry : indexes) {
            MethodReference implementor = table.currentImplementors.get(entry.key);
            table.implementors.set(entry.value, implementor);
        }
    }

    private void fillFromInterfaces(String itfName, Table table) {
        if (!table.interfaces.add(itfName)) {
            return;
        }
        ClassReader cls = this.classes.get(itfName);
        if (cls == null) {
            return;
        }
        for (MethodReader methodReader : cls.getMethods()) {
            if (methodReader.hasModifier(ElementModifier.STATIC) || methodReader.hasModifier(ElementModifier.ABSTRACT) || methodReader.getProgram() == null && !methodReader.hasModifier(ElementModifier.NATIVE) || !this.isVirtual.test(methodReader.getReference()) || table.currentImplementors.get(methodReader.getDescriptor()) != null) continue;
            table.currentImplementors.put(methodReader.getDescriptor(), methodReader.getReference());
        }
        for (String string : cls.getInterfaces()) {
            this.fillFromInterfaces(string, table);
        }
    }

    private void buildResult() {
        for (String className : this.classes.getClassNames()) {
            ClassReader cls = this.classes.get(className);
            Table table = !cls.hasModifier(ElementModifier.INTERFACE) ? this.tableMap.get(className) : this.interfaceImplementors.get(className);
            if (table == null) continue;
            this.result.put(className, table.getBuildResult());
        }
    }

    private static class Table {
        final ClassReader cls;
        int index;
        boolean filled;
        boolean used;
        Table parent;
        List<Entry> entries = new ArrayList<Entry>();
        List<MethodReference> implementors = new ArrayList<MethodReference>();
        Map<MethodDescriptor, MethodReference> currentImplementors = new HashMap<MethodDescriptor, MethodReference>();
        Set<String> interfaces = new HashSet<String>();
        private WasmGCVirtualTable buildResult;

        Table(ClassReader cls, int index) {
            this.cls = cls;
            this.index = index;
        }

        WasmGCVirtualTable getBuildResult() {
            if (this.buildResult == null) {
                this.buildResult = new WasmGCVirtualTable(this.parent != null ? this.parent.getBuildResult() : null, this.cls.getName(), this.used, !this.cls.hasModifier(ElementModifier.ABSTRACT));
                this.buildResult.entries = this.entries.stream().map(Entry::getBuildResult).collect(Collectors.toList());
                this.buildResult.implementors = this.implementors.toArray(new MethodReference[0]);
            }
            return this.buildResult;
        }
    }

    private static class Entry {
        MethodDescriptor method;
        Table origin;
        int index;
        private WasmGCVirtualTableEntry buildResult;

        Entry(MethodDescriptor method, Table origin, int index) {
            this.method = method;
            this.origin = origin;
            this.index = index;
        }

        WasmGCVirtualTableEntry getBuildResult() {
            if (this.buildResult == null) {
                this.buildResult = new WasmGCVirtualTableEntry(this.origin.getBuildResult(), this.method, this.index);
            }
            return this.buildResult;
        }
    }
}

