/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.gc;

import java.util.Arrays;
import java.util.List;
import org.teavm.backend.wasm.WasmRuntime;
import org.teavm.backend.wasm.gc.StringInternDependencySupport;
import org.teavm.backend.wasm.gc.SystemArrayCopyDependencySupport;
import org.teavm.backend.wasm.gc.WasmGCReferenceQueueDependency;
import org.teavm.backend.wasm.gc.WasmGCResourceDependency;
import org.teavm.backend.wasm.runtime.gc.WasmGCSupport;
import org.teavm.dependency.AbstractDependencyListener;
import org.teavm.dependency.DependencyAgent;
import org.teavm.dependency.DependencyAnalyzer;
import org.teavm.model.MethodReference;

public class WasmGCDependencies {
    private DependencyAnalyzer analyzer;

    public WasmGCDependencies(DependencyAnalyzer analyzer) {
        this.analyzer = analyzer;
    }

    public void contribute() {
        this.analyzer.linkClass("java.lang.Class");
        this.contributeWasmRuntime();
        this.contributeMathUtils();
        this.contributeExceptionUtils();
        this.contributeInitializerUtils();
        this.contributeString();
        this.analyzer.addDependencyListener(new WasmGCReferenceQueueDependency());
        this.analyzer.addDependencyListener(new WasmGCResourceDependency());
        this.analyzer.addDependencyListener(new SystemArrayCopyDependencySupport());
    }

    public void contributeStandardExports() {
        this.analyzer.linkMethod(new MethodReference(WasmGCSupport.class, "createStringArray", Integer.TYPE, String[].class)).use();
        this.analyzer.linkMethod(new MethodReference(WasmGCSupport.class, "createStringBuilder", StringBuilder.class)).use();
        this.analyzer.linkMethod(new MethodReference(WasmGCSupport.class, "setToStringArray", String[].class, Integer.TYPE, String.class, Void.TYPE)).propagate(1, this.analyzer.getType("[java/lang/String;")).propagate(3, this.analyzer.getType("java.lang.String")).use();
        this.analyzer.linkMethod(new MethodReference(StringBuilder.class, "append", Character.TYPE, StringBuilder.class)).propagate(0, this.analyzer.getType("java.lang.StringBuilder")).use();
        this.analyzer.linkMethod(new MethodReference(StringBuilder.class, "toString", String.class)).propagate(0, this.analyzer.getType("java.lang.StringBuilder")).use();
        this.analyzer.linkMethod(new MethodReference(String.class, "length", Integer.TYPE)).propagate(0, this.analyzer.getType("java.lang.String")).use();
        this.analyzer.linkMethod(new MethodReference(String.class, "charAt", Integer.TYPE, Character.TYPE)).propagate(0, this.analyzer.getType("java.lang.String")).use();
    }

    private void contributeWasmRuntime() {
        for (Class<Double> clazz : List.of(Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE)) {
            this.analyzer.linkMethod(new MethodReference(WasmRuntime.class, "lt", clazz, clazz, Boolean.TYPE)).use();
            this.analyzer.linkMethod(new MethodReference(WasmRuntime.class, "gt", clazz, clazz, Boolean.TYPE)).use();
        }
        for (Class<Number> clazz : List.of(Integer.TYPE, Long.TYPE)) {
            this.analyzer.linkMethod(new MethodReference(WasmRuntime.class, "ltu", clazz, clazz, Boolean.TYPE)).use();
            this.analyzer.linkMethod(new MethodReference(WasmRuntime.class, "gtu", clazz, clazz, Boolean.TYPE)).use();
        }
        for (Class<Number> clazz : List.of(Float.TYPE, Double.TYPE)) {
            this.analyzer.linkMethod(new MethodReference(WasmRuntime.class, "min", clazz, clazz, clazz)).use();
            this.analyzer.linkMethod(new MethodReference(WasmRuntime.class, "max", clazz, clazz, clazz)).use();
        }
    }

    private void contributeMathUtils() {
        MethodReference method;
        for (Class type : Arrays.asList(Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE)) {
            method = new MethodReference(WasmRuntime.class, "compare", type, type, Integer.TYPE);
            this.analyzer.linkMethod(method).use();
        }
        for (Class type : Arrays.asList(Integer.TYPE, Long.TYPE)) {
            method = new MethodReference(WasmRuntime.class, "compareUnsigned", type, type, Integer.TYPE);
            this.analyzer.linkMethod(method).use();
        }
        for (Class type : Arrays.asList(Float.TYPE, Double.TYPE)) {
            method = new MethodReference(WasmRuntime.class, "remainder", type, type, type);
            this.analyzer.linkMethod(method).use();
        }
    }

    private void contributeExceptionUtils() {
        this.analyzer.linkMethod(new MethodReference(WasmGCSupport.class, "npe", NullPointerException.class)).use();
        this.analyzer.linkMethod(new MethodReference(WasmGCSupport.class, "aiiobe", ArrayIndexOutOfBoundsException.class)).use();
        this.analyzer.linkMethod(new MethodReference(WasmGCSupport.class, "cce", ClassCastException.class)).use();
        this.analyzer.linkMethod(new MethodReference(WasmGCSupport.class, "throwCloneNotSupportedException", Void.TYPE)).use();
        this.analyzer.linkMethod(new MethodReference(NullPointerException.class, "<init>", Void.TYPE)).use();
        this.analyzer.addDependencyListener(new AbstractDependencyListener(){

            @Override
            public void classReached(DependencyAgent agent, String className) {
                if (className.equals(Throwable.class.getName())) {
                    agent.linkMethod(new MethodReference(Throwable.class, "getMessage", String.class)).propagate(0, Throwable.class).use();
                }
            }
        });
    }

    private void contributeInitializerUtils() {
        this.analyzer.linkMethod(new MethodReference(WasmGCSupport.class, "nextCharArray", char[].class)).use();
    }

    private void contributeString() {
        this.analyzer.addDependencyListener(new StringInternDependencySupport());
    }
}

