/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.gc;

import org.teavm.backend.wasm.gc.PreciseValueType;
import org.teavm.backend.wasm.gc.WasmGCUtil;
import org.teavm.model.ClassHierarchy;
import org.teavm.model.ClassReader;
import org.teavm.model.MethodReference;
import org.teavm.model.PrimitiveType;
import org.teavm.model.Program;
import org.teavm.model.ValueType;
import org.teavm.model.analysis.BaseTypeInference;

public class PreciseTypeInference
extends BaseTypeInference<PreciseValueType> {
    public static final PreciseValueType OBJECT_TYPE = new PreciseValueType(ValueType.object("java.lang.Object"), false);
    private ClassHierarchy hierarchy;

    public PreciseTypeInference(Program program, MethodReference reference, ClassHierarchy hierarchy) {
        super(program, reference);
        this.hierarchy = hierarchy;
    }

    @Override
    protected PreciseValueType mapType(ValueType type) {
        return new PreciseValueType(type, false);
    }

    @Override
    protected PreciseValueType nullType() {
        return null;
    }

    @Override
    protected PreciseValueType merge(PreciseValueType a, PreciseValueType b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        if (a.valueType instanceof ValueType.Primitive && b.valueType instanceof ValueType.Primitive) {
            if (a.valueType != b.valueType) {
                PrimitiveType firstKind = ((ValueType.Primitive)a.valueType).getKind();
                PrimitiveType secondKind = ((ValueType.Primitive)b.valueType).getKind();
                if (firstKind == PrimitiveType.INTEGER ? this.isIntegerSubtype(secondKind) : secondKind == PrimitiveType.INTEGER && this.isIntegerSubtype(firstKind)) {
                    return new PreciseValueType(ValueType.INTEGER, false);
                }
                return OBJECT_TYPE;
            }
            return a;
        }
        if (a.valueType instanceof ValueType.Array) {
            if (b.valueType instanceof ValueType.Array) {
                PreciseValueType p = new PreciseValueType(((ValueType.Array)a.valueType).getItemType(), false);
                PreciseValueType q = new PreciseValueType(((ValueType.Array)b.valueType).getItemType(), false);
                return new PreciseValueType(ValueType.arrayOf(this.merge((PreciseValueType)p, (PreciseValueType)q).valueType), a.isArrayUnwrap);
            }
            return OBJECT_TYPE;
        }
        if (b.valueType instanceof ValueType.Array) {
            return OBJECT_TYPE;
        }
        if (a.valueType instanceof ValueType.Object) {
            if (b.valueType instanceof ValueType.Object) {
                ClassReader second;
                String q;
                String p = ((ValueType.Object)a.valueType).getClassName();
                if (p.equals(q = ((ValueType.Object)b.valueType).getClassName())) {
                    return a;
                }
                ClassReader first = this.hierarchy.getClassSource().get(p);
                if (first == null) {
                    p = "java.lang.Object";
                }
                if ((second = this.hierarchy.getClassSource().get(q)) == null) {
                    q = "java.lang.Object";
                }
                if (this.hierarchy.isSuperType(p, q, false)) {
                    return a;
                }
                if (this.hierarchy.isSuperType(q, p, false)) {
                    return b;
                }
                ValueType.Object result = ValueType.object(WasmGCUtil.findCommonSuperclass(this.hierarchy, first, second));
                return new PreciseValueType(result, false);
            }
            return OBJECT_TYPE;
        }
        return OBJECT_TYPE;
    }

    private boolean isIntegerSubtype(PrimitiveType type) {
        switch (type) {
            case BOOLEAN: 
            case BYTE: 
            case SHORT: 
            case CHARACTER: {
                return true;
            }
        }
        return false;
    }

    @Override
    protected PreciseValueType elementType(PreciseValueType valueType) {
        return new PreciseValueType(((ValueType.Array)valueType.valueType).getItemType(), false);
    }

    @Override
    protected PreciseValueType arrayType(PreciseValueType preciseValueType) {
        return new PreciseValueType(ValueType.arrayOf(preciseValueType.valueType), false);
    }

    @Override
    protected PreciseValueType arrayUnwrapType(PreciseValueType type) {
        return new PreciseValueType(type.valueType, true);
    }
}

